/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.ui;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ArchiveUtils {
    private static int JAR_FILE = 0;
    private static int ZIP_FILE = 1;
    private static String m_fileSep = System.getProperty("file.separator");

    public static void createJarFromDirectory(String inputDir, String outputPath) throws Exception {
        ArchiveUtils.createArchiveFromDirectory(inputDir, outputPath, JAR_FILE);
    }

    public static void createZipFromDirectory(String inputDir, String outputPath) throws Exception {
        ArchiveUtils.createArchiveFromDirectory(inputDir, outputPath, ZIP_FILE);
    }

    private static void createArchiveFromDirectory(String inputDir, String outputPath, int type) throws IOException, Exception {
        FileOutputStream fos = new FileOutputStream(outputPath);
        ZipOutputStream zos = null;
        if (type == ZIP_FILE) {
            zos = new ZipOutputStream(fos);
        } else if (type == JAR_FILE) {
            zos = new JarOutputStream(fos);
        }
        if (zos != null) {
            File dir = new File(inputDir);
            if (dir.exists() && dir.isDirectory()) {
                ArchiveUtils.archiveDirectory(zos, dir, inputDir);
            }
            zos.close();
        }
    }

    private static void archiveDirectory(ZipOutputStream zos, File directory, String theBaseDir) throws Exception {
        String baseDir = theBaseDir;
        if (directory.isDirectory() && directory.exists()) {
            File[] list = directory.listFiles();
            if (!baseDir.endsWith(File.separator)) {
                baseDir = String.valueOf(baseDir) + File.separator;
            }
            int index = 0;
            while (index < list.length) {
                if (list[index].isDirectory()) {
                    ArchiveUtils.archiveDirectory(zos, list[index], baseDir);
                } else {
                    ArchiveUtils.addFileEntry(zos, list[index], baseDir);
                    ArchiveUtils.addFileToArchive(zos, list[index]);
                    zos.closeEntry();
                }
                ++index;
            }
        }
    }

    private static void addFileEntry(ZipOutputStream zos, File file, String baseDir) throws IOException {
        String fileEntry = file.getPath().substring(baseDir.length() - 1).replace(File.separatorChar, '/');
        while (fileEntry.startsWith("/")) {
            fileEntry = fileEntry.substring(1);
        }
        ArchiveUtils.addFileEntry(zos, fileEntry, file.lastModified());
    }

    public static void addFileEntry(ZipOutputStream zos, String fileEntry, long lastModified) throws IOException {
        ZipEntry zipEntry = zos instanceof JarOutputStream ? new JarEntry(fileEntry) : new ZipEntry(fileEntry);
        zipEntry.setTime(lastModified);
        zos.putNextEntry(zipEntry);
    }

    public static void addFileToArchive(ZipOutputStream zos, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file.getPath());
        ArchiveUtils.addFileToArchive(zos, fis);
    }

    public static void addFileToArchive(ZipOutputStream zos, InputStream inStream) throws IOException {
        int nRead;
        byte[] buffer = new byte[1024];
        while ((nRead = inStream.read(buffer, 0, buffer.length)) > 0) {
            zos.write(buffer, 0, nRead);
        }
        inStream.close();
    }

    public static void extractJarResourcesIntoDirectory(String targetDir, String jarFileName) {
        try {
            Hashtable<String, Integer> htSizes = new Hashtable<String, Integer>();
            JarFile jf = new JarFile(jarFileName);
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                JarEntry ze = e.nextElement();
                htSizes.put(ze.getName(), new Integer((int)ze.getSize()));
            }
            jf.close();
            FileInputStream fis = new FileInputStream(jarFileName);
            BufferedInputStream bis = new BufferedInputStream(fis);
            JarInputStream jis = new JarInputStream(bis);
            JarEntry je = null;
            while ((je = (JarEntry)jis.getNextEntry()) != null) {
                String tmpFolderName;
                File tempFolder;
                if (je.isDirectory() && !(tempFolder = new File(tmpFolderName = String.valueOf(targetDir) + m_fileSep + je.getName())).mkdir()) {
                    System.out.println("Unable to create directory: " + tmpFolderName);
                    return;
                }
                int size = (int)je.getSize();
                if (size == -1) {
                    size = (Integer)htSizes.get(je.getName());
                }
                byte[] b = new byte[size];
                int rb = 0;
                int chunk = 0;
                while (size - rb > 0) {
                    chunk = jis.read(b, rb, size - rb);
                    if (chunk == -1) break;
                    rb += chunk;
                }
                String fname = String.valueOf(targetDir) + m_fileSep + je.getName();
                ArchiveUtils.createResourceOnFileSystem(b, fname);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createResourceOnFileSystem(byte[] b, String fname) {
        try {
            File f = new File(fname);
            File dir = new File(f.getParent());
            if (!dir.exists() && !dir.mkdirs()) {
                System.out.println("Unable to create dir: " + f.getParent());
                return;
            }
            FileOutputStream fos = new FileOutputStream(fname);
            fos.write(b);
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

