/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.project;

import com.rsi.idldt.core.IDLProjectNature;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.jdml.PlatformSupport;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NewProjectWizardPage
extends WizardPage {
    private static final String PAGE_NAME = "NewIdlProjectWizardPage";
    private static final String SETTINGS_ADDTOPATH = "add_to_path";
    private final int margin = 5;
    private final int majorSpacing = 10;
    private final int minorSpacing = 5;
    private Text projectNameText;
    Button projectLocationUseWorkspace;
    private Label projectLocationLabel;
    Text projectLocationText;
    private Button projectLocationBrowser;
    private Listener projectLocationListener;
    private Button addToPathButton;
    private boolean m_addToPathSetting = true;

    public NewProjectWizardPage(String pageName, IWizard wizard) {
        super(pageName);
        this.setWizard(wizard);
        this.init();
    }

    public NewProjectWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.init();
    }

    private void init() {
        IDialogSettings section;
        this.setTitle(Messages.NewProjWiz_Title);
        ImageDescriptor imageDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.rsi.idldt.ui", (String)"icons/newprj_banner.png");
        this.setImageDescriptor(imageDesc);
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null && (section = dialogSettings.getSection(PAGE_NAME)) != null) {
            this.m_addToPathSetting = section.getBoolean(SETTINGS_ADDTOPATH);
        }
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)base, "com.rsi.idldt.ui.wizard_new_project");
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        formLayout.spacing = 10;
        base.setLayout((Layout)formLayout);
        Composite nameComposite = this.createProjectNameControls(base);
        Composite locationComposite = this.createProjectLocationControls(base);
        Composite pathComposite = this.createAddToPathControls(base);
        FormData data = null;
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment(0);
        nameComposite.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment((Control)nameComposite, 0, 1024);
        locationComposite.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        pathComposite.setLayoutData((Object)data);
        this.validateProperties();
        this.setControl((Control)base);
    }

    private Composite createProjectNameControls(Composite parent) {
        Composite base = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        base.setLayout((Layout)formLayout);
        Label label = new Label(base, 16384);
        label.setText(Messages.NewProjWiz_NameLabel);
        Text text = new Text(base, 2052);
        FormData data = null;
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment((Control)text, 0, 0x1000000);
        label.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)label);
        data.right = new FormAttachment(100);
        text.setLayoutData((Object)data);
        this.projectNameText = text;
        this.projectNameText.setText(IDLProjectNature.getNewProjectName());
        this.projectNameText.selectAll();
        text.addListener(24, (Listener)new ProjectNameListener());
        return base;
    }

    private Composite createProjectLocationControls(Composite parent) {
        Group base = new Group(parent, 0);
        base.setText(Messages.NewProjWiz_LocationGroupText);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        formLayout.spacing = 5;
        base.setLayout((Layout)formLayout);
        Button useWorkspace = new Button((Composite)base, 16);
        useWorkspace.setText(Messages.NewProjWiz_UseWorkspaceButtonText);
        useWorkspace.setSelection(true);
        Button useExternal = new Button((Composite)base, 16);
        useExternal.setText(Messages.NewProjWiz_UseExternalButtonText);
        Label label = new Label((Composite)base, 16384);
        label.setText(Messages.NewProjWiz_LocationLabel);
        Text path = new Text((Composite)base, 2052);
        path.setText("");
        Button browse = new Button((Composite)base, 8);
        browse.setText(Messages.NewProjWiz_BrowseButton);
        FormData data = null;
        data = new FormData();
        data.left = new FormAttachment(0);
        useWorkspace.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment((Control)useWorkspace, 0, 1024);
        useExternal.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment((Control)path, 0, 0x1000000);
        label.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)label);
        data.top = new FormAttachment((Control)useExternal, 0, 1024);
        data.right = new FormAttachment((Control)browse);
        path.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)path, 0, 0x1000000);
        data.right = new FormAttachment(100);
        this.initializeDialogUnits((Control)browse);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = browse.computeSize(-1, -1, true);
        data.width = Math.max(widthHint, minSize.x);
        browse.setLayoutData((Object)data);
        this.projectLocationUseWorkspace = useWorkspace;
        this.projectLocationLabel = label;
        this.projectLocationText = path;
        this.projectLocationBrowser = browse;
        this.updateProjectLocationControls(this.projectLocationUseWorkspace.getSelection());
        useWorkspace.addSelectionListener((SelectionListener)new UseWorkspaceListener());
        this.projectLocationListener = new ProjectLocationListener();
        path.addListener(24, this.projectLocationListener);
        browse.addListener(13, (Listener)new BrowseListener(browse.getShell()));
        return base;
    }

    private Composite createAddToPathControls(Composite parent) {
        Composite base = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        base.setLayout((Layout)formLayout);
        Button checkButton = new Button(base, 32);
        checkButton.setText(Messages.IDLProjectPropertyPage_OnPath);
        checkButton.setSelection(this.m_addToPathSetting);
        this.addToPathButton = checkButton;
        return base;
    }

    public String getProjectName() {
        return this.projectNameText.getText();
    }

    public void saveState() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            IDialogSettings section = dialogSettings.getSection(PAGE_NAME);
            if (section == null) {
                section = dialogSettings.addNewSection(PAGE_NAME);
            }
            section.put(SETTINGS_ADDTOPATH, this.getAddToIDLPath());
        }
    }

    void setProjectLocation(String path) {
        if (this.projectLocationListener != null) {
            this.projectLocationText.removeListener(24, this.projectLocationListener);
        }
        if (path != null) {
            this.projectLocationText.setText(path);
            this.projectLocationText.setSelection(path.length());
        } else {
            this.projectLocationText.setText("");
        }
        if (this.projectLocationListener != null) {
            this.projectLocationText.addListener(24, this.projectLocationListener);
        }
    }

    public String getProjectLocation() {
        return this.projectLocationText.getText();
    }

    public String getProjectLocation(boolean withProjectName) {
        String s = this.getProjectLocation();
        if (withProjectName) {
            s = String.valueOf(s) + File.separator + this.projectNameText.getText();
        }
        return s;
    }

    public IPath getProjectLocationAsPath() {
        IPath p2;
        if (this.projectLocationUseWorkspace.getSelection()) {
            return null;
        }
        String location = this.getProjectLocation();
        IPath p1 = this.getCanonicalPath(location);
        return p1.equals((Object)(p2 = this.getCanonicalPath(this.getDefaultProjectLocation()))) ? null : new Path(location);
    }

    public boolean getAddToIDLPath() {
        return this.addToPathButton.getSelection();
    }

    void validateProperties() {
        this.setMessage(Messages.NewProjWiz_MsgCreate, 0);
        boolean valid = this.validateProjectName() && this.validateProjectLocation();
        this.setPageComplete(valid);
    }

    private boolean validateProjectName() {
        String name = this.getProjectName();
        if (name == null || name.length() <= 0) {
            this.setMessage(Messages.NewProjWiz_MsgEnterName, 3);
        } else if (name.indexOf(File.separatorChar) != -1) {
            this.setMessage(Messages.bind(Messages.NewProjWiz_MsgBadCharacterInName, File.separator), 3);
        } else if (IDLProjectNature.doesProjectExist((String)name)) {
            this.setMessage(Messages.NewProjWiz_MsgNameAlreadyUsed, 3);
        } else if (!name.equals(name.trim())) {
            this.setMessage(Messages.NewProjWiz_MsgNameNoBeginEndSpaces, 3);
        }
        return this.getMessageType() != 3;
    }

    private boolean validateProjectLocation() {
        String location = this.getProjectLocation();
        File f = new File(location);
        if (!f.exists()) {
            this.setMessage(Messages.NewProjWiz_MsgLocationNotValid, 3);
            return false;
        }
        if (!f.canWrite()) {
            this.setMessage(Messages.NewProjWiz_MsgNotWritable, 3);
            return false;
        }
        if (!f.isDirectory()) {
            this.setMessage(Messages.NewProjWiz_MsgLocationNotValid, 3);
            return false;
        }
        if (PlatformSupport.isWindows()) {
            File tempF;
            try {
                tempF = File.createTempFile("hermione", ".jkr", f);
            }
            catch (IOException iOException) {
                this.setMessage(Messages.NewProjWiz_MsgNotWritable, 3);
                return false;
            }
            if (tempF == null) {
                this.setMessage(Messages.NewProjWiz_MsgNotWritable, 3);
                return false;
            }
            tempF.delete();
        }
        location = this.getProjectLocation(true);
        IProject[] projects = this.getExistingProjects();
        int i = 0;
        while (i < projects.length) {
            String s = projects[i].getLocation().toOSString();
            if (this.pathsOverlap(location, s)) {
                this.setMessage(String.valueOf(Messages.NewProjWiz_MsgProjectsOverlap) + projects[i].getName() + ".", 3);
                break;
            }
            ++i;
        }
        return this.getMessageType() != 3;
    }

    String getDefaultProjectLocation() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        return root.getRawLocation().toOSString();
    }

    private IProject[] getExistingProjects() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.getRoot().getProjects();
    }

    private boolean pathsOverlap(String s1, String s2) {
        IPath p1 = this.getCanonicalPath(s1);
        IPath p2 = this.getCanonicalPath(s2);
        if (p1 == null || p2 == null) {
            return false;
        }
        return p1.isPrefixOf(p2) || p2.isPrefixOf(p1);
    }

    private IPath getCanonicalPath(String theString) {
        String s = theString;
        File f = new File(s);
        try {
            s = f.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.setMessage(Messages.NewProjWiz_MsgErrorComputingCanonicalPath, 2);
            s = f.getAbsolutePath();
        }
        return new Path(s);
    }

    void updateProjectLocationControls(boolean useWorkspace) {
        this.projectLocationLabel.setEnabled(!useWorkspace);
        this.projectLocationText.setEnabled(!useWorkspace);
        this.projectLocationBrowser.setEnabled(!useWorkspace);
        this.projectLocationText.setText(useWorkspace ? this.getDefaultProjectLocation() : "");
    }

    private class BrowseListener
    implements Listener {
        private Shell shell;

        public BrowseListener(Shell s) {
            this.shell = s;
        }

        public void handleEvent(Event event) {
            if (event.type == 13) {
                DirectoryDialog dialog = new DirectoryDialog(this.shell);
                dialog.setText(Messages.NewProjWiz_BrowseDialogTitle);
                dialog.setMessage(Messages.NewProjWiz_BrowseDialogInstructions);
                dialog.setFilterPath(this.getBrowseDir());
                String path = dialog.open();
                if (path != null) {
                    NewProjectWizardPage.this.setProjectLocation(path);
                    NewProjectWizardPage.this.validateProperties();
                }
            }
        }

        private String getBrowseDir() {
            String s = NewProjectWizardPage.this.projectLocationText.getText();
            File f = new File(s);
            if (!f.exists()) {
                s = NewProjectWizardPage.this.getDefaultProjectLocation();
            }
            return s;
        }
    }

    class ProjectLocationListener
    implements Listener {
        ProjectLocationListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 24) {
                NewProjectWizardPage.this.validateProperties();
            }
        }
    }

    class ProjectNameListener
    implements Listener {
        ProjectNameListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 24) {
                NewProjectWizardPage.this.validateProperties();
            }
        }
    }

    class UseWorkspaceListener
    implements SelectionListener {
        UseWorkspaceListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            NewProjectWizardPage.this.updateProjectLocationControls(NewProjectWizardPage.this.projectLocationUseWorkspace.getSelection());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

