/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.project;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IDLProjectNature;
import com.rsi.idldt.core.projects.IIDLProjectManager;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.project.NewProjectWizardPage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class NewProjectWizard
extends Wizard
implements INewWizard {
    private final String NEW_IDL_PROJECT_PAGE = "New IDL Project Page";
    NewProjectWizardPage thePage;

    public NewProjectWizard() {
        this.setWindowTitle(Messages.NewProjWiz_Title);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        IDialogSettings workbenchSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = workbenchSettings.getSection("NewIdlProjectWizard");
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection("NewIdlProjectWizard");
        }
        this.setDialogSettings(wizardSettings);
    }

    public void addPages() {
        this.thePage = new NewProjectWizardPage("New IDL Project Page", (IWizard)this);
        this.addPage((IWizardPage)this.thePage);
    }

    public boolean performFinish() {
        ProjectCreator op = new ProjectCreator();
        op.init(this.thePage.getProjectName(), this.thePage.getProjectLocationAsPath(), this.thePage.getAddToIDLPath());
        this.thePage.saveState();
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewProjWiz_MsgError, (String)realException.getMessage());
            return false;
        }
        return op.projectCreated();
    }

    class ProjectCreator
    implements IRunnableWithProgress {
        private String m_projectName;
        private IPath m_projectPath;
        private boolean m_addToPath;
        private boolean failed = false;

        ProjectCreator() {
        }

        public void init(String name, IPath path, boolean addToPath) {
            this.m_projectName = name;
            this.m_projectPath = path;
            this.m_addToPath = addToPath;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            IIDLProjectManager projectManager = IDLProcessManager.getActiveProcess().getProjectManager();
            try {
                if (this.m_projectPath != null) {
                    int n = this.countFiles(this.m_projectPath.toFile());
                    monitor.beginTask(Messages.NewProjWiz_MonitorMsg, n);
                    projectManager.setProgressMonitor(monitor);
                } else {
                    monitor.beginTask(Messages.NewProjWiz_MonitorMsg, -1);
                }
                this.doFinish(this.m_projectName, this.m_projectPath, this.m_addToPath);
            }
            finally {
                projectManager.setProgressMonitor(null);
                monitor.done();
            }
        }

        private void doFinish(String projectName, IPath projectPath, boolean addToPath) {
            IProject project = IDLProjectNature.createIDLProject((String)projectName, (IPath)projectPath, (boolean)addToPath);
            if (project == null) {
                String errmsg = IDLProjectNature.getProjectCreationErrorMessage();
                if (errmsg != null && errmsg.length() > 0) {
                    this.setPageError(errmsg);
                } else {
                    this.setPageError("Unable to create new IDL project.");
                }
                this.failed = true;
            }
        }

        public boolean projectCreated() {
            return !this.failed;
        }

        protected void setPageError(final String errMsg) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ((ProjectCreator)ProjectCreator.this).NewProjectWizard.this.thePage.setMessage(errMsg, 3);
                }
            });
        }

        private int countFiles(File d) {
            File[] children = d.listFiles();
            int n = children.length;
            int i = 0;
            while (i < children.length) {
                if (children[i].isDirectory()) {
                    n += this.countFiles(children[i]);
                }
                ++i;
            }
            return n;
        }
    }
}

