/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.profiler;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.interp.AbstractIDLCommand;
import com.rsi.idldt.core.interp.ICommandListener;
import com.rsi.idldt.profiler.ProfilerView;
import com.rsi.idldt.profiler.Routine;
import com.rsi.jdml.DMLAccess;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutineList
implements ICommandListener {
    public LinkedList<Routine> routines = new LinkedList();
    public int maxCount;
    public double maxTimeSelf;
    public double maxTimeChildren;
    public double maxTimeSelfHit;
    public double maxTimeChildrenHit;
    private String m_tmpfile = null;
    ProfilerView m_view = null;

    public boolean add(Routine routine) {
        boolean added = this.routines.add(routine);
        return added;
    }

    public boolean remove(Routine routine) {
        boolean removed = this.routines.remove(routine);
        return removed;
    }

    public int findRoutine(String name) {
        Routine routine = new Routine();
        routine.setName(name);
        return Collections.binarySearch(this.routines, routine);
    }

    public void clearResults() {
        this.routines.clear();
    }

    public void refreshResults(ProfilerView view) {
        this.m_view = view;
        this.clearResults();
        if (this.m_tmpfile == null) {
            this.m_tmpfile = System.getProperty("java.io.tmpdir");
            if (this.m_tmpfile.length() > 0 && this.m_tmpfile.charAt(this.m_tmpfile.length() - 1) != File.separatorChar) {
                this.m_tmpfile = String.valueOf(this.m_tmpfile) + File.separatorChar;
            }
            this.m_tmpfile = String.valueOf(this.m_tmpfile) + "idlWorkbenchProfiler.txt";
        }
        final String cmd = "Profiler,/REPORT,FILENAME=\"" + this.m_tmpfile + '\"';
        IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
        AbstractIDLCommand c = new AbstractIDLCommand(){
            {
                this.setUpdateDebugModel(false);
            }

            public void activate(IIDLProcessProxy idl1) {
                DMLAccess.silentExecuteString((long)idl1.getDebugID(), (String)cmd);
            }

            public boolean shouldReplaceDuplicate() {
                return true;
            }
        };
        c.addCommandListener((ICommandListener)this);
        idl.queueCommand(c);
    }

    private void updateMaximums() {
        Iterator i = this.routines.iterator();
        this.maxCount = 0;
        this.maxTimeSelf = 0.0;
        this.maxTimeChildren = 0.0;
        this.maxTimeSelfHit = 0.0;
        this.maxTimeChildrenHit = 0.0;
        while (i.hasNext()) {
            double timeChildrenHit;
            double timeChildren;
            double timeSelf;
            Routine routine = (Routine)i.next();
            int count = routine.getCount();
            if (count == 0) continue;
            if (count > this.maxCount) {
                this.maxCount = count;
            }
            if ((timeSelf = routine.getTimeSelf()) > this.maxTimeSelf) {
                this.maxTimeSelf = timeSelf;
            }
            if ((timeChildren = routine.getTimeChildren()) > this.maxTimeChildren) {
                this.maxTimeChildren = timeChildren;
            }
            if (count <= 0) continue;
            double timeSelfHit = timeSelf / (double)count;
            if (timeSelfHit > this.maxTimeSelfHit) {
                this.maxTimeSelfHit = timeSelfHit;
            }
            if (!((timeChildrenHit = timeChildren / (double)count) > this.maxTimeChildrenHit)) continue;
            this.maxTimeChildrenHit = timeChildrenHit;
        }
    }

    public List<Routine> getRoutines() {
        return Collections.unmodifiableList(this.routines);
    }

    public void commandStarted() {
    }

    public void commandFinished() {
        String date;
        FileInputStream fis;
        if (this.m_view == null) {
            return;
        }
        String line = "";
        try {
            fis = new FileInputStream(this.m_tmpfile);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            return;
        }
        InputStreamReader isr = new InputStreamReader(fis);
        LineNumberReader lnr = new LineNumberReader(isr);
        try {
            line = lnr.readLine();
            date = lnr.readLine();
            line = lnr.readLine();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        while (true) {
            String routineName;
            try {
                line = lnr.readLine();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                break;
            }
            if (line == null) break;
            String[] fields = line.split("\\s+");
            if (fields.length < 6 || "PROFILER".compareTo(routineName = fields[5]) == 0) continue;
            int count = Integer.parseInt(fields[1]);
            double timeSelf = Double.parseDouble(fields[2]);
            double timeChildren = Double.parseDouble(fields[3]);
            boolean isSystem = Integer.parseInt(fields[4]) == 1;
            int index = -1;
            if (index >= 0) {
                Routine routine = this.routines.get(index);
                routine.setCount(count);
                routine.setTimeSelf(timeSelf);
                routine.setTimeChildren(timeChildren);
                continue;
            }
            this.routines.add(-(index + 1), new Routine(routineName, isSystem, count, timeSelf, timeChildren));
        }
        try {
            fis.close();
            File f = new File(this.m_tmpfile);
            f.delete();
        }
        catch (IOException iOException) {}
        this.updateMaximums();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                RoutineList.this.m_view.getViewSite().getActionBars().getStatusLineManager().setMessage(date);
                RoutineList.this.m_view.refresh(true);
            }
        });
    }
}

