/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.profiler;

import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.utils.Tracer;
import com.rsi.idldt.internal.ui.FilteredTextContributionItem;
import com.rsi.idldt.internal.ui.IComboFilterer;
import com.rsi.idldt.proeditor.utils.ProEditorUtilities;
import com.rsi.idldt.profiler.ProfilerFilter;
import com.rsi.idldt.profiler.ProfilerLabelProvider;
import com.rsi.idldt.profiler.ProfilerSorter;
import com.rsi.idldt.profiler.ProfilerText;
import com.rsi.idldt.profiler.Routine;
import com.rsi.idldt.profiler.RoutineList;
import com.rsi.idldt.ui.UIPlugin;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ProfilerView
extends ViewPart
implements Listener,
IComboFilterer {
    ProfilerView m_view;
    private RoutineList m_routineList;
    static TableViewer m_tableViewer;
    Table m_table;
    FilteredTextContributionItem m_filter;

    public void createPartControl(Composite parent) {
        this.m_view = this;
        this.createMenu();
        this.createToolbar();
        this.createTable(parent);
    }

    public void createActions() {
    }

    private void createMenu() {
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        this.m_filter = new FilteredTextContributionItem(this.m_view);
        this.m_filter.setHelp("com.rsi.idldt.ui.view_profiler");
        mgr.add((IContributionItem)this.m_filter);
    }

    private void createTable(Composite parent) {
        this.m_routineList = new RoutineList();
        m_tableViewer = new TableViewer(parent, 98304);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(m_tableViewer.getControl(), "com.rsi.idldt.ui.view_profiler");
        m_tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object arg0) {
                return ((RoutineList)arg0).getRoutines().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }
        });
        ProfilerLabelProvider labelProvider = new ProfilerLabelProvider(this, this.m_routineList);
        m_tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        m_tableViewer.setSorter((ViewerSorter)new ProfilerSorter());
        m_tableViewer.addFilter((ViewerFilter)new ProfilerFilter());
        this.m_table = m_tableViewer.getTable();
        this.m_table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        this.m_table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (event.button != 1) {
                    return;
                }
                TableItem item = ProfilerView.this.m_table.getItem(new Point(2, event.y));
                if (item == null) {
                    return;
                }
                Routine routine = (Routine)m_tableViewer.getElementAt(ProfilerView.this.m_table.getSelectionIndex());
                ProfilerView.this.showInEditor(routine);
            }
        });
        this.m_table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13) {
                    Routine routine = (Routine)m_tableViewer.getElementAt(ProfilerView.this.m_table.getSelectionIndex());
                    ProfilerView.this.showInEditor(routine);
                    return;
                }
                if (event.keyCode == 0x100000E && event.stateMask == 0) {
                    RoutineList list = (RoutineList)ProfilerView.this.m_view.getViewer().getInput();
                    list.refreshResults(ProfilerView.this.m_view);
                    return;
                }
                if (event.keyCode == 99 && event.stateMask == SWT.MOD1) {
                    ProfilerText text = new ProfilerText((IViewPart)ProfilerView.this.m_view);
                    text.copy();
                    text.dispose();
                    return;
                }
                if (event.character >= ' ' && event.character <= '~' && ProfilerView.this.m_filter != null) {
                    ProfilerView.this.m_filter.setText(String.valueOf(event.character));
                    event.doit = false;
                }
            }
        });
        TableColumn tc = new TableColumn(this.m_table, 16384);
        tc = new TableColumn(this.m_table, 16384);
        tc.addSelectionListener((SelectionListener)new ProfilerColumnListener(1));
        tc = new TableColumn(this.m_table, 131072);
        tc.setMoveable(true);
        tc.addSelectionListener((SelectionListener)new ProfilerColumnListener(2));
        tc = new TableColumn(this.m_table, 131072);
        tc.setMoveable(true);
        tc.addSelectionListener((SelectionListener)new ProfilerColumnListener(3));
        tc = new TableColumn(this.m_table, 131072);
        tc.setMoveable(true);
        tc.addSelectionListener((SelectionListener)new ProfilerColumnListener(4));
        tc = new TableColumn(this.m_table, 131072);
        tc.setMoveable(true);
        tc.addSelectionListener((SelectionListener)new ProfilerColumnListener(5));
        tc = new TableColumn(this.m_table, 131072);
        tc.setMoveable(true);
        tc.addSelectionListener((SelectionListener)new ProfilerColumnListener(6));
        labelProvider.setUnits(true);
        m_tableViewer.setInput((Object)this.m_routineList);
        int i = 0;
        int n = this.m_table.getColumnCount();
        while (i < n) {
            this.m_table.getColumn(i).pack();
            ++i;
        }
        this.m_table.getColumn(0).setWidth(0);
        this.m_table.getColumn(0).setResizable(false);
        this.m_table.getColumn(1).setWidth(200);
    }

    public final TableViewer getViewer() {
        return m_tableViewer;
    }

    public final void refresh(boolean repack) {
        if (repack) {
            this.m_table.setRedraw(false);
        }
        m_tableViewer.refresh();
        if (!repack) {
            return;
        }
        int i = 2;
        int n = this.m_table.getColumnCount();
        while (i < n) {
            this.m_table.getColumn(i).pack();
            ++i;
        }
        this.m_table.setRedraw(true);
    }

    public void updateFilter(String filter) {
        ProfilerFilter filterer = (ProfilerFilter)m_tableViewer.getFilters()[0];
        String oldFilter = filterer.getFilter();
        if (oldFilter == null || oldFilter.compareToIgnoreCase(filter) != 0) {
            filterer.setFilter(filter);
            this.m_table.setRedraw(false);
            m_tableViewer.refresh();
            this.m_table.setRedraw(true);
        }
    }

    public void handleEvent(Event event) {
        Tracer.trace((boolean)UIPlugin.IS_DEBUGGING, (String)("ProfilerView.handleEvent event.type=" + event.type));
    }

    void showInEditor(Routine routine) {
        if (routine == null || routine.getIsSystem()) {
            return;
        }
        String name = routine.getName();
        IDOMNode node = ProEditorUtilities.findNodeByName(name);
        if (node != null) {
            ProEditorUtilities.openEditorToNode(node);
            return;
        }
        ProEditorUtilities.openEditorToIDLName(name);
    }

    public void setFocus() {
    }

    private class ProfilerColumnListener
    extends SelectionAdapter {
        int m_columnID;

        public ProfilerColumnListener(int columnID) {
            this.m_columnID = columnID;
        }

        public void widgetSelected(SelectionEvent event) {
            ProfilerSorter sorter = (ProfilerSorter)m_tableViewer.getSorter();
            sorter.doSort(this.m_columnID);
            ProfilerView.this.m_table.setSortColumn(ProfilerView.this.m_table.getColumn(this.m_columnID));
            ProfilerView.this.m_table.setSortDirection(sorter.direction);
            m_tableViewer.refresh();
            if (ProfilerView.this.m_table.getItemCount() > 0) {
                ProfilerView.this.m_table.showItem(ProfilerView.this.m_table.getItem(0));
            }
        }
    }
}

