/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.profiler;

import com.rsi.idldt.actions.OpenLocalFileAction;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.profiler.ProfilerView;
import com.rsi.idldt.profiler.Routine;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;

public class ProfilerText {
    private ProfilerView m_view;
    private StyledText m_text;
    private static String m_filterPath = null;

    public ProfilerText(IViewPart view) {
        this.m_view = (ProfilerView)view;
        TableViewer tv = this.m_view.getViewer();
        Table table = tv.getTable();
        int count = table.getItemCount();
        Shell shell = this.m_view.getSite().getShell();
        this.m_text = new StyledText((Composite)shell, 2);
        int[] nArray = new int[7];
        nArray[1] = 40;
        nArray[2] = 10;
        nArray[3] = 15;
        nArray[4] = 15;
        nArray[5] = 15;
        nArray[6] = 15;
        int[] widths = nArray;
        StringBuffer buffer = new StringBuffer(113);
        int i = 0;
        while (i < 110) {
            buffer.append(' ');
            ++i;
        }
        int[] indices = table.getColumnOrder();
        int curPosition = 0;
        int col = 1;
        while (col < 7) {
            int w;
            TableColumn tc = table.getColumn(indices[col]);
            String label = tc.getText();
            int len = label.length();
            if (len > (w = widths[indices[col]] - 1)) {
                len = w;
            }
            int index = curPosition;
            if (indices[col] != 1) {
                index += w - len;
            }
            int i2 = 0;
            while (i2 < len) {
                buffer.setCharAt(index + i2, label.charAt(i2));
                ++i2;
            }
            curPosition += w + 1;
            ++col;
        }
        String crlf = this.m_text.getLineDelimiter();
        buffer.append(crlf);
        this.m_text.append(buffer.toString());
        StyleRange style = new StyleRange(0, this.m_text.getCharCount(), null, null, 1);
        this.m_text.setStyleRange(style);
        int nameStart = 0;
        int item = 0;
        while (item < count) {
            Routine routine = (Routine)tv.getElementAt(item);
            curPosition = 0;
            int i3 = 0;
            while (i3 < 110) {
                buffer.setCharAt(i3, ' ');
                ++i3;
            }
            int col2 = 1;
            while (col2 < 7) {
                int w;
                TableItem tableItem = table.getItem(item);
                String label = tableItem.getText(indices[col2]);
                int len = label.length();
                if (len > (w = widths[indices[col2]] - 1)) {
                    len = w;
                }
                int index = curPosition;
                if (indices[col2] == 1) {
                    nameStart = this.m_text.getCharCount() + index;
                } else {
                    index += w - len;
                }
                int i4 = 0;
                while (i4 < len) {
                    buffer.setCharAt(index + i4, label.charAt(i4));
                    ++i4;
                }
                curPosition += w + 1;
                ++col2;
            }
            this.m_text.append(buffer.toString());
            if (routine.getIsSystem()) {
                style = new StyleRange(nameStart, widths[1], null, null, 2);
                this.m_text.setStyleRange(style);
            }
            ++item;
        }
    }

    public void print() {
        Shell shell = this.m_view.getSite().getShell();
        PrintDialog dialog = new PrintDialog(shell);
        PrinterData printerData = dialog.open();
        if (printerData == null) {
            return;
        }
        Printer printer = new Printer(printerData);
        Rectangle rect = printer.getBounds();
        Point dpi = printer.getDPI();
        GC gc = new GC((Drawable)printer);
        Font font0 = new Font((Device)printer, "Courier New", 10, 0);
        gc.setFont(font0);
        int charWidth = gc.stringExtent((String)" ").x;
        int pointSize = 10 * (rect.width - 2 * dpi.x) / (110 * charWidth);
        if (pointSize < 6) {
            pointSize = 6;
        }
        if (pointSize > 12) {
            pointSize = 12;
        }
        gc.dispose();
        font0.dispose();
        Font font = new Font((Device)shell.getDisplay(), "Courier New", pointSize, 0);
        this.m_text.setFont(font);
        StyledTextPrintOptions options = new StyledTextPrintOptions();
        options.printTextFontStyle = true;
        options.header = "\t" + Messages.ProfilerPrintAction_Header + "\t";
        options.footer = "DateFormat.getDateTimeInstance().format(new Date()\t\t<page>";
        options.jobName = Messages.ProfilerPrintAction_Header;
        Runnable r = this.m_text.print(printer, options);
        r.run();
        font.dispose();
    }

    public void copy() {
        Shell shell = this.m_view.getSite().getShell();
        Font font = new Font((Device)shell.getDisplay(), "Courier New", 7, 0);
        this.m_text.setFont(font);
        this.m_text.selectAll();
        this.m_text.copy();
        font.dispose();
    }

    public void save() {
        if (m_filterPath == null) {
            m_filterPath = OpenLocalFileAction.getFilterPath();
        }
        Shell shell = this.m_view.getSite().getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterPath(m_filterPath);
        dialog.setFileName("IDLProfiler.txt");
        String path = dialog.open();
        if (path != null) {
            m_filterPath = dialog.getFilterPath();
            File file = new File(path);
            boolean doSave = true;
            if (file.exists()) {
                try {
                    doSave = this.askForOverwritePermission(shell, file);
                    if (doSave && !file.delete()) {
                        MessageBox box = new MessageBox(shell, 33);
                        box.setText(Messages.SaveAction_ErrorMsgBoxText);
                        box.setMessage(Messages.bind(Messages.SaveAction_ErrorMsgBoxMessage, file.getAbsolutePath()));
                        doSave = false;
                    }
                }
                catch (Exception e) {
                    this.showError(shell, e);
                    doSave = false;
                }
            }
            if (doSave) {
                try {
                    FileOutputStream fout = new FileOutputStream(file);
                    new PrintStream(fout).print(this.m_text.getText());
                    fout.close();
                }
                catch (Exception e) {
                    this.showError(shell, e);
                }
            }
        }
    }

    private boolean askForOverwritePermission(Shell shell, File file) {
        boolean doSave = true;
        String osName = System.getProperty("os.name");
        if (osName.compareToIgnoreCase("Mac OS X") != 0) {
            MessageBox box = new MessageBox(shell, 200);
            box.setText(Messages.SaveAction_OverwriteMsgBoxText);
            box.setMessage(Messages.bind(Messages.SaveAction_OverwriteMsgBoxMessage, file.getName()));
            doSave = box.open() == 64;
        }
        return doSave;
    }

    private void showError(Shell shell, Exception e) {
        MessageBox box = new MessageBox(shell, 33);
        box.setText(Messages.SaveAction_ShowErrorMsgBoxText);
        box.setMessage(Messages.bind(Messages.SaveAction_ShowErrorMsgBoxMessage, e.getMessage()));
        box.open();
    }

    public void dispose() {
        this.m_text.dispose();
    }
}

