/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.profiler;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.profiler.ProfilerView;
import com.rsi.idldt.profiler.RoutineList;
import java.util.TimerTask;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public class ProfilerStartAction
extends ActionDelegate
implements IViewActionDelegate {
    static ProfilerView m_view;
    private static final String CMD_START = "Profiler & Profiler,/SYSTEM";
    private static final String CMD_STOP = "Profiler,/CLEAR & Profiler,/SYSTEM,/CLEAR";
    public static boolean isRunning;
    static boolean m_automatic;
    RefreshTask refreshTask;
    static IAction m_action;

    static {
        isRunning = false;
        m_automatic = false;
    }

    public void init(IViewPart view) {
        m_view = (ProfilerView)view;
        this.refreshTask = new RefreshTask();
    }

    public static void setAutomatic(boolean automatic) {
        m_automatic = automatic;
    }

    public static void handleReset() {
        if (m_action != null && m_action.isChecked()) {
            RoutineList list = (RoutineList)m_view.getViewer().getInput();
            list.clearResults();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    m_action.setChecked(false);
                    m_view.refresh(true);
                }
            });
        }
    }

    public void run(IAction action) {
        m_action = action;
        isRunning = action.isChecked();
        String cmd = isRunning ? CMD_START : CMD_STOP;
        IDLProcessManager.queueSilentExecuteString((String)cmd);
        if (isRunning) {
            RoutineList list = (RoutineList)m_view.getViewer().getInput();
            list.refreshResults(m_view);
            if (m_automatic) {
                Display.getCurrent().timerExec(10000, (Runnable)this.refreshTask);
            }
        }
    }

    class RefreshTask
    extends TimerTask {
        RefreshTask() {
        }

        public void run() {
            if (!isRunning || !m_automatic) {
                return;
            }
            IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
            if (!idl.isIDLAvailable()) {
                Display.getCurrent().timerExec(100, (Runnable)ProfilerStartAction.this.refreshTask);
                return;
            }
            RoutineList list = (RoutineList)m_view.getViewer().getInput();
            list.refreshResults(m_view);
            Display.getCurrent().timerExec(10000, (Runnable)ProfilerStartAction.this.refreshTask);
        }
    }
}

