/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.profiler;

import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.profiler.ProfilerView;
import com.rsi.idldt.profiler.Routine;
import com.rsi.idldt.profiler.RoutineList;
import java.text.NumberFormat;
import java.util.Locale;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ProfilerLabelProvider
implements ITableLabelProvider,
ITableFontProvider {
    private ProfilerView m_view = null;
    private final Color colorGreen = new Color((Device)Display.getCurrent(), 153, 255, 153);
    private final Color colorOrange = new Color((Device)Display.getCurrent(), 255, 204, 51);
    private final Color colorBlue = new Color((Device)Display.getCurrent(), 153, 204, 255);
    private static final int barWidth = 50;
    private boolean isMillisecond = true;
    private NumberFormat numberFormatter;
    private Image[] imageGreen = new Image[50];
    private Image[] imageOrange = new Image[50];
    private Image[] imageBlue = new Image[50];
    private Font fontItalic = null;
    private static final double LN10 = 2.302585092994046;
    private RoutineList routineList;

    public ProfilerLabelProvider(ProfilerView view, RoutineList rList) {
        this.m_view = view;
        this.numberFormatter = NumberFormat.getNumberInstance(Locale.getDefault());
        this.numberFormatter.setGroupingUsed(false);
        this.routineList = rList;
        Rectangle rect = new Rectangle(0, 0, 52, 15);
        int i = 0;
        while (i < 50) {
            this.imageGreen[i] = new Image((Device)Display.getCurrent(), rect);
            GC gc = new GC((Drawable)this.imageGreen[i]);
            gc.setBackground(this.colorGreen);
            gc.fillRectangle(0, 0, i + 2, 15);
            gc.dispose();
            this.imageOrange[i] = new Image((Device)Display.getCurrent(), rect);
            gc = new GC((Drawable)this.imageOrange[i]);
            gc.setBackground(this.colorOrange);
            gc.fillRectangle(0, 0, i + 2, 15);
            gc.dispose();
            this.imageBlue[i] = new Image((Device)Display.getCurrent(), rect);
            gc = new GC((Drawable)this.imageBlue[i]);
            gc.setBackground(this.colorBlue);
            gc.fillRectangle(0, 0, i + 2, 15);
            gc.dispose();
            ++i;
        }
    }

    public Image getColumnImage(Object arg0, int arg1) {
        Routine routine = (Routine)arg0;
        Image image = null;
        if (this.m_view == null) {
            return null;
        }
        switch (arg1) {
            case 2: {
                if (this.routineList.maxCount == 0) break;
                int count = routine.getCount();
                int width = (int)(50.0f * ((float)count / (float)this.routineList.maxCount));
                if (width > 50) {
                    width = 50;
                }
                image = width > 0 ? this.imageGreen[width - 1] : null;
                break;
            }
            case 3: {
                if (this.routineList.maxTimeSelf == 0.0) break;
                double time = routine.getTimeSelf();
                int width = (int)(time * 50.0 / this.routineList.maxTimeSelf);
                if (width > 50) {
                    width = 50;
                }
                image = width > 0 ? this.imageOrange[width - 1] : null;
                break;
            }
            case 4: {
                int count;
                if (this.routineList.maxTimeSelfHit == 0.0 || (count = routine.getCount()) == 0) break;
                double time = routine.getTimeSelf() / (double)count;
                int width = (int)(time * 50.0 / this.routineList.maxTimeSelfHit);
                if (width > 50) {
                    width = 50;
                }
                image = width > 0 ? this.imageOrange[width - 1] : null;
                break;
            }
            case 5: {
                if (this.routineList.maxTimeChildren == 0.0) break;
                double time = routine.getTimeChildren();
                int width = (int)(time * 50.0 / this.routineList.maxTimeChildren);
                if (width > 50) {
                    width = 50;
                }
                image = width > 0 ? this.imageBlue[width - 1] : null;
                break;
            }
            case 6: {
                int count;
                if (this.routineList.maxTimeChildrenHit == 0.0 || (count = routine.getCount()) == 0) break;
                double time = routine.getTimeChildren() / (double)count;
                int width = (int)(time * 50.0 / this.routineList.maxTimeChildrenHit);
                if (width > 50) {
                    width = 50;
                }
                image = width > 0 ? this.imageBlue[width - 1] : null;
            }
        }
        return image;
    }

    public String getColumnText(Object arg0, int arg1) {
        Routine routine = (Routine)arg0;
        String label = "";
        double time = -1.0;
        if (this.m_view == null) {
            return null;
        }
        switch (arg1) {
            case 1: {
                label = routine.getName();
                break;
            }
            case 2: {
                int count = routine.getCount();
                if (count <= 0) break;
                label = String.valueOf(count);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                int count = routine.getCount();
                if (count == 0) break;
                switch (arg1) {
                    case 3: {
                        time = routine.getTimeSelf();
                        break;
                    }
                    case 5: {
                        time = routine.getTimeChildren();
                        break;
                    }
                    case 4: {
                        time = routine.getTimeSelf() / (double)count;
                        break;
                    }
                    case 6: {
                        time = routine.getTimeChildren() / (double)count;
                    }
                }
                if (this.isMillisecond) {
                    time *= 1000.0;
                }
                int frac = 4 - (int)(Math.log(time) / 2.302585092994046);
                if (this.isMillisecond) {
                    if (frac > 4) {
                        frac = 4;
                    }
                } else if (frac > 7) {
                    frac = 7;
                }
                this.numberFormatter.setMinimumFractionDigits(frac);
                this.numberFormatter.setMaximumFractionDigits(frac);
                label = this.numberFormatter.format(time);
            }
        }
        return label;
    }

    public boolean getUnits() {
        return this.isMillisecond;
    }

    public void setUnits(boolean units) {
        this.isMillisecond = units;
        String sUnit = units ? "(ms)" : "(sec)";
        Table table = this.m_view.getViewer().getTable();
        TableColumn tc = table.getColumn(1);
        tc.setText(Messages.ProfilerTable_Routine);
        tc.setToolTipText(Messages.ProfilerTable_RoutineTooltip);
        tc = table.getColumn(2);
        tc.setText(Messages.ProfilerTable_Count);
        tc.setToolTipText(Messages.ProfilerTable_CountTooltip);
        tc = table.getColumn(3);
        tc.setText(String.valueOf(Messages.ProfilerTable_TimeSelf) + sUnit);
        tc.setToolTipText(Messages.ProfilerTable_TimeSelfTooltip);
        tc = table.getColumn(4);
        tc.setText(String.valueOf(Messages.ProfilerTable_TimePerHit) + sUnit);
        tc.setToolTipText(Messages.ProfilerTable_TimePerHitTooltip);
        tc = table.getColumn(5);
        tc.setText(String.valueOf(Messages.ProfilerTable_TimeSub) + sUnit);
        tc.setToolTipText(Messages.ProfilerTable_TimeSubTooltip);
        tc = table.getColumn(6);
        tc.setText(String.valueOf(Messages.ProfilerTable_TimeSubPerHit) + sUnit);
        tc.setToolTipText(Messages.ProfilerTable_TimeSubPerHitTooltip);
    }

    public void addListener(ILabelProviderListener arg0) {
    }

    public void dispose() {
        this.colorGreen.dispose();
        this.colorOrange.dispose();
        this.colorBlue.dispose();
        int i = 0;
        while (i < 50) {
            this.imageGreen[i].dispose();
            this.imageOrange[i].dispose();
            this.imageBlue[i].dispose();
            ++i;
        }
        if (this.fontItalic != null) {
            this.fontItalic.dispose();
        }
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void removeListener(ILabelProviderListener arg0) {
    }

    public Font getFont(Object element, int columnIndex) {
        Routine routine = (Routine)element;
        if (this.m_view == null) {
            return null;
        }
        if (columnIndex == 1 && routine.getIsSystem()) {
            if (this.fontItalic == null) {
                Table table = this.m_view.getViewer().getTable();
                Font font = table.getFont();
                FontData[] fontData = font.getFontData();
                FontData fontData1 = fontData[0];
                fontData1.setStyle(2);
                this.fontItalic = new Font((Device)Display.getCurrent(), fontData1);
            }
            return this.fontItalic;
        }
        return null;
    }
}

