/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.profiler;

import com.rsi.idldt.profiler.Routine;
import com.rsi.idldt.profiler.Wildcard;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ProfilerFilter
extends ViewerFilter {
    private String m_filter = null;
    private boolean m_removeZeroHit = true;
    private boolean m_showSystem = true;
    private boolean m_showUser = true;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        Routine routine = (Routine)element;
        boolean isSystem = routine.getIsSystem();
        if (!this.m_showSystem && isSystem) {
            return false;
        }
        if (!this.m_showUser && !isSystem) {
            return false;
        }
        if (this.m_removeZeroHit && routine.getCount() == 0) {
            return false;
        }
        if (this.m_filter == null || this.m_filter.length() == 0) {
            return true;
        }
        String name = routine.getName();
        return Wildcard.matches(String.valueOf(this.m_filter) + '*', name, true);
    }

    public String getFilter() {
        return this.m_filter;
    }

    public void setFilter(String filter) {
        this.m_filter = filter;
    }

    public boolean getShowSystem() {
        return this.m_showSystem;
    }

    public void setShowSystem(boolean showSystem) {
        this.m_showSystem = showSystem;
    }

    public boolean getShowUser() {
        return this.m_showUser;
    }

    public void setShowUser(boolean showUser) {
        this.m_showUser = showUser;
    }

    public boolean getRemoveZeroHit() {
        return this.m_removeZeroHit;
    }

    public void setRemoveZeroHit(boolean removeZeroHit) {
        this.m_removeZeroHit = removeZeroHit;
    }
}

