/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor.utils;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.IIDLDOMManager;
import com.rsi.idldt.core.dom.IIDLStructure;
import com.rsi.idldt.core.internal.dom.IDLDOMManager;
import com.rsi.idldt.core.internal.dom.IDLStructure;
import com.rsi.idldt.debug.internal.model.IDLDebugTarget;
import com.rsi.idldt.debug.internal.model.IDLStackFrame;
import com.rsi.idldt.debug.internal.model.IDLVariable;
import com.rsi.idldt.proeditor.utils.ProWordDetector;
import com.rsi.idldt.ui.UIPlugin;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProWordPartDetector {
    String m_activationPrefix = "";
    String m_wordPart = "";
    int m_docOffset;
    ITextViewer m_viewer;
    String m_functionName = null;
    String m_procName = null;
    String m_className = null;
    boolean m_tickBeforePrefix = false;
    boolean m_slashBeforePrefix = false;
    String m_tickCharacter = null;
    boolean m_bCanUseDebugModel = false;
    HashSet<Character> m_allowedChars = null;

    public ProWordPartDetector() {
    }

    public ProWordPartDetector(ITextViewer viewer, int documentOffset, boolean bCanUseDebugModel) {
        this.createWord(viewer, documentOffset, bCanUseDebugModel);
    }

    public void createWord(ITextViewer viewer, int documentOffset, boolean bCanUseDebugModel) {
        this.m_docOffset = documentOffset - 1;
        this.m_viewer = viewer;
        this.m_bCanUseDebugModel = bCanUseDebugModel;
        try {
            String nextPrevChar;
            while (this.m_docOffset >= viewer.getTopIndexStartOffset()) {
                char ch = viewer.getDocument().getChar(this.m_docOffset);
                if (!ProWordPartDetector.isIDLCharacter(ch) && !this.isCharAllowedInWord(ch)) break;
                --this.m_docOffset;
            }
            ++this.m_docOffset;
            if (this.m_docOffset > 0) {
                char slashChar;
                this.m_activationPrefix = viewer.getDocument().get(this.m_docOffset - 1, 1);
                char tickChar = viewer.getDocument().getChar(this.m_docOffset - 1);
                if (tickChar == '\'' || tickChar == '\"') {
                    this.m_tickBeforePrefix = true;
                    this.m_tickCharacter = Character.toString(tickChar);
                }
                if ((slashChar = viewer.getDocument().getChar(this.m_docOffset - 1)) == '/') {
                    this.m_slashBeforePrefix = true;
                }
            } else {
                this.m_activationPrefix = "";
            }
            if (this.isLineStartsWithCommentChar() && this.m_activationPrefix.equals(":")) {
                --this.m_docOffset;
            }
            this.m_wordPart = viewer.getDocument().get(this.m_docOffset, documentOffset - this.m_docOffset);
            if (this.m_activationPrefix.equals(">") && (nextPrevChar = viewer.getDocument().get(this.m_docOffset - 2, 1)).equals("-")) {
                this.m_activationPrefix = "->";
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    protected boolean isCharAllowedInWord(char ch) {
        if (this.m_allowedChars == null) {
            return false;
        }
        return this.m_allowedChars.contains(new Character(ch));
    }

    public void addAllowedChar(char ch) {
        if (this.m_allowedChars == null) {
            this.m_allowedChars = new HashSet();
        }
        this.m_allowedChars.add(new Character(ch));
    }

    public boolean canUseDebugModel() {
        return this.m_bCanUseDebugModel;
    }

    public boolean isTickBeforePrefix() {
        return this.m_tickBeforePrefix;
    }

    public boolean isSlashBeforePrefix() {
        return this.m_slashBeforePrefix;
    }

    public String getTickCharacter() {
        return this.m_tickCharacter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IIDLStructure associateDotWithIDLStructure() {
        IIDLStructure node = null;
        int offset = this.m_docOffset - 2;
        int len = 0;
        try {
            char c;
            char ch = this.m_viewer.getDocument().getChar(offset);
            while (offset >= this.m_viewer.getTopIndexStartOffset() && (Character.isJavaIdentifierPart(ch) || ch == '!')) {
                ++len;
                if (--offset < 0) break;
                ch = this.m_viewer.getDocument().getChar(offset);
            }
            String variableName = this.m_viewer.getDocument().get(++offset, len);
            int i = 0;
            while (true) {
                if (i >= variableName.length()) {
                    if (!(variableName = this.unDecorateVariableName(variableName)).startsWith("!")) break;
                    return this.getNamedStructure(variableName, 4);
                }
                char c2 = variableName.charAt(i);
                if (c2 != '*' && c2 != '(' && c2 != ')' && !ProWordPartDetector.isIDLCharacter(c2)) {
                    return null;
                }
                ++i;
            }
            if (variableName.equalsIgnoreCase("self")) {
                if (!this.m_bCanUseDebugModel) return this.getClassInstanceStructure();
                return this.getClassInstanceStructureFromDebugModel();
            }
            if (this.m_bCanUseDebugModel) {
                return this.getIdlStructureDomNodeFromDebugModel(variableName);
            }
            if ((offset = this.locateVariableStructureAssignment(variableName, offset)) <= -1) return node;
            node = this.getIdlStructureDomNodeForOffset(offset);
            if (node != null) return node;
            String namedStructure = "";
            int idx = offset;
            while (idx <= this.m_viewer.getBottomIndexEndOffset() && (ProWordPartDetector.isIDLCharacter(c = this.m_viewer.getDocument().getChar(idx)) || c == ' ')) {
                namedStructure = String.valueOf(namedStructure) + c;
                ++idx;
            }
            int flags = 12;
            return this.getNamedStructure(namedStructure.trim(), flags);
        }
        catch (BadLocationException badLocationException) {}
        return node;
    }

    protected IIDLStructure getIdlStructureDomNodeFromDebugModel(String variableName) {
        IDLVariable[] vars;
        String tok;
        String valueString;
        IIDLStructure result = null;
        IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
        if (idl == null) {
            return null;
        }
        IDLStackFrame frame = idl.getDebugTarget().getThread().getTopIDLStackFrame();
        IDLDebugTarget debugTarget = idl.getDebugTarget();
        IDLVariable v = debugTarget.getIDLVariable(frame.getName(), variableName);
        if (v == null || !v.isStructure()) {
            return null;
        }
        try {
            valueString = v.getValue().getValueString();
        }
        catch (DebugException debugException) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(valueString, "{}");
        String structureName = null;
        if (st.hasMoreTokens() && (tok = st.nextToken()) != null && tok.length() > 0) {
            structureName = tok.trim();
        }
        if (structureName != null && structureName.length() > 0 && (result = this.getNamedStructure(structureName, 4)) == null && (vars = v.getIDLVariables()).length > 0) {
            result = new IDLStructure(null, structureName, 0, 0, 0, 0);
            int i = 0;
            while (i < vars.length) {
                result.createField(vars[i].getName(), null, false, structureName, 0, 0, 0, 0);
                ++i;
            }
        }
        return result;
    }

    protected IIDLStructure getNamedStructure(String structureName, int normal_or_class_flag) {
        int flags;
        if (structureName == null) {
            return null;
        }
        IIDLDOMManager dm = IDLDOMManager.getActiveManager();
        IIDLStructure[] node = dm.findStructures(structureName, flags = 0x30 | normal_or_class_flag);
        if (node != null && node.length > 0) {
            return node[0];
        }
        return null;
    }

    protected String unDecorateVariableName(String inVar) {
        String outVar = inVar.replaceAll("\\(", " ").replaceAll("\\)", " ").trim().toLowerCase();
        if (outVar.startsWith("*p")) {
            outVar = outVar.substring(2);
        }
        if (outVar.startsWith("*")) {
            outVar = outVar.substring(1);
        }
        return outVar;
    }

    protected int locateVariableStructureAssignment(String variableName, int start_offset) {
        IDocument doc = this.m_viewer.getDocument();
        String findString = "\\{";
        boolean forwardSearch = true;
        boolean caseSensitive = false;
        boolean wholeWord = false;
        boolean regExSearch = true;
        boolean bDone = false;
        try {
            int start_line_num = doc.getLineOfOffset(start_offset);
            forwardSearch = false;
            IRegion line_info = doc.getLineInformation(--start_line_num);
            int startOffset = line_info.getOffset() + line_info.getLength();
            FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(doc);
            while (!bDone) {
                IRegion r = adapter.find(startOffset, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
                while (r != null) {
                    int eq_idx;
                    int line_num = doc.getLineOfOffset(r.getOffset());
                    line_info = doc.getLineInformation(line_num);
                    String line = doc.get(line_info.getOffset(), line_info.getLength());
                    if (!line.trim().startsWith(";") && (eq_idx = line.indexOf("=")) > 0) {
                        String line_sub = line.substring(0, eq_idx).trim().toLowerCase();
                        if ((line_sub = this.trimStemmedVariableName(line_sub)) != null && line_sub.equals(variableName)) {
                            int paren_offset = line.indexOf("{");
                            return line_info.getOffset() + paren_offset + 1;
                        }
                    }
                    line_num = forwardSearch ? ++line_num : --line_num;
                    line_info = doc.getLineInformation(line_num);
                    int offset = forwardSearch ? line_info.getOffset() : line_info.getOffset() + line_info.getLength();
                    r = adapter.find(offset, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
                }
                if (!forwardSearch) {
                    forwardSearch = true;
                    line_info = doc.getLineInformation(start_line_num);
                    ++start_line_num;
                    startOffset = line_info.getOffset();
                    continue;
                }
                bDone = true;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return -1;
    }

    public TreeSet<String> getMatchingWordsFromDoc() {
        int line_num;
        IDocument doc = this.m_viewer.getDocument();
        TreeSet<String> wordList = new TreeSet<String>();
        String findString = this.getString();
        boolean forwardSearch = true;
        boolean caseSensitive = false;
        boolean wholeWord = false;
        boolean regExSearch = true;
        boolean bDone = false;
        if (findString == null || findString.length() == 0) {
            return wordList;
        }
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(doc);
        int range_start = 0;
        try {
            bDone = false;
            line_num = doc.getLineOfOffset(this.m_docOffset);
            --line_num;
            while (!bDone && line_num >= 0) {
                IRegion line_info = doc.getLineInformation(line_num);
                String line = doc.get(line_info.getOffset(), line_info.getLength()).trim().toLowerCase();
                if (line.startsWith("pro ") || line.startsWith("function ")) {
                    range_start = line_info.getOffset();
                    break;
                }
                --line_num;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (NullPointerException nullPointerException) {}
        findString = "\\b" + findString + "[A-Za-z0-9_$]*";
        try {
            int beginning_line_num = doc.getLineOfOffset(this.m_docOffset);
            int start_line_num = 0;
            IRegion line_info = doc.getLineInformation(start_line_num);
            int startOffset = line_info.getOffset();
            while (!bDone) {
                IRegion r = adapter.find(startOffset, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
                while (r != null) {
                    line_num = doc.getLineOfOffset(r.getOffset());
                    line_info = doc.getLineInformation(line_num);
                    String line = doc.get(line_info.getOffset(), line_info.getLength());
                    int match_offset = r.getOffset();
                    if (line_num < beginning_line_num && range_start <= match_offset && match_offset <= this.m_docOffset && !line.trim().startsWith(";")) {
                        String word = doc.get(r.getOffset(), r.getLength());
                        wordList.add(word);
                        int offset = forwardSearch ? r.getOffset() + r.getLength() : r.getOffset() - 1;
                        if (!bDone) {
                            r = adapter.find(offset, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
                            continue;
                        }
                        r = null;
                        continue;
                    }
                    if (line_num > beginning_line_num) {
                        bDone = true;
                        break;
                    }
                    line_num = forwardSearch ? ++line_num : --line_num;
                    line_info = doc.getLineInformation(line_num);
                    int offset = forwardSearch ? line_info.getOffset() : line_info.getOffset() + line_info.getLength();
                    r = adapter.find(offset, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
                }
                bDone = true;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return wordList;
    }

    protected String trimStemmedVariableName(String varName) {
        int varNameLength = varName.length();
        if (varNameLength == 0) {
            return varName;
        }
        int i = varNameLength - 1;
        while (i >= 0) {
            char c = varName.charAt(i);
            if (c == '.' && i + 1 < varNameLength) {
                return varName.substring(i + 1);
            }
            --i;
        }
        return varName;
    }

    protected String locateVariableObjectAssignment(String variableName, int start_offset) {
        IDocument doc = this.m_viewer.getDocument();
        String findString = "obj_new";
        boolean forwardSearch = true;
        boolean caseSensitive = false;
        boolean wholeWord = false;
        boolean regExSearch = true;
        boolean bDone = false;
        try {
            int start_line_num = doc.getLineOfOffset(start_offset);
            forwardSearch = false;
            IRegion line_info = doc.getLineInformation(--start_line_num);
            int startOffset = line_info.getOffset() + line_info.getLength();
            FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(doc);
            while (!bDone) {
                IRegion r = adapter.find(startOffset, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
                while (r != null) {
                    String className;
                    String line_sub;
                    int eq_idx;
                    int line_num = doc.getLineOfOffset(r.getOffset());
                    line_info = doc.getLineInformation(line_num);
                    String line = doc.get(line_info.getOffset(), line_info.getLength());
                    if (!line.trim().startsWith(";") && (eq_idx = line.indexOf("=")) > 0 && (line_sub = line.substring(0, eq_idx)).trim().toLowerCase().equals(variableName) && (className = this.getClassNameFromObjNewLine(line)) != null) {
                        return className;
                    }
                    line_num = forwardSearch ? ++line_num : --line_num;
                    line_info = doc.getLineInformation(line_num);
                    int offset = forwardSearch ? line_info.getOffset() : line_info.getOffset() + line_info.getLength();
                    r = adapter.find(offset, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
                }
                if (!forwardSearch) {
                    forwardSearch = true;
                    line_info = doc.getLineInformation(start_line_num);
                    ++start_line_num;
                    startOffset = line_info.getOffset();
                    continue;
                }
                bDone = true;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return "";
    }

    public String getClassNameFromObjNewLine() {
        int line_num;
        IDocument doc = this.m_viewer.getDocument();
        String line = this.getCurrentLine();
        try {
            line_num = doc.getLineOfOffset(this.m_docOffset);
        }
        catch (BadLocationException badLocationException) {
            line_num = 0;
        }
        boolean bDone = false;
        while (!bDone) {
            if (line.toLowerCase().indexOf("obj_new") > -1) break;
            String strTopContinuationLine = "";
            try {
                boolean bContinuationLine = true;
                while (bContinuationLine) {
                    boolean bCommentLine = true;
                    while (bCommentLine) {
                        IRegion line_info;
                        boolean bl = bCommentLine = (line = doc.get((line_info = doc.getLineInformation(--line_num)).getOffset(), line_info.getLength())).trim().length() == 0 || line.trim().startsWith(";");
                    }
                    bContinuationLine = line.trim().endsWith("$");
                    if (!bContinuationLine) continue;
                    strTopContinuationLine = line;
                }
                if (strTopContinuationLine.length() > 0) {
                    line = strTopContinuationLine;
                    ++line_num;
                } else {
                    bDone = true;
                }
            }
            catch (BadLocationException badLocationException) {
                bDone = true;
            }
            if (strTopContinuationLine.length() != 0) continue;
            bDone = true;
        }
        return this.getClassNameFromObjNewLine(line);
    }

    String getClassNameFromObjNewLine(String line) {
        if (!line.trim().startsWith(";")) {
            String className;
            int tick_idx = line.indexOf("'");
            if (tick_idx > 0 && (tick_idx = (className = line.substring(tick_idx + 1)).indexOf("'")) > 0) {
                className = className.substring(0, tick_idx);
                return className;
            }
            tick_idx = line.indexOf("\"");
            if (tick_idx > 0 && (tick_idx = (className = line.substring(tick_idx + 1)).indexOf("\"")) > 0) {
                className = className.substring(0, tick_idx);
                return className;
            }
        }
        return null;
    }

    public String associatePointerWithClassName(int startOffset) {
        String className = "";
        int offset = startOffset;
        int len = 0;
        try {
            int topOffset = this.m_viewer.getTopIndexStartOffset();
            while (offset >= topOffset) {
                char c = this.m_viewer.getDocument().getChar(offset);
                if (!ProWordPartDetector.isIDLCharacter(c) && c != '*' && c != '(' && c != ')') break;
                --offset;
                ++len;
            }
            String variableName = this.m_viewer.getDocument().get(++offset, len);
            variableName = this.unDecorateVariableName(variableName);
            if (this.m_bCanUseDebugModel) {
                className = this.locateClassnameFromDebugModel(variableName);
            } else if (variableName.equalsIgnoreCase("self")) {
                IIDLStructure node = this.getClassInstanceStructure();
                if (node != null) {
                    className = node.getElementName();
                    className = "self:" + className;
                }
            } else {
                className = this.locateVariableObjectAssignment(variableName, offset);
            }
            return className;
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    protected String locateClassnameFromDebugModel(String variableName) {
        String result;
        block4: {
            result = null;
            IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
            if (idl == null) {
                return null;
            }
            IDLStackFrame frame = idl.getDebugTarget().getThread().getTopIDLStackFrame();
            IDLDebugTarget debugTarget = idl.getDebugTarget();
            try {
                IDLVariable v = debugTarget.getIDLVariable(frame.getName(), variableName);
                if (v == null || !v.isObjref()) break block4;
                String vs = v.getValue().getValueString();
                StringTokenizer st = new StringTokenizer(vs, "()");
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    if (tok.indexOf(60) != -1) continue;
                    result = tok;
                    break;
                }
            }
            catch (DebugException debugException) {}
        }
        return result;
    }

    public boolean isShowStructureNameList() {
        String line = this.getCurrentLine();
        if (line.trim().startsWith(";")) {
            return false;
        }
        if (line.trim().indexOf(123) == -1) {
            return false;
        }
        if (!this.isRightSideOfEquals()) {
            return false;
        }
        int i = line.length() - 1;
        while (i >= 0) {
            if (line.charAt(i) == '{') {
                return true;
            }
            if (line.charAt(i) != ' ' && line.charAt(i) != '\t') {
                if (!this.isInheritsKeyword(line, i)) break;
                return true;
            }
            --i;
        }
        return false;
    }

    protected boolean isInheritsKeyword(String line, int idx) {
        String KEYWORD = "inherits";
        int startidx = idx - KEYWORD.length() + 1;
        if (startidx < 0) {
            return false;
        }
        if (idx + 1 <= startidx) {
            return false;
        }
        String examine = line.substring(startidx, idx + 1);
        return examine.equalsIgnoreCase(KEYWORD);
    }

    public boolean isShowClassNameList() {
        String line = this.getCurrentLine();
        if (line.trim().startsWith(";")) {
            return false;
        }
        int i = line.length() - 1;
        while (i >= 0) {
            String functionName;
            if (line.charAt(i) == '(' && (functionName = ProWordPartDetector.extractTokenName(line, i)).equalsIgnoreCase("obj_new") && this.isLessThanTwoQuotesBetweenHereAndObjNew(line)) {
                this.m_functionName = functionName;
                return true;
            }
            --i;
        }
        return false;
    }

    protected boolean isLessThanTwoQuotesBetweenHereAndObjNew(String line) {
        int quoteCount = 0;
        int i = line.length() - 1;
        while (i >= 0) {
            if (line.substring(i).toLowerCase().startsWith("obj_new")) break;
            if (line.charAt(i) == '\'' || line.charAt(i) == '\"') {
                ++quoteCount;
            }
            --i;
        }
        return quoteCount < 2;
    }

    public boolean isRightSideOfEquals() {
        String line = this.getCurrentLine();
        int i = line.length() - 1;
        while (i >= 0) {
            if (line.charAt(i) == '=') {
                return true;
            }
            --i;
        }
        return false;
    }

    public boolean isLineStartsWithCommentChar() {
        String line = this.getCurrentLine();
        return line.trim().startsWith(";");
    }

    public boolean isLineEmptySoFar() {
        String line = this.getCurrentLine().trim();
        if (line.startsWith(";")) {
            line = line.replaceFirst(";", " ").trim();
        }
        return line.length() == 0;
    }

    public boolean isShowSystemVariableList() {
        return this.m_wordPart.startsWith("!");
    }

    public boolean isShowKeywordList() {
        int line_num;
        IDocument doc = this.m_viewer.getDocument();
        try {
            line_num = doc.getLineOfOffset(this.m_docOffset);
        }
        catch (BadLocationException badLocationException) {
            line_num = 0;
        }
        String line = this.collectEntireProCodeLine(this.m_docOffset);
        int nestedParensCount = 0;
        int i = line.length() - 1;
        while (i >= 0) {
            if (line.charAt(i) == ')') {
                ++nestedParensCount;
            } else if (line.charAt(i) == '(') {
                if (nestedParensCount > 0) {
                    --nestedParensCount;
                } else {
                    this.m_functionName = ProWordPartDetector.extractTokenName(line, i);
                    int j = i - this.m_functionName.length();
                    while (j >= 0) {
                        if (line.charAt(j) != ' ' && line.charAt(j) != '\t' && line.charAt(j) == '>' && j - 1 >= 0 && line.charAt(j - 1) == '-') {
                            int o = 0;
                            try {
                                IRegion line_info = doc.getLineInformation(line_num);
                                o = line_info.getOffset() + j - 2;
                            }
                            catch (BadLocationException badLocationException) {}
                            this.m_className = this.associatePointerWithClassName(o);
                            break;
                        }
                        --j;
                    }
                    return true;
                }
            }
            --i;
        }
        i = 0;
        while (i < line.length()) {
            if (line.charAt(i) == ',') {
                this.m_procName = ProWordPartDetector.extractTokenName(line, i);
                if (this.m_procName.trim().length() == 0) break;
                int j = i - this.m_procName.length();
                while (j >= 0) {
                    if (line.charAt(j) != ' ' && line.charAt(j) != '\t' && line.charAt(j) == '>' && j - 1 >= 0 && line.charAt(j - 1) == '-') {
                        int o = 0;
                        try {
                            IRegion line_info = doc.getLineInformation(line_num);
                            o = line_info.getOffset() + j - 2;
                        }
                        catch (BadLocationException badLocationException) {}
                        this.m_className = this.associatePointerWithClassName(o);
                        break;
                    }
                    --j;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String extractTokenName(String line, int theOffset) {
        int offset = theOffset;
        int i = offset - 1;
        while (i >= 0) {
            if (line.charAt(i) != ' ') break;
            --offset;
            --i;
        }
        i = offset - 1;
        while (i >= 0) {
            if (!ProWordPartDetector.isIDLCharacter(line.charAt(i)) && line.charAt(i) != ':') break;
            --i;
        }
        return line.substring(++i, offset);
    }

    private String getTextOnLine(int line_num) {
        String line = "";
        IDocument doc = this.m_viewer.getDocument();
        try {
            IRegion line_info = doc.getLineInformation(line_num);
            line = doc.get(line_info.getOffset(), line_info.getLength());
        }
        catch (BadLocationException badLocationException) {}
        return line;
    }

    public String getCurrentLine() {
        String line = "";
        int offset = this.m_docOffset - 1;
        try {
            while (offset >= this.m_viewer.getTopIndexStartOffset() && this.m_viewer.getDocument().getChar(offset) != '\n') {
                --offset;
            }
            line = this.m_viewer.getDocument().get(++offset, this.m_docOffset - offset);
        }
        catch (BadLocationException badLocationException) {}
        return line;
    }

    protected String collectEntireProCodeLine(int m_docOffset1) {
        int line_num;
        String totalLine = "";
        IDocument doc = this.m_viewer.getDocument();
        try {
            line_num = doc.getLineOfOffset(m_docOffset1);
            IRegion line_info = doc.getLineInformation(line_num);
            int len = m_docOffset1 - line_info.getOffset();
            totalLine = doc.get(line_info.getOffset(), len);
        }
        catch (BadLocationException badLocationException) {
            line_num = 0;
        }
        try {
            boolean bDone = false;
            while (!bDone) {
                IRegion line_info;
                String line;
                boolean bCommentLine;
                boolean bl = bCommentLine = (line = doc.get((line_info = doc.getLineInformation(--line_num)).getOffset(), line_info.getLength()).trim()).length() == 0 || line.startsWith(";");
                if (bCommentLine) continue;
                boolean bContinuationLine = line.endsWith("$");
                if (bContinuationLine) {
                    totalLine = String.valueOf(line.substring(0, line.lastIndexOf(36))) + " " + totalLine;
                    continue;
                }
                bDone = true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return totalLine;
    }

    private static boolean isIDLCharacter(char c) {
        return ProWordDetector.isIDLIdentifierCharacter(c);
    }

    public String getKeywordFunctionName() {
        return this.m_functionName;
    }

    public String getKeywordProcName() {
        return this.m_procName;
    }

    public String getIDLClassName() {
        return this.m_className;
    }

    public boolean isFunctionKeywordsNeeded() {
        return this.m_functionName != null;
    }

    public String getString() {
        return this.m_wordPart;
    }

    public void setString(String string) {
        this.m_wordPart = string;
    }

    public void setFunctionName(String string) {
        this.m_functionName = string;
    }

    public void setProcedureName(String string) {
        this.m_procName = string;
    }

    public void setClassName(String string) {
        this.m_className = string;
    }

    public ITextViewer getViewer() {
        return this.m_viewer;
    }

    public String getActivationPrefixChars() {
        return this.m_activationPrefix;
    }

    public int getOffset() {
        return this.m_docOffset;
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchPage activePage = null;
        IEditorPart activeEditor = null;
        IWorkbenchWindow workbenchWindow = UIPlugin.getActiveWorkbenchWindow();
        activePage = workbenchWindow.getActivePage();
        if (activePage != null && (activeEditor = activePage.getActiveEditor()) != null) {
            return activeEditor;
        }
        return null;
    }

    private IIDLStructure getIdlStructureDomNodeForOffset(int offset) {
        IEditorPart editor = this.getActiveEditor();
        IEditorInput editorInput = editor.getEditorInput();
        IDocument doc = this.m_viewer.getDocument();
        IIDLCompilationUnit cu = IDLDOMManager.temporaryParseString((String)doc.get());
        if (editorInput != null) {
            IDOMNode node = cu.getElementAt(offset);
            if (node == null) {
                return null;
            }
            if (node.getElementType() == 3) {
                return (IIDLStructure)node;
            }
            if (node.getElementType() == 2) {
                return (IIDLStructure)node.getParent();
            }
            System.out.println("**Error: node_type is: " + node.getElementType());
        }
        return null;
    }

    protected IIDLStructure getClassInstanceStructureFromDebugModel() {
        IIDLStructure result = null;
        IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
        if (idl == null) {
            return null;
        }
        IDLStackFrame frame = idl.getDebugTarget().getThread().getTopIDLStackFrame();
        IDLDebugTarget debugTarget = idl.getDebugTarget();
        try {
            IDLVariable v = debugTarget.getIDLVariable(frame.getName(), "self");
            if (v != null && v.isObjref()) {
                String vs = v.getValue().getValueString();
                StringTokenizer st = new StringTokenizer(vs, "()");
                String structureName = null;
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    if (tok.indexOf(60) != -1) continue;
                    structureName = tok;
                    break;
                }
                if (structureName != null) {
                    result = this.getNamedStructure(structureName, 8);
                }
            }
        }
        catch (DebugException debugException) {}
        return result;
    }

    protected IIDLStructure getClassInstanceStructure() {
        IIDLStructure node = null;
        IDOMNode dom_node = this.getDomNodeForCurrentLocation();
        while (dom_node != null && dom_node.getElementType() != 5) {
            dom_node = dom_node.getAncestor(5);
        }
        if (dom_node != null) {
            String name = dom_node.getElementName();
            String class_name = null;
            int index = name.indexOf("::");
            if (index >= 0) {
                class_name = name.substring(0, index);
            } else {
                index = name.indexOf("__define");
                if (index >= 0) {
                    class_name = name.substring(0, index);
                }
            }
            node = this.getNamedStructure(class_name, 8);
        } else {
            int line_num = 0;
            String className = null;
            try {
                IDocument doc = this.m_viewer.getDocument();
                line_num = doc.getLineOfOffset(this.m_docOffset);
            }
            catch (BadLocationException badLocationException) {}
            while (line_num >= 0 && className == null) {
                String line = this.getTextOnLine(line_num);
                className = this.getClassNameFromLine(line);
                --line_num;
            }
            node = this.getNamedStructure(className, 8);
        }
        return node;
    }

    protected String getClassNameFromLine(String theLine) {
        StringBuffer className = new StringBuffer();
        String line = theLine.toLowerCase().trim();
        if (line.startsWith("pro") || line.startsWith("function")) {
            int index = line.indexOf("::");
            if (--index < 0) {
                index = line.indexOf("__define");
                --index;
            }
            while (index >= 0) {
                char ch = line.charAt(index);
                if (ch == ' ') break;
                className.append(ch);
                --index;
            }
        }
        if (className.length() > 0) {
            className.reverse();
            return className.toString();
        }
        return null;
    }

    protected IDOMNode getDomNodeForCurrentLocation() {
        IDOMNode returnNode = null;
        IDocument doc = this.m_viewer.getDocument();
        IIDLCompilationUnit cu = IDLDOMManager.temporaryParseString((String)doc.get());
        if (cu != null) {
            returnNode = cu.getElementAt(this.m_docOffset);
        }
        return returnNode;
    }
}

