/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor.utils;

import java.util.Vector;

public class ProStringMatcher {
    protected String m_pattern;
    protected int m_length;
    protected boolean m_ignoreWildCards;
    protected boolean m_ignoreCase;
    protected boolean m_hasLeadingStar;
    protected boolean m_hasTrailingStar;
    protected String[] m_segments;
    protected int m_bound = 0;
    protected static final char SINGLE_WILDCARD = '\u0000';

    public ProStringMatcher(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        this.m_ignoreCase = ignoreCase;
        this.m_ignoreWildCards = ignoreWildCards;
        this.m_pattern = pattern;
        this.m_length = pattern.length();
        if (this.m_ignoreWildCards) {
            this.parseNoWildCards();
        } else {
            this.parseWildCards();
        }
    }

    public Position find(String text, int theStart, int theEnd) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        int start = theStart;
        int end = theEnd;
        int tlen = text.length();
        if (start < 0) {
            start = 0;
        }
        if (end > tlen) {
            end = tlen;
        }
        if (end < 0 || start >= end) {
            return null;
        }
        if (this.m_length == 0) {
            return new Position(start, start);
        }
        if (this.m_ignoreWildCards) {
            int x = this.posIn(text, start, end);
            if (x < 0) {
                return null;
            }
            return new Position(x, x + this.m_length);
        }
        int segCount = this.m_segments.length;
        if (segCount == 0) {
            return new Position(start, end);
        }
        int curPos = start;
        int matchStart = -1;
        int i = 0;
        while (i < segCount && curPos < end) {
            String current = this.m_segments[i];
            int nextMatch = this.regExpPosIn(text, curPos, end, current);
            if (nextMatch < 0) {
                return null;
            }
            if (i == 0) {
                matchStart = nextMatch;
            }
            curPos = nextMatch + current.length();
            ++i;
        }
        if (i < segCount) {
            return null;
        }
        return new Position(matchStart, curPos);
    }

    public boolean match(String text) {
        return this.match(text, 0, text.length());
    }

    public boolean match(String text, int theStart, int theEnd) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        int start = theStart;
        int end = theEnd;
        if (start > end) {
            return false;
        }
        if (this.m_ignoreWildCards) {
            return end - start == this.m_length && this.m_pattern.regionMatches(this.m_ignoreCase, 0, text, start, this.m_length);
        }
        int segCount = this.m_segments.length;
        if (segCount == 0 && (this.m_hasLeadingStar || this.m_hasTrailingStar)) {
            return true;
        }
        if (start == end) {
            return this.m_length == 0;
        }
        if (this.m_length == 0) {
            return start == end;
        }
        int tlen = text.length();
        if (start < 0) {
            start = 0;
        }
        if (end > tlen) {
            end = tlen;
        }
        int tCurPos = start;
        int bound = end - this.m_bound;
        if (bound < 0) {
            return false;
        }
        int i = 0;
        String current = this.m_segments[i];
        int segLength = current.length();
        if (!this.m_hasLeadingStar) {
            if (!this.regExpRegionMatches(text, start, current, 0, segLength)) {
                return false;
            }
            ++i;
            tCurPos += segLength;
        }
        while (i < segCount) {
            int currentMatch;
            current = this.m_segments[i];
            int k = current.indexOf(0);
            if (k < 0 ? (currentMatch = this.textPosIn(text, tCurPos, end, current)) < 0 : (currentMatch = this.regExpPosIn(text, tCurPos, end, current)) < 0) {
                return false;
            }
            tCurPos = currentMatch + current.length();
            ++i;
        }
        if (!this.m_hasTrailingStar && tCurPos != end) {
            int clen = current.length();
            return this.regExpRegionMatches(text, end - clen, current, 0, clen);
        }
        return i == segCount;
    }

    private void parseNoWildCards() {
        this.m_segments = new String[1];
        this.m_segments[0] = this.m_pattern;
        this.m_bound = this.m_length;
    }

    private void parseWildCards() {
        if (this.m_pattern.startsWith("*")) {
            this.m_hasLeadingStar = true;
        }
        if (this.m_pattern.endsWith("*") && this.m_length > 1 && this.m_pattern.charAt(this.m_length - 2) != '\\') {
            this.m_hasTrailingStar = true;
        }
        Vector<String> temp = new Vector<String>();
        int pos = 0;
        StringBuffer buf = new StringBuffer();
        block5: while (pos < this.m_length) {
            char c = this.m_pattern.charAt(pos++);
            switch (c) {
                case '\\': {
                    char next;
                    if (pos >= this.m_length) {
                        buf.append(c);
                        break;
                    }
                    if ((next = this.m_pattern.charAt(pos++)) == '*' || next == '?' || next == '\\') {
                        buf.append(next);
                        break;
                    }
                    buf.append(c);
                    buf.append(next);
                    break;
                }
                case '*': {
                    if (buf.length() <= 0) continue block5;
                    temp.addElement(buf.toString());
                    this.m_bound += buf.length();
                    buf.setLength(0);
                    break;
                }
                case '?': {
                    buf.append('\u0000');
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (buf.length() > 0) {
            temp.addElement(buf.toString());
            this.m_bound += buf.length();
        }
        this.m_segments = new String[temp.size()];
        temp.copyInto(this.m_segments);
    }

    protected int posIn(String text, int start, int end) {
        int max = end - this.m_length;
        if (!this.m_ignoreCase) {
            int i = text.indexOf(this.m_pattern, start);
            if (i == -1 || i > max) {
                return -1;
            }
            return i;
        }
        int i = start;
        while (i <= max) {
            if (text.regionMatches(true, i, this.m_pattern, 0, this.m_length)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int regExpPosIn(String text, int start, int end, String p) {
        int plen = p.length();
        int max = end - plen;
        int i = start;
        while (i <= max) {
            if (this.regExpRegionMatches(text, i, p, 0, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean regExpRegionMatches(String text, int theTStart, String p, int thePStart, int thePlen) {
        int plen = thePlen;
        int tStart = theTStart;
        int pStart = thePStart;
        while (plen-- > 0) {
            char tchar = text.charAt(tStart++);
            char pchar = p.charAt(pStart++);
            if (!this.m_ignoreWildCards && pchar == '\u0000' || pchar == tchar || this.m_ignoreCase && (Character.toUpperCase(tchar) == Character.toUpperCase(pchar) || Character.toLowerCase(tchar) == Character.toLowerCase(pchar))) continue;
            return false;
        }
        return true;
    }

    protected int textPosIn(String text, int start, int end, String p) {
        int plen = p.length();
        int max = end - plen;
        if (!this.m_ignoreCase) {
            int i = text.indexOf(p, start);
            if (i == -1 || i > max) {
                return -1;
            }
            return i;
        }
        int i = start;
        while (i <= max) {
            if (text.regionMatches(true, i, p, 0, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static class Position {
        int start;
        int end;

        public Position(int start1, int end1) {
            this.start = start1;
            this.end = end1;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

