/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor.utils;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;

public class ProPairMatcher
implements ICharacterPairMatcher {
    private char[] m_pairs;
    private int m_startPos;
    private int m_endPos;
    private int m_anchor;
    private IDocument m_document;
    private int m_offset;

    public ProPairMatcher(char[] pairs) {
        this.m_pairs = pairs;
    }

    public IRegion match(IDocument document, int offset) {
        this.m_document = document;
        this.m_offset = offset;
        if (this.matchPairsAt() && this.m_startPos != this.m_endPos) {
            return new Region(this.m_startPos, this.m_endPos - this.m_startPos + 1);
        }
        return null;
    }

    public int getAnchor() {
        return this.m_anchor;
    }

    public void clear() {
    }

    public void dispose() {
    }

    private boolean matchPairsAt() {
        block11: {
            block12: {
                int idx;
                block9: {
                    block10: {
                        idx = 0;
                        if (this.m_document == null || this.m_offset < 1) {
                            return false;
                        }
                        this.m_startPos = -1;
                        this.m_endPos = -1;
                        try {
                            char prevChar = this.m_document.getChar(this.m_offset - 1);
                            int i = 0;
                            while (i < this.m_pairs.length - 1) {
                                if (prevChar == this.m_pairs[i]) {
                                    this.m_startPos = this.m_offset - 1;
                                    idx = i;
                                    break;
                                }
                                if (prevChar == this.m_pairs[i + 1]) {
                                    this.m_endPos = this.m_offset - 1;
                                    idx = i;
                                    break;
                                }
                                i += 2;
                            }
                            if (this.m_startPos <= -1) break block9;
                            this.m_anchor = 1;
                            this.m_endPos = this.searchForMatchingPeer(this.m_startPos, this.m_pairs[idx], this.m_pairs[idx + 1]);
                            if (this.m_endPos <= -1) break block10;
                            return true;
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    this.m_startPos = -1;
                    return false;
                }
                if (this.m_endPos <= -1) break block11;
                this.m_anchor = 0;
                this.m_startPos = this.searchForMatchingPeer(this.m_endPos, this.m_pairs[idx], this.m_pairs[idx + 1]);
                if (this.m_startPos <= -1) break block12;
                return true;
            }
            this.m_endPos = -1;
            return false;
        }
        return false;
    }

    private int searchForMatchingPeer(int theOffset, char openingPeer, char closingPeer) throws BadLocationException {
        int offset = theOffset;
        int stack = this.m_anchor == 1 ? 1 : -1;
        int incr = this.m_anchor == 1 ? 1 : -1;
        offset += incr;
        int length = this.m_document.getLength();
        while (offset >= 0 && offset < length) {
            char curChar = this.m_document.getChar(offset);
            if (curChar == openingPeer) {
                ++stack;
            } else if (curChar == closingPeer) {
                --stack;
            }
            if (stack == 0) {
                return offset;
            }
            offset += incr;
        }
        return -1;
    }
}

