/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor.utils;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.dom.IDOMFile;
import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLCUMember;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.ISourceCodeRange;
import com.rsi.idldt.core.dom.ISourceCodeReference;
import com.rsi.idldt.core.internal.dom.IDLDOMManager;
import com.rsi.idldt.core.interp.AbstractIDLCommand;
import com.rsi.idldt.debug.internal.model.IDLBreakpointManager;
import com.rsi.idldt.debug.internal.model.IDLExternalLineBreakpoint;
import com.rsi.idldt.debug.internal.model.IDLLineBreakpoint;
import com.rsi.idldt.debug.model.IIDLBreakpoint;
import com.rsi.idldt.internal.ui.NonExistentProEditorInput;
import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.proeditor.pro.ProCompletionProcessor;
import com.rsi.idldt.proeditor.utils.ProDOMFinder;
import com.rsi.idldt.proeditor.utils.ProWordDetector;
import com.rsi.idldt.profiler.ProfilerStartAction;
import com.rsi.idldt.ui.IDLEditorUtilities;
import com.rsi.idldt.ui.UIPlugin;
import com.rsi.jdml.DMLAccess;
import com.rsi.jdml.IDLVariable;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ProEditorUtilities {
    public static final String[] RESERVED_WORDS = new String[]{"AND", "BEGIN", "BREAK", "CASE", "COMMON", "COMPILE_OPT", "CONTINUE", "DO", "ELSE", "END", "ENDCASE", "ENDELSE", "ENDFOR", "ENDIF", "ENDREP", "ENDSWITCH", "ENDWHILE", "EQ", "FOR", "FORWARD_FUNCTION", "FUNCTION", "GE", "GOTO", "GT", "IF", "INHERITS", "LE", "LT", "MOD", "NE", "NOT", "OF", "ON_IOERROR", "OR", "PRO", "REPEAT", "SWITCH", "THEN", "UNTIL", "WHILE", "XOR"};
    private static ProDOMFinder pDOMfinder = null;

    public static IDOMNode findNodeByName(String name) {
        String searchName;
        if (pDOMfinder == null) {
            pDOMfinder = new ProDOMFinder();
        }
        boolean bSearchInheritedClasses = false;
        if (name.indexOf("self->") == 0) {
            searchName = name.substring(6);
            bSearchInheritedClasses = true;
        } else {
            searchName = name;
        }
        IDOMNode domNode = pDOMfinder.findByName(searchName);
        if (domNode == null && bSearchInheritedClasses) {
            int j = searchName.indexOf("::");
            String className = searchName.substring(0, j);
            String methodName = searchName.substring(j + 2);
            domNode = ProEditorUtilities.findMethodUsingInheritedClasses(className, methodName);
        }
        return domNode;
    }

    protected static IDOMNode findMethodUsingInheritedClasses(String className, String methodName) {
        String[] superClassNames;
        IDOMNode domNode = null;
        if (pDOMfinder == null) {
            pDOMfinder = new ProDOMFinder();
        }
        if ((superClassNames = ProCompletionProcessor.getSuperClassNames(className)) == null || superClassNames.length == 0) {
            return null;
        }
        int i = 0;
        while (i < superClassNames.length) {
            domNode = pDOMfinder.findByName(String.valueOf(superClassNames[i]) + "::" + methodName);
            if (domNode != null) {
                return domNode;
            }
            ++i;
        }
        i = 0;
        while (i < superClassNames.length) {
            domNode = ProEditorUtilities.findMethodUsingInheritedClasses(superClassNames[i], methodName);
            if (domNode != null) {
                return domNode;
            }
            ++i;
        }
        return domNode;
    }

    public static String getEditorsText(IEditorPart editor) {
        String editorText = null;
        if (editor instanceof ProEditor) {
            ProEditor proEditor = (ProEditor)editor;
            IEditorInput input = proEditor.getEditorInput();
            IDocumentProvider docProvider = proEditor.getDocumentProvider();
            IDocument doc = docProvider.getDocument((Object)input);
            editorText = doc.get();
        }
        return editorText;
    }

    public static String findFileByRoutine(String routine) {
        if (!ProWordDetector.isIDLIdentifier(routine)) {
            return null;
        }
        IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
        if (!idl.isIDLAvailable()) {
            return null;
        }
        FindFileByRoutine c = new FindFileByRoutine(routine);
        idl.queueCommand((AbstractIDLCommand)c);
        while (!idl.isIDLAvailable()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
        return c.result;
    }

    public static boolean openEditorToIDLName(String routine) {
        String contents;
        FileInputStream fis;
        String filename = ProEditorUtilities.findFileByRoutine(routine);
        if (filename == null) {
            return false;
        }
        try {
            fis = new FileInputStream(filename);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return false;
        }
        try {
            byte[] buf = new byte[fis.available()];
            DataInputStream dis = new DataInputStream(fis);
            dis.readFully(buf);
            dis.close();
            fis.close();
            contents = new String(buf);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        IIDLCompilationUnit cu = IDLDOMManager.temporaryParseString((String)contents);
        IDOMNode node = cu.getChildOfTypeAndName(5, routine);
        if (node == null) {
            return false;
        }
        IEditorPart editor = ProEditorUtilities.openNativeFileInEditor(filename);
        ProEditorUtilities.showNodeInEditor(editor, node);
        return true;
    }

    public static void openEditorToNode(IDOMNode node) {
        if (!(node instanceof IIDLCompilationUnit) && !(node instanceof IIDLCUMember)) {
            return;
        }
        IIDLCompilationUnit cu = ((IIDLCUMember)node).getCompilationUnit();
        IDOMFile domFile = cu.getDOMFile();
        IEditorPart editor = null;
        if (cu.isResource()) {
            IFile f = domFile.getResource();
            FileEditorInput input = new FileEditorInput(f);
            editor = IDLEditorUtilities.openEditor((IEditorInput)input, UIPlugin.ID_PRO_EDITOR);
        } else {
            String p = domFile.getCanonicalPath();
            editor = ProEditorUtilities.openNativeFileInEditor(p);
        }
        ProEditorUtilities.showNodeInEditor(editor, node);
    }

    public static int getCharCount(String fullPath) {
        InputStreamReader read;
        FileInputStream input;
        int c = 0;
        int count = 0;
        try {
            input = new FileInputStream(new File(fullPath));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return 0;
        }
        try {
            read = new InputStreamReader((InputStream)input, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            read = new InputStreamReader(input);
        }
        BufferedReader buffReader = new BufferedReader(read);
        try {
            do {
                c = buffReader.read();
                ++count;
            } while (c >= 0);
        }
        catch (IOException iOException) {}
        if (c < 0) {
            --count;
        }
        try {
            buffReader.close();
        }
        catch (IOException iOException) {}
        return count;
    }

    public static Annotation[] getAnnotationsAtLine(IEditorPart editorPart, int n) {
        Vector<Annotation> v = new Vector<Annotation>(16);
        try {
            ProEditor proEditor = (ProEditor)((Object)editorPart.getAdapter(ProEditor.class));
            IEditorInput editorInput = editorPart.getEditorInput();
            IDocumentProvider docProvider = proEditor.getDocumentProvider();
            IDocument doc = docProvider.getDocument((Object)editorInput);
            IRegion region = doc.getLineInformation(n);
            int offset = region.getOffset();
            IAnnotationModel model = docProvider.getAnnotationModel((Object)editorInput);
            Iterator e = model.getAnnotationIterator();
            while (e.hasNext()) {
                Annotation a = (Annotation)e.next();
                Position p = model.getPosition(a);
                if (p == null || p.getOffset() != offset) continue;
                v.add(a);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (v.size() == 0) {
            return new Annotation[0];
        }
        return v.toArray(new Annotation[v.size()]);
    }

    public static String getLineAsString(IEditorPart editorPart, int n) {
        String s = null;
        if (editorPart != null) {
            try {
                ProEditor proEditor = (ProEditor)((Object)editorPart.getAdapter(ProEditor.class));
                IEditorInput editorInput = editorPart.getEditorInput();
                IDocumentProvider docProvider = proEditor.getDocumentProvider();
                IDocument doc = docProvider.getDocument((Object)editorInput);
                IRegion region = doc.getLineInformation(n);
                int offset = region.getOffset();
                int length = region.getLength();
                s = doc.get(offset, length);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return s;
    }

    public static int getOffsetAtLine(String fullPath, int lineIndex) {
        InputStreamReader read;
        FileInputStream input;
        int offset = 0;
        int currentLine = 0;
        boolean sawCR = false;
        try {
            input = new FileInputStream(new File(fullPath));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return 0;
        }
        try {
            read = new InputStreamReader((InputStream)input, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            read = new InputStreamReader(input);
        }
        BufferedReader buffReader = new BufferedReader(read);
        try {
            while (currentLine < lineIndex) {
                int c = buffReader.read();
                if (sawCR || c == 10 || c == -1) {
                    sawCR = false;
                    ++currentLine;
                } else if (c == 13) {
                    sawCR = true;
                }
                ++offset;
            }
        }
        catch (IOException iOException) {}
        try {
            buffReader.close();
        }
        catch (IOException iOException) {}
        return offset;
    }

    public static IEditorPart openNativeFileInEditor(String fullPath) {
        return IDLEditorUtilities.openNativeFileInEditor(fullPath, UIPlugin.ID_PRO_EDITOR);
    }

    public static void transferBreakpoints(IEditorInput srcInput, IEditorInput destInput) {
        if (!(srcInput instanceof NonExistentProEditorInput)) {
            return;
        }
        NonExistentProEditorInput non = (NonExistentProEditorInput)srcInput;
        IPath p = non.getPath(non);
        String s = p.toOSString();
        IIDLBreakpoint[] breakpoints = IDLBreakpointManager.getAllFromFile((String)s);
        if (breakpoints.length == 0) {
            return;
        }
        Object f = IDLEditorUtilities.getEditorsFile(destInput);
        if (f instanceof File) {
            try {
                s = ((File)f).getCanonicalPath();
                p = new Path(s);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (!(f instanceof IFile)) {
            return;
        }
        IBreakpointManager bpm = IDLBreakpointManager.getBreakpointManager();
        int i = 0;
        while (i < breakpoints.length) {
            Object bp = breakpoints[i];
            int line = bp.getLine();
            int offset = bp.getDOMOffset();
            try {
                bpm.removeBreakpoint((IBreakpoint)bp, true);
                bp = f instanceof IFile ? new IDLLineBreakpoint((IResource)((IFile)f), line, offset) : new IDLExternalLineBreakpoint(p, line, offset);
                bpm.addBreakpoint((IBreakpoint)bp);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private static void showNodeInEditor(IEditorPart editor, IDOMNode node) {
        if (node != null && editor != null) {
            ISourceCodeRange range = null;
            if (node instanceof IIDLCUMember) {
                range = ((IIDLCUMember)node).getNameRange();
            } else if (node instanceof ISourceCodeReference) {
                range = ((ISourceCodeReference)node).getSourceRange();
            }
            if (range != null) {
                IDLEditorUtilities.highlightEditorArea(editor, range);
            }
        }
    }

    public static void refreshEditors() {
        IEditorPart[] editors = IDLEditorUtilities.getEditors();
        int i = 0;
        while (i < editors.length) {
            if (editors[i] instanceof ProEditor) {
                ((ProEditor)editors[i]).refresh();
            }
            ++i;
        }
    }

    private static class FindFileByRoutine
    extends AbstractIDLCommand {
        String result = null;
        String m_routine;
        final String CMD_STOP_PROFILER = "Profiler,/SYSTEM,/CLEAR & ";
        final String CMD_RESTART_PROFILER = " & Profiler,/SYSTEM";

        public FindFileByRoutine(String routine) {
            this.m_routine = routine;
            this.setUpdateDebugModel(false);
        }

        public void activate(IIDLProcessProxy idl) {
            String cmd = "DEFSYSV, '!IDLDT_TempFilepath', '' & !IDLDT_TempFilepath = Routine_Filepath('" + this.m_routine + "',/EITHER)";
            if (ProfilerStartAction.isRunning) {
                cmd = "Profiler,/SYSTEM,/CLEAR & " + cmd + " & Profiler,/SYSTEM";
            }
            IDLVariable var = new IDLVariable();
            DMLAccess.silentExecuteString((long)idl.getDebugID(), (String)cmd);
            DMLAccess.getIDLVariable((long)idl.getDebugID(), (String)"!IDLDT_TempFilepath", (IDLVariable)var);
            this.result = var.getString();
        }
    }
}

