/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor.utils;

import com.rsi.idldt.ui.UIPreferenceManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ProColorProvider {
    private IPreferenceStore ps;
    protected Map<String, Color> m_colorTable;

    public ProColorProvider(IPreferenceStore ps1) {
        this.ps = ps1;
        this.m_colorTable = new HashMap<String, Color>(UIPreferenceManager.getChromacodeColors().length);
    }

    public ProColorProvider() {
        this(UIPreferenceManager.getPreferenceStore());
    }

    public void dispose() {
        Iterator<Color> e = this.m_colorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }

    public Color getColor(String id) {
        if (id == null) {
            return null;
        }
        Color color = this.m_colorTable.get(id);
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.ps, (String)id);
        if (color == null || color.isDisposed() || !rgb.equals((Object)color.getRGB())) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.m_colorTable.put(id, color);
        }
        return color;
    }

    public Color getBackgroundColor(String id) {
        if (id == null) {
            return null;
        }
        if (this.ps.getBoolean(String.valueOf(id) + "_BACKGROUND_USE_DEFAULT")) {
            return null;
        }
        return this.getColor(String.valueOf(id) + "_BACKGROUND");
    }

    public int getStyle(String id) {
        if (id == null) {
            return 0;
        }
        int style = this.ps.getInt(String.valueOf(id) + "_FONTSTYLE");
        return style;
    }
}

