/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor.utils;

import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.IIDLDOMManager;
import com.rsi.idldt.core.dom.IIDLRoutine;
import com.rsi.idldt.core.internal.dom.IDLDOMManager;
import com.rsi.idldt.proeditor.utils.CaselessWordRule;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;

public class DOMWordRule
extends CaselessWordRule {
    private IToken m_systemProcedureToken;
    private IToken m_systemFunctionToken;
    private IToken m_userProcedureToken;
    private IToken m_userFunctionToken;
    private IToken m_procedureToken;
    private IToken m_functionToken;

    public DOMWordRule(IWordDetector detector, IToken systemProcedureToken, IToken systemFunctionToken, IToken userProcedureToken, IToken userFunctionToken) {
        super(detector);
        this.m_systemProcedureToken = systemProcedureToken;
        this.m_systemFunctionToken = systemFunctionToken;
        this.m_userProcedureToken = userProcedureToken;
        this.m_userFunctionToken = userFunctionToken;
        this.addDOMRoutines();
    }

    public DOMWordRule(IWordDetector detector, IToken systemProcedureToken, IToken systemFunctionToken, IToken userProcedureToken, IToken userFunctionToken, IToken defaultToken) {
        super(detector, defaultToken);
        this.m_systemProcedureToken = systemProcedureToken;
        this.m_systemFunctionToken = systemFunctionToken;
        this.m_userProcedureToken = userProcedureToken;
        this.m_userFunctionToken = userFunctionToken;
        this.addDOMRoutines();
    }

    private void addDOMRoutines() {
        IIDLDOMManager manager = IDLDOMManager.getActiveManager();
        if (manager == null) {
            return;
        }
        Class<?> c = ((Object)((Object)this)).getClass();
        Class[] parameterTypes = new Class[]{IIDLRoutine.class, Object.class};
        Method m = null;
        try {
            m = c.getMethod("addRoutineName", parameterTypes);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return;
        }
        Collection units = manager.getAllCompilationUnits();
        this.m_procedureToken = this.m_systemProcedureToken;
        this.m_functionToken = this.m_systemFunctionToken;
        for (IIDLCompilationUnit cu : units) {
            if (cu.getDOMFile() != null) continue;
            manager.visitDescendantsOfType((IDOMNode)cu, 5, (Object)this, m, null);
            break;
        }
        this.m_procedureToken = this.m_userProcedureToken;
        this.m_functionToken = this.m_userFunctionToken;
        for (IIDLCompilationUnit cu : units) {
            if (cu.getDOMFile() == null) continue;
            manager.visitDescendantsOfType((IDOMNode)cu, 5, (Object)this, m, null);
        }
    }

    public Boolean addRoutineName(IIDLRoutine r, Object callData) {
        this.addWord(r.getElementName().toUpperCase(), r.isFunction() ? this.m_functionToken : this.m_procedureToken);
        return Boolean.TRUE;
    }

    public Map getFWord(DOMWordRule DWR) {
        return DWR.fWords;
    }
}

