/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor.utils;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public abstract class AbstractWordRule
extends WordRule {
    protected StringBuffer m_buffer = new StringBuffer();

    protected abstract IToken findToken(String var1, ICharacterScanner var2);

    public AbstractWordRule(IWordDetector detector) {
        super(detector);
    }

    public AbstractWordRule(IWordDetector detector, IToken defaultToken) {
        super(detector, defaultToken);
    }

    public void addWord(String word, IToken token) {
        super.addWord(word.toUpperCase(), token);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            this.m_buffer.setLength(0);
            do {
                this.m_buffer.append((char)c);
            } while (this.fDetector.isWordPart((char)(c = scanner.read())));
            scanner.unread();
            String s = this.m_buffer.toString();
            IToken token = this.findToken(s, scanner);
            if (token != null && token != Token.UNDEFINED) {
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.m_buffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

