/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor.pro;

import com.rsi.idldt.proeditor.ProEditorServices;
import com.rsi.idldt.proeditor.pro.ProCodeScanner;
import com.rsi.idldt.proeditor.pro.ProWordFormattingStrategy;
import com.rsi.idldt.proeditor.utils.ProWordPartDetector;
import com.rsi.idldt.ui.UIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Proposal
implements Comparable<Proposal> {
    private String m_proposal;
    private int m_type;
    private String m_hoverHelp;
    private boolean m_bFunctionHasArgs = true;
    private ICompletionProposal m_CompletionProposal = null;
    private static final ProWordFormattingStrategy m_formatter = new ProWordFormattingStrategy();
    public static final int SCOPE_VARIABLE = 5;
    public static final int KEYWORD = 10;
    public static final int KEYWORD_INHERITED = 11;
    public static final int CLASS_NAME = 20;
    public static final int STRUCT_FIELD = 30;
    public static final int STRUCT_FIELD_INHERITED = 31;
    public static final int TEMPLATE = 40;
    public static final int SYSTEM_VARIABLE = 50;
    public static final int DOC_WORD = 60;
    public static final int PROCEDURE = 70;
    public static final int FUNCTION = 71;
    public static final int CLASS_PROCEDURE = 80;
    public static final int CLASS_FUNCTION = 81;
    public static final int SUPERCLASS_PROCEDURE = 82;
    public static final int SUPERCLASS_FUNCTION = 83;
    public static final int STRUCTURE = 90;
    public static final int IDL_RESERVED_WORD = 100;
    public static final int IDLDOC_TAG = 110;
    private static Image TEMPLATE_IMAGE = Proposal.createImage("icons/template_obj.gif");
    private static Image CLASS_NAME_IMAGE = Proposal.createImage("icons/class_procedure.gif");
    private static Image KEYWORD_IMAGE = Proposal.createImage("icons/keyword.gif");
    private static Image KEYWORD_INHERITED_IMAGE = Proposal.createImage("icons/keyword_inherited.gif");
    private static Image STRUCT_FIELD_IMAGE = Proposal.createImage("icons/struct_field.gif");
    private static Image STRUCT_FIELD_INHERITED_IMAGE = Proposal.createImage("icons/struct_field_inherited.gif");
    private static Image SYSTEM_VARIABLE_IMAGE = Proposal.createImage("icons/system_variable.gif");
    private static Image SCOPE_VARIABLE_IMAGE = Proposal.createImage("icons/scope_variable.gif");
    private static Image DOC_WORD_IMAGE = Proposal.createImage("icons/file_obj.gif");
    private static Image PROCEDURE_IMAGE = Proposal.createImage("icons/procedure.gif");
    private static Image FUNCTION_IMAGE = Proposal.createImage("icons/function.gif");
    private static Image CLASS_PROCEDURE_IMAGE = Proposal.createImage("icons/class_procedure.gif");
    private static Image CLASS_FUNCTION_IMAGE = Proposal.createImage("icons/class_function.gif");
    private static Image SUPERCLASS_PROCEDURE_IMAGE = Proposal.createImage("icons/superclass_procedure.gif");
    private static Image SUPERCLASS_FUNCTION_IMAGE = Proposal.createImage("icons/superclass_function.gif");
    private static Image STRUCTURE_IMAGE = Proposal.createImage("icons/structure.gif");
    private static Image IDL_RESERVED_WORD_IMAGE = Proposal.createImage("icons/pro_file.gif");
    private static Image IDLDOC_TAG_IMAGE = Proposal.createImage("icons/comment.gif");

    public Proposal(String proposal, int type, String hoverHelp) {
        this.m_proposal = proposal;
        this.m_type = type;
        this.m_hoverHelp = hoverHelp;
    }

    public Proposal(ICompletionProposal cp, int type) {
        this.m_CompletionProposal = cp;
        this.m_proposal = cp.getDisplayString();
        this.m_type = type;
    }

    private static Image createImage(String location) {
        ImageDescriptor id = UIPlugin.getImageDescriptor(location);
        Image image = id.createImage();
        return image;
    }

    public String getProposalString() {
        return this.m_proposal;
    }

    public String getProposalHoverHelp() {
        return this.m_hoverHelp;
    }

    public int getProposalType() {
        return this.m_type;
    }

    public void setFunctionHasArgs(boolean v) {
        this.m_bFunctionHasArgs = v;
    }

    public boolean isFunctionArgs() {
        return this.m_bFunctionHasArgs;
    }

    private Image getProposalImage() {
        switch (this.m_type) {
            case 71: {
                return FUNCTION_IMAGE;
            }
            case 70: {
                return PROCEDURE_IMAGE;
            }
            case 81: {
                return CLASS_FUNCTION_IMAGE;
            }
            case 80: {
                return CLASS_PROCEDURE_IMAGE;
            }
            case 83: {
                return SUPERCLASS_FUNCTION_IMAGE;
            }
            case 82: {
                return SUPERCLASS_PROCEDURE_IMAGE;
            }
            case 20: {
                return CLASS_NAME_IMAGE;
            }
            case 10: {
                return KEYWORD_IMAGE;
            }
            case 11: {
                return KEYWORD_INHERITED_IMAGE;
            }
            case 30: {
                return STRUCT_FIELD_IMAGE;
            }
            case 31: {
                return STRUCT_FIELD_INHERITED_IMAGE;
            }
            case 50: {
                return SYSTEM_VARIABLE_IMAGE;
            }
            case 5: {
                return SCOPE_VARIABLE_IMAGE;
            }
            case 40: {
                return TEMPLATE_IMAGE;
            }
            case 60: {
                return DOC_WORD_IMAGE;
            }
            case 90: {
                return STRUCTURE_IMAGE;
            }
            case 100: {
                return IDL_RESERVED_WORD_IMAGE;
            }
            case 110: {
                return IDLDOC_TAG_IMAGE;
            }
        }
        return null;
    }

    public String toString() {
        return String.valueOf(Integer.toString(this.m_type)) + "  :  " + this.m_proposal;
    }

    @Override
    public int compareTo(Proposal p1) {
        int result = this.m_type / 10 == p1.m_type / 10 ? this.m_proposal.compareToIgnoreCase(p1.m_proposal) : (this.m_type < p1.m_type ? -1 : (this.m_type > p1.m_type ? 1 : 0));
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Proposal) {
            Proposal p = (Proposal)obj;
            return this.m_proposal.equalsIgnoreCase(p.getProposalString());
        }
        return super.equals(obj);
    }

    private String format(String content, int type, boolean isCommandLine) {
        ProCodeScanner scanner = ProEditorServices.getProCodeScanner();
        m_formatter.formatterStarts("");
        switch (type) {
            case 70: 
            case 71: {
                return m_formatter.formatWords(content);
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                return m_formatter.formatToken(content, scanner.userFunctionToken);
            }
            case 100: {
                return m_formatter.formatToken(content, scanner.reservedWordToken);
            }
            case 20: 
            case 90: {
                return m_formatter.formatToken(content, scanner.structureToken);
            }
            case 50: {
                return m_formatter.formatToken(content, scanner.sysvarToken);
            }
            case 30: 
            case 31: {
                return m_formatter.formatToken(content, scanner.structFieldToken);
            }
            case 10: 
            case 11: {
                return m_formatter.formatToken(content, scanner.keywordToken);
            }
            case 110: {
                return m_formatter.formatToken(content, scanner.idldocToken);
            }
            case 60: {
                return content;
            }
        }
        if (isCommandLine) {
            return m_formatter.formatWords(content);
        }
        return m_formatter.format(content, false, "", null);
    }

    public ICompletionProposal getCompletionProposal(ProWordPartDetector word, boolean isCommandLine) {
        if (this.m_CompletionProposal != null) {
            return this.m_CompletionProposal;
        }
        int offset = word.getOffset();
        int length = word.getString().length();
        String replacementString = this.getProposalString();
        Image image = this.getProposalImage();
        String displayString = replacementString;
        int type = this.getProposalType();
        if (type == 71 || type == 81 || type == 83) {
            replacementString = String.valueOf(replacementString) + "(";
            displayString = String.valueOf(displayString) + "( )";
            if (!this.isFunctionArgs()) {
                replacementString = String.valueOf(replacementString) + ")";
            }
        } else if (type == 10 || type == 11) {
            if (!word.isSlashBeforePrefix()) {
                replacementString = String.valueOf(replacementString) + "=";
            }
            displayString = String.valueOf(displayString) + "=";
        } else if (type == 20) {
            String tickChar = "'";
            if (word.isTickBeforePrefix()) {
                tickChar = word.getTickCharacter();
                if (replacementString.startsWith(tickChar)) {
                    replacementString = replacementString.substring(1);
                }
            } else if (!replacementString.startsWith(tickChar)) {
                replacementString = String.valueOf(tickChar) + replacementString;
            }
            replacementString = String.valueOf(replacementString) + tickChar;
        }
        if (word.getActivationPrefixChars().equals(".") && replacementString.charAt(0) == '.') {
            replacementString = replacementString.substring(1);
        }
        replacementString = this.format(replacementString, type, isCommandLine);
        CompletionProposal result = new CompletionProposal(replacementString, offset, length, replacementString.length(), image, displayString, null, this.getProposalHoverHelp());
        return result;
    }
}

