/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor.pro;

import com.rsi.idldt.core.internal.dom.RestructuredTextDOMTree;
import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.proeditor.ProEditorServices;
import com.rsi.idldt.proeditor.pro.ProCodeScanner;
import com.rsi.idldt.ui.UIPlugin;
import com.rsi.idldt.ui.UIPreferenceManager;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProWordFormattingStrategy
extends ContextBasedFormattingStrategy {
    final String newline = System.getProperty("line.separator");
    String m_indentChars;
    String m_currentIndentation;
    String m_lastLine = "";
    String m_lastLastLine = "";
    boolean m_bContinuationIndent = false;
    boolean m_useSpaces = false;
    int m_tabWidth = 4;
    int m_reservedWordFormatting = 0;
    int m_systemRoutineFormatting = 0;
    int m_userRoutineFormatting = 0;
    int m_structFieldFormatting = 0;
    int m_structureFormatting = 0;
    int m_sysvarFormatting = 0;
    int m_keywordFormatting = 0;
    int m_idldocFormatting = 0;

    public ProWordFormattingStrategy() {
        this.setPrefs();
    }

    private void setPrefs() {
        IPreferenceStore ps = UIPreferenceManager.getPreferenceStore();
        this.m_useSpaces = ps.getBoolean("IDLDT_SPACES_FOR_TABS");
        this.m_reservedWordFormatting = ps.getInt("IDLDT_RESERVED_WORD_FORMATTING");
        this.m_systemRoutineFormatting = ps.getInt("IDLDT_SYSTEM_ROUTINE_FORMATTING");
        this.m_userRoutineFormatting = ps.getInt("IDLDT_USER_ROUTINE_FORMATTING");
        this.m_structFieldFormatting = ps.getInt("IDLDT_STRUCT_FIELD_FORMATTING");
        this.m_structureFormatting = ps.getInt("IDLDT_STRUCTURE_FORMATTING");
        this.m_sysvarFormatting = ps.getInt("IDLDT_SYSVAR_FORMATTING");
        this.m_keywordFormatting = ps.getInt("IDLDT_KEYWORD_FORMATTING");
        this.m_idldocFormatting = ps.getInt("IDLDT_IDLDOC_FORMATTING");
        this.m_indentChars = this.getConfiguredIndentation();
    }

    public void formatterStarts(String initialIndentation) {
        this.m_currentIndentation = initialIndentation;
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor instanceof ProEditor) {
            this.m_tabWidth = ((ProEditor)activeEditor).getTabWidth();
        }
        this.setPrefs();
    }

    protected void bumpVarOffsets(int currentOffset, TemplateVariable[] vars, int bumpAmount) {
        int i = 0;
        while (i < vars.length) {
            int[] vos = vars[i].getOffsets();
            int k = 0;
            while (k < vos.length) {
                if (vos[k] >= currentOffset) {
                    int n = k;
                    vos[n] = vos[n] + bumpAmount;
                }
                ++k;
            }
            vars[i].setOffsets(vos);
            ++i;
        }
    }

    public String formatIDLdocTemplates(String content, boolean isLineStart, TemplateVariable[] vars) {
        ArrayList<String> lines = this.makeLines(content, false);
        StringBuffer formattedContent = new StringBuffer();
        int nlines = lines.size();
        int currentOffset = 0;
        int i = 0;
        while (i < nlines) {
            String line = lines.get(i);
            if ((i > 0 || i == 0 && isLineStart) && !line.startsWith(";")) {
                formattedContent.append("; ");
                this.bumpVarOffsets(currentOffset += 2, vars, 2);
            }
            formattedContent.append(line);
            currentOffset += line.length();
            if (i < nlines - 1) {
                formattedContent.append(this.newline);
                currentOffset += this.newline.length();
            }
            ++i;
        }
        String result = formattedContent.toString();
        return result;
    }

    public String format(String content, boolean isLineStart, String indentation, int[] positions) {
        this.m_lastLine = "";
        this.m_lastLastLine = "";
        this.m_bContinuationIndent = false;
        boolean bIndentFirstLine = true;
        if (isLineStart) {
            this.m_currentIndentation = indentation;
        } else {
            bIndentFirstLine = false;
        }
        ArrayList<String> lines = this.makeLines(content, true);
        int nlines = lines.size();
        String orig_lastLine = lines.get(nlines - 1);
        StringBuffer formattedContent = new StringBuffer();
        int i = 0;
        while (i < nlines) {
            String line = lines.get(i);
            if (i > 0 || i == 0 && bIndentFirstLine) {
                this.computeIndentation(line);
                if (i != nlines - 1 || !this.allWhitespace(orig_lastLine)) {
                    formattedContent.append(this.m_currentIndentation);
                }
            } else {
                this.m_lastLine = line.toLowerCase();
                this.m_lastLine = this.trimTrailingComments(this.m_lastLine).trim();
            }
            if (i == nlines - 1 && this.allWhitespace(orig_lastLine)) {
                line = orig_lastLine;
            }
            formattedContent.append(line);
            if (i < nlines - 1) {
                formattedContent.append(this.newline);
            }
            ++i;
        }
        String result = formattedContent.toString();
        result = this.formatWords(result);
        result = this.correctCommentIndentation(result);
        return result;
    }

    protected boolean allWhitespace(String line) {
        return line.trim().length() == 0;
    }

    protected String trimTrailingComments(String line) {
        int i = line.indexOf(59);
        if (i >= 0) {
            return line.substring(0, i);
        }
        return line;
    }

    protected boolean validStatementAfterElseOnThisLine(String theLine) {
        boolean result = false;
        String line = theLine.toLowerCase();
        int index = line.indexOf("else");
        if ((line = line.substring(index + 4).trim()).length() > 0 && !line.equals("$")) {
            result = true;
        }
        return result;
    }

    protected void computeIndentation(String theLine) {
        int endIndex;
        String line = theLine.toLowerCase();
        if ((line = this.trimTrailingComments(line).trim()).length() == 0) {
            return;
        }
        String firstToken = this.getLinesFirstToken(this.m_lastLine);
        String lastToken = this.getLinesLastToken(this.m_lastLine);
        if (firstToken.equals("pro") || firstToken.equals("function") || firstToken.equals("else") || lastToken.equals("begin") || firstToken.equals("case") || firstToken.equals("switch")) {
            if (!(firstToken.equals("else") && !lastToken.equals("begin") && this.validStatementAfterElseOnThisLine(this.m_lastLine) || lastToken.equals("begin") && this.getLinesLastToken(this.m_lastLastLine).equals("$"))) {
                this.m_currentIndentation = String.valueOf(this.m_currentIndentation) + this.m_indentChars;
            }
            this.m_bContinuationIndent = this.m_lastLine.endsWith("$");
        }
        if (this.m_lastLine.endsWith("$") && !this.m_lastLastLine.endsWith("$")) {
            this.m_currentIndentation = String.valueOf(this.m_currentIndentation) + this.m_indentChars;
            this.m_bContinuationIndent = true;
        }
        if (((firstToken = this.getLinesFirstToken(line)).equals("endif") || firstToken.equals("end") || firstToken.equals("endfor") || firstToken.equals("endcase") || firstToken.equals("endwhile") || firstToken.equals("endswitch") || firstToken.equals("endrep") || firstToken.equals("endelse") || firstToken.equals("pro ") || firstToken.equals("else") || firstToken.startsWith("function ")) && (endIndex = this.m_currentIndentation.length() - this.m_indentChars.length()) >= 0) {
            this.m_currentIndentation = this.m_currentIndentation.substring(0, this.m_currentIndentation.length() - this.m_indentChars.length());
        }
        if (!this.m_lastLine.endsWith("$") && this.m_bContinuationIndent) {
            this.m_bContinuationIndent = false;
            endIndex = this.m_currentIndentation.length() - this.m_indentChars.length();
            if (endIndex >= 0) {
                this.m_currentIndentation = this.m_currentIndentation.substring(0, this.m_currentIndentation.length() - this.m_indentChars.length());
            }
        }
        this.m_lastLastLine = this.m_lastLine;
        this.m_lastLine = line;
    }

    protected ArrayList<String> makeLines(String content, boolean bTrimLeadingAndTrailing) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer line = new StringBuffer();
        int i = 0;
        while (i < content.length()) {
            char c = content.charAt(i);
            if (c == '\n') {
                if (bTrimLeadingAndTrailing) {
                    lines.add(line.toString().trim());
                } else {
                    lines.add(line.toString());
                }
                line.delete(0, line.length());
            } else if (c != '\r') {
                line.append(c);
            }
            ++i;
        }
        if (bTrimLeadingAndTrailing) {
            lines.add(line.toString().trim());
        } else {
            lines.add(line.toString());
        }
        return lines;
    }

    public String formatToken(String theWord, IToken token) {
        int format = 0;
        ProCodeScanner scanner = ProEditorServices.getProCodeScanner();
        String word = theWord;
        if (token == scanner.reservedWordToken) {
            format = this.m_reservedWordFormatting;
        } else if (token == scanner.systemFunctionToken || token == scanner.systemProcedureToken) {
            format = this.m_systemRoutineFormatting;
        } else if (token == scanner.userFunctionToken || token == scanner.userProcedureToken) {
            format = this.m_userRoutineFormatting;
        } else if (token == scanner.structFieldToken) {
            format = this.m_structFieldFormatting;
        } else if (token == scanner.structureToken) {
            format = this.m_structureFormatting;
        } else if (token == scanner.sysvarToken) {
            format = this.m_sysvarFormatting;
        } else if (token == scanner.keywordToken) {
            format = this.m_keywordFormatting;
        } else if (token == scanner.idldocToken && !word.trim().startsWith("${")) {
            format = this.m_idldocFormatting;
        }
        switch (format) {
            case 1: {
                word = word.toUpperCase();
                break;
            }
            case 2: {
                word = word.toLowerCase();
                break;
            }
            case 3: {
                word = this.upCaseFirstLetter(word);
                break;
            }
        }
        return word;
    }

    public String formatWords(String content) {
        IToken token;
        if (this.m_reservedWordFormatting == 0 && this.m_systemRoutineFormatting == 0 && this.m_userRoutineFormatting == 0 && this.m_structFieldFormatting == 0 && this.m_structureFormatting == 0 && this.m_sysvarFormatting == 0 && this.m_keywordFormatting == 0 && this.m_idldocFormatting == 0) {
            return content;
        }
        StringBuffer newContent = new StringBuffer(content);
        ProCodeScanner scanner = ProEditorServices.getProCodeScanner();
        Document doc = new Document(content);
        scanner.setRange((IDocument)doc, 0, content.length());
        while (!(token = scanner.nextToken()).isEOF()) {
            int end;
            int start;
            String word;
            String newWord;
            if (token == scanner.otherToken || (newWord = token == scanner.commentToken ? this.formatCommentToken(scanner, word) : this.formatToken(word, token)).equals(word = newContent.substring(start = scanner.getTokenOffset(), end = start + scanner.getTokenLength()))) continue;
            newContent.replace(start, end, newWord);
        }
        return newContent.toString();
    }

    protected String formatCommentToken(ProCodeScanner scanner, String comment) {
        StringBuffer sb = new StringBuffer();
        TreeSet hs = RestructuredTextDOMTree.getRoutineTagTreeSet();
        StringTokenizer st = new StringTokenizer(comment, " ;\t\r\n", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (hs.contains(token.toLowerCase())) {
                sb.append(this.formatToken(token, scanner.idldocToken));
                continue;
            }
            sb.append(token);
        }
        String formattedString = sb.toString();
        return formattedString;
    }

    protected String upCaseFirstLetter(String token) {
        if (token == null || token.length() == 0) {
            return token;
        }
        char[] array = token.toCharArray();
        boolean foundLetter = false;
        int i = 0;
        while (i < token.length()) {
            if (!foundLetter) {
                foundLetter = Character.isLetter(array[i]);
                array[i] = Character.toUpperCase(array[i]);
            } else {
                array[i] = Character.toLowerCase(array[i]);
            }
            ++i;
        }
        return String.valueOf(array);
    }

    public void formatterStops() {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor instanceof ProEditor) {
            ProEditor proEditor = (ProEditor)activeEditor;
            proEditor.removeOccurrenceAnnotations();
        }
    }

    protected String getConfiguredIndentation() {
        if (this.m_useSpaces) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.m_tabWidth) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        return "\t";
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchWindow wbw = UIPlugin.getActiveWorkbenchWindow();
        if (wbw == null) {
            return null;
        }
        IWorkbenchPage activePage = wbw.getActivePage();
        if (activePage == null) {
            return null;
        }
        return activePage.getActiveEditor();
    }

    protected String getLinesFirstToken(String line) {
        StringTokenizer st = new StringTokenizer(line, " \n\t\r", false);
        String firstToken = "";
        if (st.hasMoreTokens()) {
            firstToken = st.nextToken();
        }
        return firstToken.toLowerCase();
    }

    protected String getLinesLastToken(String line) {
        StringTokenizer st = new StringTokenizer(line, " \n\t\r", false);
        String lastToken = "";
        while (st.hasMoreTokens()) {
            lastToken = st.nextToken();
        }
        return lastToken.toLowerCase();
    }

    protected boolean isCommentLine(String line) {
        boolean bAnswer = false;
        if (line.trim().startsWith(";")) {
            bAnswer = true;
        }
        return bAnswer;
    }

    protected String correctCommentIndentation(String content) {
        ArrayList<String> lines = this.makeLines(content, false);
        StringBuffer sb = new StringBuffer();
        String correctIndentation = "";
        int numLines = lines.size();
        int i = numLines - 1;
        while (i >= 0) {
            String line = lines.get(i);
            if (this.isCommentLine(line)) {
                line = String.valueOf(correctIndentation) + line.trim();
                lines.set(i, line);
            } else if (line.trim().length() > 0) {
                sb.delete(0, sb.length());
                int k = line.length();
                int j = 0;
                while (j < k) {
                    if (!Character.isWhitespace(line.charAt(j))) break;
                    sb.append(line.charAt(j));
                    ++j;
                }
                correctIndentation = sb.toString();
            }
            --i;
        }
        StringBuffer formattedContent = new StringBuffer();
        int i2 = 0;
        while (i2 < numLines) {
            formattedContent.append(lines.get(i2));
            if (i2 < numLines - 1) {
                formattedContent.append(this.newline);
            }
            ++i2;
        }
        return formattedContent.toString();
    }
}

