/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor.pro;

import com.rsi.idldt.proeditor.utils.ProWordDetector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyledText;

public class ProWordFinder {
    private static final String ADDITIONAL_WORD_PARTS = ":";

    private static boolean isIDLWordPart(char c, boolean allowWordPart) {
        return ProWordDetector.isIDLIdentifierPart(c) || allowWordPart && ADDITIONAL_WORD_PARTS.indexOf(c) >= 0;
    }

    public static IRegion findWord(StyledText styledText, int offset, boolean shouldAllowColon) {
        boolean allowColon = shouldAllowColon;
        int start = -1;
        int end = -1;
        String txt = styledText.getText(offset, offset);
        char c = txt.charAt(0);
        if (!ProWordFinder.isIDLWordPart(c, true)) {
            return new Region(offset, 0);
        }
        if (c == ':') {
            allowColon = true;
        }
        int pos = offset - 1;
        while (pos >= 0) {
            txt = styledText.getText(pos, pos);
            c = txt.charAt(0);
            if (!ProWordFinder.isIDLWordPart(c, allowColon)) break;
            --pos;
        }
        start = pos + 1;
        pos = offset;
        int length = styledText.getText().length();
        while (pos < length) {
            txt = styledText.getText(pos, pos);
            c = txt.charAt(0);
            if (!ProWordFinder.isIDLWordPart(c, allowColon)) break;
            ++pos;
        }
        end = pos;
        if (start > -1 && end > -1) {
            return new Region(start, end - start);
        }
        return null;
    }

    public static IRegion findWord(IDocument document, int offset, boolean shouldAllowColon) {
        int start = -1;
        int end = -1;
        boolean allowColon = shouldAllowColon;
        try {
            char c = document.getChar(offset);
            if (!ProWordFinder.isIDLWordPart(c, true)) {
                return new Region(offset, 0);
            }
            if (c == ':') {
                allowColon = true;
            }
            int pos = offset - 1;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!ProWordFinder.isIDLWordPart(c, allowColon)) break;
                --pos;
            }
            start = pos + 1;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!ProWordFinder.isIDLWordPart(c, allowColon)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {}
        if (start > -1 && end > -1) {
            return new Region(start, end - start);
        }
        return null;
    }
}

