/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor.pro;

import com.rsi.idldt.core.dom.IIDLDOMManager;
import com.rsi.idldt.core.dom.IIDLField;
import com.rsi.idldt.core.dom.IIDLKeyword;
import com.rsi.idldt.core.dom.IIDLRoutine;
import com.rsi.idldt.core.dom.IIDLScopeVar;
import com.rsi.idldt.core.dom.IIDLStructure;
import com.rsi.idldt.core.dom.IIDLSysVar;
import com.rsi.idldt.core.internal.dom.IDLDOMManager;
import com.rsi.idldt.core.internal.dom.RestructuredTextDOMTree;
import com.rsi.idldt.core.utils.Tracer;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.internal.ui.views.CommandLineView;
import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.proeditor.ProTemplateCompletionProcessor;
import com.rsi.idldt.proeditor.ProTemplateProposal;
import com.rsi.idldt.proeditor.ProTextHover;
import com.rsi.idldt.proeditor.pro.Proposal;
import com.rsi.idldt.proeditor.utils.ProEditorUtilities;
import com.rsi.idldt.proeditor.utils.ProWordPartDetector;
import com.rsi.idldt.ui.UIPlugin;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProCompletionProcessor
implements IContentAssistProcessor {
    public static final int KEYWORD_NORMAL_IDL_EDITOR = 0;
    public static final int KEYWORD_IDL_COMMAND_LINE = 1;
    protected IContextInformationValidator m_validator = new Validator();
    protected ProTemplateCompletionProcessor m_templateProcessor;
    protected TreeSet<String> filterStructNames = new TreeSet();
    protected ArrayList<String> filterStructPrefixes = new ArrayList();
    protected int m_workingFor = 0;
    protected int m_IDLdocFindFlags = 3;

    public ProCompletionProcessor() {
        this.m_templateProcessor = new ProTemplateCompletionProcessor(false);
        this.filterStructNames.add("ann_fake_event");
        this.filterStructNames.add("ann_state");
        this.filterStructPrefixes.add("!");
        this.filterStructPrefixes.add("IDLAnonymousStruct".toLowerCase());
        this.filterStructPrefixes.add("_IDLit".toLowerCase());
    }

    public ProCompletionProcessor(int workingFor) {
        this();
        this.m_workingFor = workingFor;
        if (this.m_workingFor == 1) {
            this.m_templateProcessor = new ProTemplateCompletionProcessor(true);
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ProWordPartDetector wordPart;
        String activationChars;
        TreeSet<Proposal> proposalTree = new TreeSet<Proposal>();
        ICompletionProposal[] templateProposals = null;
        boolean bIncludeExecutiveCommands = this.m_workingFor == 1;
        boolean bAddGlobalProcedureProposals = false;
        boolean bAddIDLReservedWords = false;
        boolean bAddWordsInDocument = false;
        boolean bAddProCodeTemplates = false;
        boolean bCanUseDebugModel = false;
        if (this.m_workingFor == 1) {
            bCanUseDebugModel = true;
        }
        if ((activationChars = (wordPart = new ProWordPartDetector(viewer, offset, bCanUseDebugModel)).getActivationPrefixChars()).equals(":")) {
            if (!wordPart.isLineStartsWithCommentChar()) {
                return null;
            }
            if (!wordPart.isLineEmptySoFar()) {
                return null;
            }
        }
        if (activationChars.equals(">")) {
            return null;
        }
        if (activationChars.equals(".") && !wordPart.isLineStartsWithCommentChar()) {
            String line;
            IIDLStructure idl_struct = wordPart.associateDotWithIDLStructure();
            if (idl_struct != null) {
                this.addStructureFieldProposals(wordPart, idl_struct, proposalTree, false);
            } else if (this.m_workingFor == 1 && (line = wordPart.getCurrentLine()).trim().startsWith(".")) {
                bAddGlobalProcedureProposals = true;
            }
        } else if (activationChars.equals("->") && !wordPart.isLineStartsWithCommentChar()) {
            String className = wordPart.associatePointerWithClassName(wordPart.getOffset() - 3);
            this.addClassMethodProposals(wordPart, className, false, proposalTree);
        } else if (wordPart.isLineStartsWithCommentChar()) {
            if (activationChars.trim().equals("") || activationChars.equals(":") || activationChars.equals("$")) {
                templateProposals = this.m_templateProcessor.computeIDLdocCompletionProposals(viewer, offset, wordPart.getString());
                int i = 0;
                while (i < templateProposals.length) {
                    proposalTree.add(new Proposal(templateProposals[i], 40));
                    ++i;
                }
                this.addIDLdocProposals(wordPart, proposalTree);
            }
        } else if (wordPart.isShowSystemVariableList()) {
            this.addSystemVariableProposals(wordPart, proposalTree);
        } else if (wordPart.isShowClassNameList()) {
            this.addClassNameProposals(wordPart, proposalTree);
        } else if (wordPart.isShowStructureNameList()) {
            this.addStructureNameProposals(wordPart, proposalTree);
        } else if (wordPart.isShowKeywordList()) {
            this.addKeywordsForFunctOrProc(wordPart, proposalTree);
            if (!wordPart.isSlashBeforePrefix()) {
                bAddGlobalProcedureProposals = true;
                bAddIDLReservedWords = true;
                bAddWordsInDocument = true;
                bAddProCodeTemplates = true;
                this.addScopeVariableProposals(wordPart, proposalTree);
            }
        } else {
            bAddGlobalProcedureProposals = true;
            bAddIDLReservedWords = true;
            bAddWordsInDocument = true;
            bAddProCodeTemplates = true;
            this.addScopeVariableProposals(wordPart, proposalTree);
        }
        if (bAddProCodeTemplates) {
            templateProposals = this.m_templateProcessor.computeProCodeCompletionProposals(viewer, offset, wordPart.getString());
            int i = 0;
            while (i < templateProposals.length) {
                proposalTree.add(new Proposal(templateProposals[i], 40));
                ++i;
            }
        }
        if (bAddGlobalProcedureProposals) {
            this.addGlobalProcedureProposals(wordPart, proposalTree, bIncludeExecutiveCommands);
        }
        if (bAddIDLReservedWords) {
            this.addIDLReservedWords(wordPart, proposalTree);
        }
        if (bAddWordsInDocument) {
            this.addWordsInDocument(wordPart, proposalTree);
        }
        ICompletionProposal[] finalProposalArray = this.turnProposalVectorIntoAdaptedArray(wordPart, proposalTree);
        boolean bAutoInsert = true;
        if (finalProposalArray.length == 1 && finalProposalArray[0].getClass() == ProTemplateProposal.class) {
            ProTemplateProposal prop = (ProTemplateProposal)finalProposalArray[0];
            bAutoInsert = prop.getProposalsTemplate().isAutoInsertable();
        }
        if (this.m_workingFor == 0) {
            ProEditor editor = this.getActiveEditor();
            if (editor != null) {
                editor.enableContentAssistAutoInsert(bAutoInsert);
            }
        } else {
            CommandLineView.getInstance().enableContentAssistAutoInsert(bAutoInsert);
        }
        return finalProposalArray;
    }

    protected ProEditor getActiveEditor() {
        IEditorPart activeEditor;
        IWorkbenchPage p = UIPlugin.getActivePage();
        if (p != null && (activeEditor = p.getActiveEditor()) instanceof ProEditor) {
            return (ProEditor)activeEditor;
        }
        return null;
    }

    protected boolean looksLikeKeywordOrParamDocLine(ProWordPartDetector wordPart) {
        String line = wordPart.getCurrentLine().trim();
        String[] tokens = (line = line.substring(1).trim()).split(" +");
        if (tokens.length == 0) {
            return false;
        }
        if (tokens[0].endsWith(":")) {
            return !tokens[0].startsWith(":");
        }
        if (tokens.length == 1) {
            return false;
        }
        return tokens[1].startsWith(":");
    }

    public void setIDLdocFindFlags(int flags) {
        this.m_IDLdocFindFlags = flags;
    }

    protected void addIDLdocProposals(ProWordPartDetector wordPart, TreeSet<Proposal> proposalTree) {
        String token = wordPart.getString().toLowerCase().trim();
        String[] doctags = new String[]{};
        if (wordPart.isLineEmptySoFar()) {
            doctags = RestructuredTextDOMTree.findIDLdocTags((String)token, (int)this.m_IDLdocFindFlags);
        } else if (this.looksLikeKeywordOrParamDocLine(wordPart)) {
            doctags = RestructuredTextDOMTree.findIDLdocAttributes((String)token);
        }
        int i = 0;
        while (i < doctags.length) {
            Proposal p = doctags[i].startsWith(":") ? new Proposal(doctags[i], 110, Messages.ProCompletionProcessor_IDLdocTag) : new Proposal(doctags[i], 110, Messages.ProCompletionProcessor_IDLdocAttribute);
            proposalTree.add(p);
            ++i;
        }
    }

    protected void addSystemVariableProposals(ProWordPartDetector wordPart, TreeSet<Proposal> proposalTree) {
        IIDLDOMManager dm = IDLDOMManager.getActiveManager();
        if (dm == null) {
            return;
        }
        int flags = 48;
        String token = wordPart.getString().toUpperCase().trim();
        flags = token == null || token.length() == 0 ? (flags |= 0x800) : (flags |= 0x200);
        IIDLSysVar[] sysvars = dm.findSystemVariables(token, flags);
        int i = 0;
        while (i < sysvars.length) {
            Proposal p = new Proposal(sysvars[i].getElementName(), 50, Messages.ProCompletionProcessor_SystemVariable);
            proposalTree.add(p);
            ++i;
        }
    }

    protected void addScopeVariableProposals(ProWordPartDetector wordPart, TreeSet<Proposal> proposalTree) {
        IIDLDOMManager dm = IDLDOMManager.getActiveManager();
        if (dm == null) {
            return;
        }
        int flags = 32;
        String token = wordPart.getString().toUpperCase().trim();
        flags = token == null || token.length() == 0 ? (flags |= 0x800) : (flags |= 0x200);
        IIDLScopeVar[] scopeVars = dm.findScopeVariables(token, flags);
        int i = 0;
        while (i < scopeVars.length) {
            Proposal p = new Proposal(scopeVars[i].getElementName(), 5, Messages.ProCompletionProcessor_ScopeVariable);
            proposalTree.add(p);
            ++i;
        }
    }

    private void filterCatalogHits(IIDLRoutine[] routines) {
        String previous = "";
        int idupstart = 0;
        int icatalog = -1;
        int i = 0;
        while (i < routines.length) {
            String rname = routines[i].getRoutineName().toLowerCase();
            String path = routines[i].getFilename();
            if (!rname.equals(previous)) {
                idupstart = i;
                icatalog = -1;
            }
            if (path == null) {
                icatalog = i;
            }
            if (icatalog != -1) {
                int j = idupstart;
                while (j < i) {
                    if (j != icatalog) {
                        routines[j] = null;
                    }
                    ++j;
                }
            }
            previous = rname;
            ++i;
        }
    }

    protected void addGlobalProcedureProposals(ProWordPartDetector wordPart, TreeSet<Proposal> proposalTree, boolean includeExecutiveCommands) {
        String prefix;
        IIDLDOMManager dm;
        boolean bJustFunctions = false;
        if (wordPart.isRightSideOfEquals() || wordPart.isShowKeywordList()) {
            bJustFunctions = true;
        }
        if ((dm = IDLDOMManager.getActiveManager()) == null) {
            return;
        }
        int flags = 1542;
        flags |= 0x70;
        if (!bJustFunctions) {
            flags |= 1;
        }
        String token = wordPart.getString();
        if (includeExecutiveCommands && (prefix = wordPart.getActivationPrefixChars()).equals(".")) {
            token = "." + token;
        }
        if (token.length() == 0) {
            flags |= 0x800;
        }
        Object[] routines = dm.findRoutines(token, flags);
        Arrays.sort(routines);
        this.filterCatalogHits((IIDLRoutine[])routines);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < routines.length) {
            if (routines[i] != null) {
                String rname = routines[i].getRoutineName();
                if ((includeExecutiveCommands || !rname.startsWith(".")) && rname.indexOf("...") <= -1 && rname.length() != 0) {
                    Proposal p;
                    String doc = null;
                    if (i < 100) {
                        if (ProEditor.isFullHTMLSupported()) {
                            if (buffer.length() > 0) {
                                buffer.delete(0, buffer.length());
                            }
                            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (URL)ProTextHover.getStyleSheetURL());
                            buffer.append(routines[i].getDocString(ProEditor.isFullHTMLSupported()));
                            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
                            doc = buffer.toString();
                        } else {
                            doc = routines[i].getDocString(ProEditor.isFullHTMLSupported());
                        }
                    }
                    if (routines[i].isFunction()) {
                        p = new Proposal(rname, 71, doc);
                        boolean bHasArgs = routines[i].getNumberOfKeywords() + routines[i].getNumberOfParameters() != 0;
                        p.setFunctionHasArgs(bHasArgs);
                    } else {
                        p = new Proposal(rname, 70, doc);
                    }
                    proposalTree.add(p);
                }
            }
            ++i;
        }
    }

    protected void addKeywordsForFunctOrProc(ProWordPartDetector wordPart, TreeSet<Proposal> proposalTree) {
        int i;
        String functionName;
        boolean bJustFunctions;
        IIDLDOMManager dm = IDLDOMManager.getActiveManager();
        if (dm == null) {
            return;
        }
        int flags = 2;
        boolean bl = bJustFunctions = wordPart.isFunctionKeywordsNeeded();
        if (!bJustFunctions) {
            flags |= 1;
            functionName = wordPart.getKeywordProcName();
        } else {
            functionName = wordPart.getKeywordFunctionName();
        }
        if (functionName == null || functionName.length() == 0) {
            return;
        }
        flags |= 0x30;
        String idlClassName = null;
        int idx_double_colon = functionName.indexOf("::");
        if (idx_double_colon >= 0) {
            idlClassName = functionName.substring(0, idx_double_colon);
            functionName = functionName.substring(idx_double_colon + 2);
        } else {
            idlClassName = wordPart.getIDLClassName();
        }
        if (idlClassName != null) {
            if (idlClassName.startsWith("self:")) {
                idlClassName = idlClassName.substring(5);
            }
            flags |= 8;
            functionName = String.valueOf(idlClassName) + "::" + functionName;
        } else {
            flags |= 4;
        }
        IIDLRoutine[] routines = dm.findRoutines(functionName, flags);
        if (routines.length == 0 && idlClassName != null) {
            String[] superClassNames = ProCompletionProcessor.getSuperClassNames(idlClassName);
            if (superClassNames == null) {
                return;
            }
            i = 0;
            while (i < superClassNames.length) {
                int beginIndex = functionName.indexOf("::");
                functionName = functionName.substring(beginIndex + 2);
                functionName = String.valueOf(superClassNames[i]) + "::" + functionName;
                routines = dm.findRoutines(functionName, flags);
                if (routines.length > 0) break;
                ++i;
            }
        }
        if (routines.length == 0) {
            return;
        }
        IIDLRoutine routine = null;
        if (routines.length > 1) {
            i = 0;
            while (i < routines.length) {
                IIDLRoutine r = routines[i];
                if (r.getFilename() == null) {
                    routine = r;
                    break;
                }
                ++i;
            }
        }
        if (routine == null) {
            routine = routines[0];
        }
        String keywordPrefix = wordPart.getString().toUpperCase();
        IIDLKeyword[] keywords = routine.getKeywords();
        int i2 = 0;
        while (i2 < keywords.length) {
            String keyword = keywords[i2].getElementName().toUpperCase();
            if (idlClassName != null && (keyword.equals("_REF_EXTRA") || keyword.equals("_EXTRA"))) {
                this.addInheritingClassMethodKeywords(bJustFunctions, functionName, wordPart, idlClassName, routine, proposalTree);
                if (routine.isClassMethod() && routine.getFilename() != null && functionName.toLowerCase().endsWith("::init")) {
                    ProWordPartDetector secondaryWordPart = new ProWordPartDetector(wordPart.getViewer(), wordPart.getOffset(), wordPart.canUseDebugModel());
                    secondaryWordPart.setFunctionName(null);
                    secondaryWordPart.setProcedureName("setproperty");
                    secondaryWordPart.setClassName(idlClassName);
                    secondaryWordPart.setString(wordPart.getString());
                    this.addKeywordsForFunctOrProc(secondaryWordPart, proposalTree);
                }
            } else if (keywordPrefix.length() <= 0 || keyword.startsWith(keywordPrefix)) {
                Proposal p = new Proposal(keyword, 10, null);
                proposalTree.add(p);
            }
            ++i2;
        }
        if (functionName.toUpperCase().equals("OBJ_NEW")) {
            String className = wordPart.getClassNameFromObjNewLine();
            ProWordPartDetector secondaryWordPart = new ProWordPartDetector(wordPart.getViewer(), wordPart.getOffset(), wordPart.canUseDebugModel());
            secondaryWordPart.setFunctionName("init");
            secondaryWordPart.setClassName(className);
            secondaryWordPart.setString(wordPart.getString());
            this.addKeywordsForFunctOrProc(secondaryWordPart, proposalTree);
        }
    }

    public static String[] getSuperClassNames(String idlClassName) {
        ArrayList<String> list = new ArrayList<String>();
        IIDLStructure idl_struct = ProCompletionProcessor.findNamedStructure(idlClassName, true);
        if (idl_struct == null) {
            return null;
        }
        IIDLField[] fields = idl_struct.getFields();
        int i = 0;
        while (i < fields.length) {
            String superClassName;
            if (fields[i].isInherit() && !(superClassName = fields[i].getInheritedStructure()).equalsIgnoreCase("_" + idlClassName) && !list.contains(superClassName)) {
                list.add(superClassName);
            }
            ++i;
        }
        String[] a = new String[list.size()];
        return list.toArray(a);
    }

    protected void addInheritingClassMethodKeywords(boolean bJustFunctions, String theFunctionName, ProWordPartDetector wordPart, String idlClassName, IIDLRoutine routine, TreeSet<Proposal> proposalTree) {
        String functionName = theFunctionName;
        String superClassName = "";
        if (!routine.isClassMethod()) {
            return;
        }
        IIDLStructure idl_struct = ProCompletionProcessor.findNamedStructure(idlClassName, true);
        if (idl_struct == null) {
            return;
        }
        IIDLField[] fields = idl_struct.getFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].isInherit()) {
                superClassName = fields[i].getInheritedStructure();
                break;
            }
            ++i;
        }
        if (superClassName.length() == 0) {
            return;
        }
        int idx = functionName.indexOf("::");
        String methodName = functionName.substring(idx + 2);
        functionName = String.valueOf(superClassName) + "::" + methodName;
        IIDLDOMManager dm = IDLDOMManager.getActiveManager();
        if (dm == null) {
            return;
        }
        int flags = 0;
        flags = routine.isFunction() ? (flags |= 2) : (flags |= 1);
        IIDLRoutine[] routines = dm.findRoutines(functionName, flags |= 0x38);
        if (routines == null || routines.length < 1) {
            return;
        }
        IIDLRoutine superClassRoutine = routines[0];
        String keywordPrefix = wordPart.getString().toUpperCase();
        IIDLKeyword[] keywords = superClassRoutine.getKeywords();
        int i2 = 0;
        while (i2 < keywords.length) {
            String description;
            Proposal p;
            String keyword = keywords[i2].getElementName().toUpperCase();
            if (keyword.equals("_REF_EXTRA") || keyword.equals("_EXTRA")) {
                this.addInheritingClassMethodKeywords(bJustFunctions, functionName, wordPart, superClassName, routine, proposalTree);
            } else if ((keywordPrefix.length() <= 0 || keyword.startsWith(keywordPrefix)) && !proposalTree.contains(p = new Proposal(keyword, 11, description = String.valueOf(Messages.ProCompletionProcessor_InheritedFrom) + functionName))) {
                proposalTree.add(p);
            }
            ++i2;
        }
    }

    protected void addStructureFieldProposals(ProWordPartDetector wordPart, IIDLStructure idl_struct, TreeSet<Proposal> proposalTree, boolean bInherited) {
        if (idl_struct == null) {
            return;
        }
        IIDLField[] fields = idl_struct.getFields();
        String prefix = wordPart.getString().toLowerCase();
        int proposal_type = bInherited ? 31 : 30;
        int i = 0;
        while (i < fields.length) {
            String fieldName = fields[i].getElementName();
            if (fieldName.toLowerCase().startsWith("idlanonymousfield") || fieldName.toLowerCase().startsWith(prefix)) {
                if (fields[i].isInherit()) {
                    String inherited_struct_name = fields[i].getInheritedStructure();
                    IIDLStructure inherited_struct = ProCompletionProcessor.findNamedStructure(inherited_struct_name, false);
                    this.addStructureFieldProposals(wordPart, inherited_struct, proposalTree, true);
                } else {
                    Proposal p = new Proposal(fields[i].getElementName(), proposal_type, null);
                    proposalTree.add(p);
                }
            }
            ++i;
        }
    }

    public static IIDLStructure findNamedStructure(String struct_name, boolean bMustBeAClass) {
        IIDLDOMManager dm = IDLDOMManager.getActiveManager();
        if (dm == null) {
            return null;
        }
        int flags = 127;
        IIDLStructure[] structures = dm.findStructures(struct_name, flags);
        if (structures == null || structures.length == 0) {
            return null;
        }
        if (structures.length > 1) {
            Tracer.trace((boolean)Tracer.IS_DEBUGGING, (String)"**While searching for a structure");
            Tracer.trace((boolean)Tracer.IS_DEBUGGING, (String)"**more than one structure was found");
            Tracer.trace((boolean)Tracer.IS_DEBUGGING, (String)("**with the name: " + struct_name));
        }
        if (bMustBeAClass) {
            int i = 0;
            while (i < structures.length) {
                if (structures[i].isClass()) {
                    return structures[i];
                }
                ++i;
            }
            return null;
        }
        return structures[0];
    }

    protected void addClassMethodProposals(ProWordPartDetector wordPart, String theClassName, boolean bIsSuperClass, TreeSet<Proposal> proposalVector) {
        boolean bJustFunctions;
        IIDLDOMManager dm;
        String className = theClassName;
        if (className == null || className.length() == 0) {
            return;
        }
        boolean bAccessThroughSelfKeyword = false;
        if (className.startsWith("self:")) {
            bAccessThroughSelfKeyword = true;
            className = className.substring(5);
        }
        if ((dm = IDLDOMManager.getActiveManager()) == null) {
            return;
        }
        int flags = 522;
        flags |= 0x30;
        boolean bl = bJustFunctions = wordPart.isRightSideOfEquals() || wordPart.isShowKeywordList();
        if (!bJustFunctions) {
            flags |= 1;
        }
        String matchStart = String.valueOf(className) + "::";
        String partialMethodName = wordPart.getString();
        if (partialMethodName.length() > 0) {
            matchStart = String.valueOf(matchStart) + partialMethodName;
        }
        IIDLRoutine[] routines = dm.findRoutines(matchStart, flags);
        int i = 0;
        while (i < routines.length) {
            String rname = routines[i].getRoutineName();
            if (!rname.startsWith(".") && !rname.equalsIgnoreCase("init")) {
                String routineName = routines[i].getRoutineName();
                if (bAccessThroughSelfKeyword && bIsSuperClass && this.proposalTreeContainsProposal(proposalVector, routineName)) {
                    routineName = String.valueOf(className) + "::" + routineName;
                }
                if (!this.proposalTreeContainsProposal(proposalVector, routineName)) {
                    Proposal p;
                    String doc;
                    if (routines[i].isFunction()) {
                        doc = routines[i].getDocString(false);
                        p = new Proposal(routineName, bIsSuperClass ? 83 : 81, doc);
                        boolean bHasArgs = routines[i].getNumberOfKeywords() + routines[i].getNumberOfParameters() != 0;
                        p.setFunctionHasArgs(bHasArgs);
                    } else {
                        doc = routines[i].getDocString(false);
                        p = new Proposal(routineName, bIsSuperClass ? 82 : 80, doc);
                    }
                    proposalVector.add(p);
                }
            }
            ++i;
        }
        ArrayList<String> derivedClassNameList = this.getDerivedClassNames(className);
        if (derivedClassNameList != null) {
            for (String derivedClassName : derivedClassNameList) {
                if (derivedClassName.equalsIgnoreCase("None")) continue;
                derivedClassName = bAccessThroughSelfKeyword ? "self:" + derivedClassName : derivedClassName;
                this.addClassMethodProposals(wordPart, derivedClassName, true, proposalVector);
            }
        }
    }

    protected ArrayList<String> getDerivedClassNames(String className) {
        IIDLDOMManager dm = IDLDOMManager.getActiveManager();
        if (dm == null) {
            return null;
        }
        ArrayList<String> inheritedList = new ArrayList<String>();
        int flags = 120;
        IIDLStructure[] structures = dm.findStructures(className, flags);
        if (structures != null && structures.length > 0) {
            IIDLStructure s = structures[0];
            IIDLField[] fields = s.getFields();
            int i = 0;
            while (i < fields.length) {
                if (fields[i].isInherit()) {
                    String inherited_struct_name = fields[i].getInheritedStructure();
                    inheritedList.add(inherited_struct_name);
                }
                ++i;
            }
        }
        if (inheritedList.size() == 0) {
            return null;
        }
        return inheritedList;
    }

    protected void addStructureNameProposals(ProWordPartDetector wordPart, TreeSet<Proposal> proposalTree) {
        TreeSet<String> tset = new TreeSet<String>();
        String prefix = wordPart.getString();
        int flags = 124;
        flags = prefix == null || prefix.length() == 0 ? (flags |= 0x800) : (flags |= 0x200);
        IIDLDOMManager dm = IDLDOMManager.getActiveManager();
        if (dm == null) {
            return;
        }
        IIDLStructure[] structures = dm.findStructures(prefix, flags);
        if (structures != null && structures.length > 0) {
            int i = 0;
            while (i < structures.length) {
                IIDLStructure s = structures[i];
                tset.add(s.getElementName());
                ++i;
            }
            for (String structName : tset) {
                if (this.inStructNameFilters(structName)) continue;
                Proposal p = new Proposal(structName, 90, null);
                proposalTree.add(p);
            }
        }
    }

    protected boolean inStructNameFilters(String theStructName) {
        String structName = theStructName.toLowerCase().trim();
        if (this.filterStructNames.contains(structName)) {
            return true;
        }
        int i = 0;
        while (i < this.filterStructPrefixes.size()) {
            String prefix = this.filterStructPrefixes.get(i);
            if (structName.startsWith(prefix)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void addWordsInDocument(ProWordPartDetector wordPart, TreeSet<Proposal> proposalTree) {
        TreeSet<String> words = wordPart.getMatchingWordsFromDoc();
        for (String word : words) {
            if (this.proposalTreeContainsProposal(proposalTree, word)) continue;
            Proposal p = new Proposal(word, 60, null);
            proposalTree.add(p);
        }
    }

    protected void addIDLReservedWords(ProWordPartDetector wordPart, TreeSet<Proposal> proposalTree) {
        String hoverHelp = "IDL Reserved Word";
        String[] words = ProEditorUtilities.RESERVED_WORDS;
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            String prefix = wordPart.getString().toLowerCase();
            if (word.toLowerCase().startsWith(prefix)) {
                Proposal p = new Proposal(word, 100, hoverHelp);
                proposalTree.add(p);
            }
            ++i;
        }
    }

    protected void addClassNameProposals(ProWordPartDetector wordPart, TreeSet<Proposal> proposalVector) {
        IIDLDOMManager dm = IDLDOMManager.getActiveManager();
        if (dm == null) {
            return;
        }
        String[] classNamesArray = dm.getClassNames();
        String prefix = wordPart.getString().toLowerCase();
        if (prefix.length() <= 0) {
            int i = 0;
            while (i < classNamesArray.length) {
                Proposal p = new Proposal(classNamesArray[i], 20, null);
                proposalVector.add(p);
                ++i;
            }
        } else {
            int i = 0;
            while (i < classNamesArray.length) {
                if (classNamesArray[i].toLowerCase().startsWith(prefix)) {
                    Proposal p = new Proposal(classNamesArray[i], 20, null);
                    proposalVector.add(p);
                }
                ++i;
            }
        }
    }

    protected ICompletionProposal[] turnProposalVectorIntoAdaptedArray(ProWordPartDetector word, TreeSet<Proposal> proposals) {
        ICompletionProposal[] result = new ICompletionProposal[proposals.size()];
        int index = 0;
        for (Proposal p : proposals) {
            result[index] = p.getCompletionProposal(word, this.m_workingFor == 1);
            ++index;
        }
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        IContextInformation[] result = new IContextInformation[]{new ContextInformation("contextDisplayString", "informationDisplayString"), new ContextInformation("contextDisplayString2", "informationDisplayString2")};
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'>', '.', ':'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.m_validator;
    }

    public boolean proposalTreeContainsProposal(TreeSet<Proposal> ptree, String propString) {
        for (Proposal prop : ptree) {
            if (!prop.getProposalString().equalsIgnoreCase(propString)) continue;
            return true;
        }
        return false;
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int m_installOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.m_installOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.m_installOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

