/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor.pro;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessListener;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.dom.IIDLDOMListener;
import com.rsi.idldt.core.dom.IIDLDOMManager;
import com.rsi.idldt.core.internal.dom.IDLDOMManager;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.proeditor.ProEditorServices;
import com.rsi.idldt.proeditor.pro.ProToken;
import com.rsi.idldt.proeditor.utils.DOMWordRule;
import com.rsi.idldt.proeditor.utils.IDLVariableRule;
import com.rsi.idldt.proeditor.utils.PatternFlagRule;
import com.rsi.idldt.proeditor.utils.ProColorProvider;
import com.rsi.idldt.proeditor.utils.ProContinuationCommentRule;
import com.rsi.idldt.proeditor.utils.ProEditorUtilities;
import com.rsi.idldt.proeditor.utils.ProEquationRule;
import com.rsi.idldt.proeditor.utils.ProKeywordRule;
import com.rsi.idldt.proeditor.utils.ProMethodRule;
import com.rsi.idldt.proeditor.utils.ProNumberRule;
import com.rsi.idldt.proeditor.utils.ProReservedWordsRule;
import com.rsi.idldt.proeditor.utils.ProStringRule;
import com.rsi.idldt.proeditor.utils.ProStructFieldRule;
import com.rsi.idldt.proeditor.utils.ProWhiteSpaceDetector;
import com.rsi.idldt.proeditor.utils.ProWordDetector;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProCodeScanner
extends RuleBasedScanner
implements IIDLProcessListener,
IIDLDOMListener {
    public IToken reservedWordToken = new ProToken(null, Messages.ProEditorChroma_Reserved);
    public IToken systemProcedureToken = new ProToken(null, Messages.ProEditorChroma_SysPro);
    public IToken systemFunctionToken = new ProToken(null, Messages.ProEditorChroma_SysFunc);
    public IToken userProcedureToken = new ProToken(null, Messages.ProEditorChroma_UserPro);
    public IToken userFunctionToken = new ProToken(null, Messages.ProEditorChroma_UserFunc);
    public IToken stringToken = new ProToken(null, Messages.ProEditorChroma_String);
    public IToken commentToken = new ProToken(null, Messages.ProEditorChroma_Comment);
    public IToken otherToken = new ProToken(null, Messages.ProEditorChroma_Other);
    public IToken numbersToken = new ProToken(null, Messages.ProEditorChroma_Number);
    public IToken structFieldToken = new ProToken(null, Messages.ProEditorChroma_StructField);
    public IToken structureToken = new ProToken(null, Messages.ProEditorChroma_Other);
    public IToken sysvarToken = new ProToken(null, Messages.ProEditorChroma_Other);
    public IToken keywordToken = new ProToken(null, Messages.ProEditorChroma_Other);
    public IToken idldocToken = new ProToken(null, Messages.ProEditorChroma_Other);
    volatile boolean m_refreshQueued;
    ProColorProvider provider = null;
    List<IRule> m_rules;

    public ProCodeScanner(ProColorProvider p) {
        this.provider = p;
        this.init(false);
    }

    public ProCodeScanner() {
        this.provider = ProEditorServices.getColorProvider();
        this.init(true);
    }

    public List<IRule> GetRulesList() {
        return this.m_rules;
    }

    private void init(boolean addListener) {
        this.updateTokens();
        this.setDefaultReturnToken(this.otherToken);
        this.m_rules = new Vector<IRule>();
        this.m_rules.add((IRule)new EndOfLineRule(";", this.commentToken));
        this.m_rules.add(new ProStringRule(this.stringToken, this.numbersToken));
        PatternFlagRule flagRule = new PatternFlagRule(" $", this.otherToken);
        this.m_rules.add(flagRule);
        this.m_rules.add(new ProContinuationCommentRule(this.commentToken, flagRule));
        this.m_rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new ProWhiteSpaceDetector()));
        this.m_rules.add((IRule)new ProNumberRule(this.numbersToken));
        flagRule = new PatternFlagRule("->", this.otherToken);
        this.m_rules.add(flagRule);
        this.m_rules.add(new ProMethodRule(new ProWordDetector(), this.userProcedureToken, this.userFunctionToken, flagRule));
        flagRule = new PatternFlagRule("*.", this.otherToken);
        this.m_rules.add(flagRule);
        this.m_rules.add(new ProStructFieldRule(new ProWordDetector(), this.structFieldToken, flagRule));
        this.m_rules.add(new ProKeywordRule(this.otherToken));
        this.m_rules.add((IRule)new ProReservedWordsRule(this, new ProWordDetector()));
        this.m_rules.add(new IDLVariableRule(new ProWordDetector(), this.otherToken));
        this.m_rules.add(new ProEquationRule(this.otherToken));
        this.m_rules.add((IRule)new DOMWordRule(new ProWordDetector(), this.systemProcedureToken, this.systemFunctionToken, this.userProcedureToken, this.userFunctionToken, this.otherToken));
        this.setRules();
        if (addListener) {
            IDLProcessManager.addProcessListener((IIDLProcessListener)this);
            this.handleActivatedProcess(IDLProcessManager.getActiveProcess());
        }
    }

    void setRules() {
        IRule[] a = new IRule[this.m_rules.size()];
        this.m_rules.toArray(a);
        this.setRules(a);
    }

    public void updateTokens() {
        ((Token)this.reservedWordToken).setData((Object)new TextAttribute(this.provider.getColor("RESERVED_WORD_COLOR"), this.provider.getBackgroundColor("RESERVED_WORD_COLOR"), this.provider.getStyle("RESERVED_WORD_COLOR")));
        ((Token)this.systemProcedureToken).setData((Object)new TextAttribute(this.provider.getColor("SYSTEM_PROCEDURE_COLOR"), this.provider.getBackgroundColor("SYSTEM_PROCEDURE_COLOR"), this.provider.getStyle("SYSTEM_PROCEDURE_COLOR")));
        ((Token)this.systemFunctionToken).setData((Object)new TextAttribute(this.provider.getColor("SYSTEM_FUNCTION_COLOR"), this.provider.getBackgroundColor("SYSTEM_FUNCTION_COLOR"), this.provider.getStyle("SYSTEM_FUNCTION_COLOR")));
        ((Token)this.userProcedureToken).setData((Object)new TextAttribute(this.provider.getColor("USER_PROCEDURE_COLOR"), this.provider.getBackgroundColor("USER_PROCEDURE_COLOR"), this.provider.getStyle("USER_PROCEDURE_COLOR")));
        ((Token)this.userFunctionToken).setData((Object)new TextAttribute(this.provider.getColor("USER_FUNCTION_COLOR"), this.provider.getBackgroundColor("USER_FUNCTION_COLOR"), this.provider.getStyle("USER_FUNCTION_COLOR")));
        ((Token)this.stringToken).setData((Object)new TextAttribute(this.provider.getColor("STRING_COLOR"), this.provider.getBackgroundColor("STRING_COLOR"), this.provider.getStyle("STRING_COLOR")));
        ((Token)this.commentToken).setData((Object)new TextAttribute(this.provider.getColor("COMMENT_COLOR"), this.provider.getBackgroundColor("COMMENT_COLOR"), this.provider.getStyle("COMMENT_COLOR")));
        ((Token)this.otherToken).setData((Object)new TextAttribute(this.provider.getColor("PLAIN_TEXT_COLOR"), this.provider.getBackgroundColor("PLAIN_TEXT_COLOR"), this.provider.getStyle("PLAIN_TEXT_COLOR")));
        ((Token)this.numbersToken).setData((Object)new TextAttribute(this.provider.getColor("NUMBERS_COLOR"), this.provider.getBackgroundColor("NUMBERS_COLOR"), this.provider.getStyle("NUMBERS_COLOR")));
        ((Token)this.structFieldToken).setData((Object)new TextAttribute(this.provider.getColor("STRUCTURE_FIELD_COLOR"), this.provider.getBackgroundColor("STRUCTURE_FIELD_COLOR"), this.provider.getStyle("STRUCTURE_FIELD_COLOR")));
        ((Token)this.structureToken).setData((Object)new TextAttribute(this.provider.getColor("PLAIN_TEXT_COLOR"), this.provider.getBackgroundColor("PLAIN_TEXT_COLOR"), this.provider.getStyle("PLAIN_TEXT_COLOR")));
        ((Token)this.sysvarToken).setData((Object)new TextAttribute(this.provider.getColor("PLAIN_TEXT_COLOR"), this.provider.getBackgroundColor("PLAIN_TEXT_COLOR"), this.provider.getStyle("PLAIN_TEXT_COLOR")));
        ((Token)this.keywordToken).setData((Object)new TextAttribute(this.provider.getColor("PLAIN_TEXT_COLOR"), this.provider.getBackgroundColor("PLAIN_TEXT_COLOR"), this.provider.getStyle("PLAIN_TEXT_COLOR")));
        ((Token)this.idldocToken).setData((Object)new TextAttribute(this.provider.getColor("PLAIN_TEXT_COLOR"), this.provider.getBackgroundColor("PLAIN_TEXT_COLOR"), this.provider.getStyle("PLAIN_TEXT_COLOR")));
    }

    public void handleActivatedProcess(IIDLProcessProxy idl) {
        IIDLDOMManager DOMManager;
        if (idl != null && (DOMManager = IDLDOMManager.getActiveManager()) != null) {
            DOMManager.addListener((IIDLDOMListener)this);
        }
    }

    public void handleDeletedProcess(IIDLProcessProxy idl) {
    }

    public void handleNewProcess(IIDLProcessProxy idl) {
    }

    public void IDLDOMChanged(IIDLDOMManager DOMManager) {
        DOMWordRule rule = new DOMWordRule(new ProWordDetector(), this.systemProcedureToken, this.systemFunctionToken, this.userProcedureToken, this.userFunctionToken, this.otherToken);
        int n = this.m_rules.size();
        int i = 0;
        while (i < n) {
            if (this.m_rules.get(i) instanceof DOMWordRule) {
                this.m_rules.remove(i);
            }
            ++i;
        }
        this.m_rules.add((IRule)rule);
        if (this.m_refreshQueued) {
            return;
        }
        Display d = PlatformUI.getWorkbench().getDisplay();
        if (d != null && !d.isDisposed()) {
            this.m_refreshQueued = true;
            d.asyncExec(new Runnable(){

                public void run() {
                    ProCodeScanner.this.setRules();
                    ProEditorUtilities.refreshEditors();
                    ProCodeScanner.this.m_refreshQueued = false;
                }
            });
        }
    }
}

