/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor.actions;

import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.proeditor.actions.ProEditorActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ToggleCommentAction
extends ProEditorActionDelegate
implements IViewActionDelegate {
    private ITextOperationTarget opTarget = null;
    private IViewPart m_view;

    public void init(IViewPart view) {
        this.m_view = view;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        super.setActiveEditor(action, targetEditor);
        boolean state = false;
        this.opTarget = null;
        if (this.m_editor != null && this.m_editor.isEditable()) {
            this.opTarget = (ITextOperationTarget)this.m_editor.getAdapter(ITextOperationTarget.class);
            state = this.opTarget != null && this.opTarget.canDoOperation(11) && this.opTarget.canDoOperation(12);
        }
        action.setEnabled(state);
    }

    public ProEditor getActiveEditor(IEditorPart targetEditor) {
        ProEditor editor = null;
        IViewPart activePart = this.m_view;
        if (activePart == null) {
            activePart = targetEditor;
        }
        if (activePart instanceof ProEditor) {
            editor = (ProEditor)activePart;
        }
        if (editor == null && activePart != null) {
            editor = (ProEditor)((Object)activePart.getAdapter(ProEditor.class));
        }
        return editor;
    }

    private boolean isSelectionCommented(int startLine, int endLine) throws BadLocationException {
        IDocument document = this.m_editor.getDocumentProvider().getDocument((Object)this.m_editor.getEditorInput());
        boolean foundComment = false;
        int i = startLine;
        while (i <= endLine) {
            IRegion lineRegion = document.getLineInformation(i);
            String lineText = document.get(lineRegion.getOffset(), lineRegion.getLength());
            String trimmed = lineText.trim();
            if (trimmed.length() > 0) {
                if (trimmed.charAt(0) != ';') {
                    return false;
                }
                foundComment = true;
            }
            ++i;
        }
        return foundComment;
    }

    public void run(IAction action) {
        if (this.opTarget == null) {
            return;
        }
        ISelection selection = this.m_editor.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        ITextSelection textSelect = (ITextSelection)selection;
        int startLine = textSelect.getStartLine();
        int endLine = textSelect.getEndLine();
        if (startLine < 0 || endLine < 0) {
            return;
        }
        try {
            int opCode;
            int n = opCode = this.isSelectionCommented(startLine, endLine) ? 12 : 11;
            if (this.opTarget.canDoOperation(opCode)) {
                this.opTarget.doOperation(opCode);
            }
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }
}

