/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor.actions;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.proeditor.ProTextHover;
import com.rsi.idldt.proeditor.actions.ProEditorActionDelegate;
import com.rsi.idldt.proeditor.pro.ProWordFinder;
import com.rsi.idldt.proeditor.utils.ProEditorUtilities;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class OpenDeclarationAction
extends ProEditorActionDelegate
implements IViewActionDelegate {
    private IViewPart m_view;

    public void init(IViewPart view) {
        this.m_view = view;
    }

    public ProEditor getActiveEditor(IEditorPart targetEditor) {
        ProEditor editor = null;
        IViewPart activePart = this.m_view;
        if (activePart == null) {
            activePart = targetEditor;
        }
        if (activePart instanceof ProEditor) {
            editor = (ProEditor)activePart;
        }
        if (editor == null && activePart != null) {
            editor = (ProEditor)((Object)activePart.getAdapter(ProEditor.class));
        }
        return editor;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        super.setActiveEditor(action, targetEditor);
        if (action != null) {
            action.setEnabled(this.m_editor != null);
        }
    }

    private String getTextOnLine(int line_num, IDocument doc) {
        String line = "";
        try {
            IRegion line_info = doc.getLineInformation(line_num);
            line = doc.get(line_info.getOffset(), line_info.getLength());
        }
        catch (BadLocationException badLocationException) {}
        return line;
    }

    protected String getClassNameFromLine(String theLine) {
        String line = theLine;
        StringBuffer className = new StringBuffer();
        if ((line = line.toLowerCase().trim()).startsWith("pro") || line.startsWith("function")) {
            int index = line.indexOf("::");
            if (--index < 0) {
                index = line.indexOf("__define");
                --index;
            }
            while (index >= 0) {
                char ch = line.charAt(index);
                if (ch == ' ') break;
                className.append(ch);
                --index;
            }
        }
        if (className.length() > 0) {
            className.reverse();
            return className.toString();
        }
        return null;
    }

    protected String getClassNameForOffset(int docOffset, IDocument doc) {
        int line_num = 0;
        String className = null;
        try {
            line_num = doc.getLineOfOffset(docOffset);
        }
        catch (BadLocationException badLocationException) {}
        while (line_num >= 0 && className == null) {
            String line = this.getTextOnLine(line_num, doc);
            className = this.getClassNameFromLine(line);
            --line_num;
        }
        return className;
    }

    public void run(IAction action) {
        if (this.m_editor == null) {
            return;
        }
        IEditorInput editorInput = this.m_editor.getEditorInput();
        IDocument document = this.m_editor.getDocumentProvider().getDocument((Object)editorInput);
        ISelection selection = this.m_editor.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        int offset = ((ITextSelection)selection).getOffset();
        IRegion region = ProTextHover.findTokenRegion(document, offset);
        if ((region == null || region.getLength() == 0) && (region = ProWordFinder.findWord(document, offset - 1, true)) == null) {
            return;
        }
        int length = region.getLength();
        if (length > 0) {
            IDOMNode node;
            String linkTarget;
            try {
                linkTarget = document.get(region.getOffset(), length);
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            if (linkTarget.startsWith("@")) {
                String command = ".EDIT " + linkTarget.substring(1);
                IDLProcessManager.queueSilentExecuteString((String)command);
                return;
            }
            if (linkTarget.toLowerCase().startsWith("self->")) {
                linkTarget = linkTarget.substring(6);
                String className = this.getClassNameForOffset(region.getOffset(), document);
                if (className != null) {
                    linkTarget = "self->" + className + "::" + linkTarget;
                }
            }
            if ((node = ProEditorUtilities.findNodeByName(linkTarget)) != null) {
                ProEditorUtilities.openEditorToNode(node);
                return;
            }
            node = ProEditorUtilities.findNodeByName(String.valueOf(linkTarget) + "__define");
            if (node != null) {
                ProEditorUtilities.openEditorToNode(node);
                return;
            }
            if (!ProEditorUtilities.openEditorToIDLName(linkTarget)) {
                ProEditorUtilities.openEditorToIDLName(String.valueOf(linkTarget) + "__define");
            }
        }
    }
}

