/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor.actions;

import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.IIDLRoutine;
import com.rsi.idldt.core.internal.dom.IDLDOMManager;
import com.rsi.idldt.internal.ui.WorkbenchRunnableAdapter;
import com.rsi.idldt.proeditor.AddIDLDocStubOperation;
import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.proeditor.actions.ProEditorActionDelegate;
import com.rsi.idldt.ui.IDLEditorUtilities;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class AddRoutineCommentsAction
extends ProEditorActionDelegate
implements IViewActionDelegate {
    private IViewPart m_view;

    public void init(IViewPart view) {
        this.m_view = view;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        super.setActiveEditor(action, targetEditor);
        boolean enabled = this.m_editor != null && this.m_editor.isEditable();
        action.setEnabled(enabled);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(IAction action) {
        IDOMNode node;
        IEditorInput editorInput;
        if (this.m_editor == null || (editorInput = this.m_editor.getEditorInput()) == null) return;
        ISelection selection = this.m_editor.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        int offset = ((ITextSelection)selection).getOffset();
        if (this.m_editor.isDirty()) {
            IDocument doc = this.m_editor.getDocumentProvider().getDocument((Object)editorInput);
            IIDLCompilationUnit fake_cu = IDLDOMManager.temporaryParseString((String)doc.get());
            if (fake_cu == null) return;
            IIDLCompilationUnit real_cu = this.getEditorsCompilationUnit(editorInput);
            if (real_cu == null) {
                return;
            }
            fake_cu.setDOMFile(real_cu.getDOMFile());
            node = fake_cu.getElementAt(offset);
        } else {
            node = IDLEditorUtilities.getEditorsNode(editorInput, offset);
        }
        if (node == null || node.getElementType() == 1) return;
        int type = node.getElementType();
        if (type != 5) {
            node = node.getAncestor(5);
        }
        try {
            IIDLRoutine routine = (IIDLRoutine)node;
            AddIDLDocStubOperation op = new AddIDLDocStubOperation((IDOMNode)routine);
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            return;
        }
        catch (InterruptedException interruptedException) {}
    }

    protected Shell getShell() {
        Shell shell = this.m_editor.getSite().getShell();
        return shell;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }

    public ProEditor getActiveEditor(IEditorPart targetEditor) {
        ProEditor editor = null;
        IViewPart activePart = this.m_view;
        if (activePart == null) {
            activePart = targetEditor;
        }
        if (activePart instanceof ProEditor) {
            editor = (ProEditor)activePart;
        }
        if (editor == null && activePart != null) {
            editor = (ProEditor)((Object)activePart.getAdapter(ProEditor.class));
        }
        return editor;
    }

    protected IIDLCompilationUnit getEditorsCompilationUnit(IEditorInput editorInput) {
        IIDLCompilationUnit node = IDLEditorUtilities.getEditorsCompilationUnit(editorInput);
        if (node != null) {
            if (node.getElementType() == 1) {
                return node;
            }
            return (IIDLCompilationUnit)node.getAncestor(1);
        }
        return null;
    }
}

