/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor.actions;

import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.internal.ui.WorkbenchRunnableAdapter;
import com.rsi.idldt.proeditor.AddIDLDocStubOperation;
import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.proeditor.actions.ProEditorActionDelegate;
import com.rsi.idldt.ui.IDLEditorUtilities;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class AddFileCommentsAction
extends ProEditorActionDelegate
implements IViewActionDelegate {
    private IViewPart m_view;

    public void init(IViewPart view) {
        this.m_view = view;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        super.setActiveEditor(action, targetEditor);
        boolean enabled = this.m_editor != null && this.m_editor.isEditable();
        action.setEnabled(enabled);
    }

    public void run(IAction action) {
        IEditorInput editorInput;
        if (this.m_editor != null && (editorInput = this.m_editor.getEditorInput()) != null) {
            IIDLCompilationUnit cu = this.getEditorsCompilationUnit(editorInput);
            if (cu == null) {
                return;
            }
            try {
                AddIDLDocStubOperation op = new AddIDLDocStubOperation((IDOMNode)cu);
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected Shell getShell() {
        Shell shell = this.m_editor.getSite().getShell();
        return shell;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }

    public ProEditor getActiveEditor(IEditorPart targetEditor) {
        ProEditor editor = null;
        IViewPart activePart = this.m_view;
        if (activePart == null) {
            activePart = targetEditor;
        }
        if (activePart instanceof ProEditor) {
            editor = (ProEditor)activePart;
        }
        if (editor == null && activePart != null) {
            editor = (ProEditor)((Object)activePart.getAdapter(ProEditor.class));
        }
        return editor;
    }

    protected IIDLCompilationUnit getEditorsCompilationUnit(IEditorInput editorInput) {
        IIDLCompilationUnit node = IDLEditorUtilities.getEditorsCompilationUnit(editorInput);
        if (node != null) {
            if (node.getElementType() == 1) {
                return node;
            }
            return (IIDLCompilationUnit)node.getAncestor(1);
        }
        return null;
    }
}

