/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor;

import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.IIDLRoutine;
import com.rsi.idldt.core.dom.ISourceCodeRange;
import com.rsi.idldt.ui.UIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ProblemsLabelDecorator
implements ILightweightLabelDecorator {
    private static final String ID_PROBLEM_DECORATOR = "com.rsi.idldt.ui.problemsLabelDecorator";
    private final ImageDescriptor overlay = UIPlugin.getImageDescriptor("icons/error_co.gif");

    public void decorate(Object element, IDecoration decoration) {
        IResource resource = this.getResource(element);
        if (resource != null) {
            try {
                int severity = resource.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2);
                if (severity >= 2) {
                    boolean decorate = true;
                    if (element instanceof IIDLRoutine) {
                        decorate = this.decorateRoutine((IIDLRoutine)element, resource);
                    }
                    if (decorate) {
                        decoration.addOverlay(this.overlay, 2);
                    }
                }
            }
            catch (CoreException coreException) {}
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean decorateRoutine(IIDLRoutine routine, IResource resource) {
        try {
            IMarker[] markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            ISourceCodeRange range = routine.getSourceRange();
            int routineStart = range.getOffset();
            int routineEnd = routineStart + range.getLength();
            int i = 0;
            while (true) {
                if (i >= markers.length) {
                    return false;
                }
                int markStart = markers[i].getAttribute("charStart", -1);
                if (markStart >= routineStart && markStart <= routineEnd) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private IResource getResource(Object object) {
        IIDLCompilationUnit cu;
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IIDLCompilationUnit) {
            return ((IIDLCompilationUnit)object).getResource();
        }
        if (object instanceof IIDLRoutine && (cu = ((IIDLRoutine)object).getCompilationUnit()) != null) {
            return cu.getResource();
        }
        if (object instanceof IAdaptable) {
            return (IResource)((IAdaptable)object).getAdapter(IResource.class);
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public static void update() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        final IDecoratorManager decoratorManager = workbench.getDecoratorManager();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                decoratorManager.update(ProblemsLabelDecorator.ID_PROBLEM_DECORATOR);
            }
        });
    }
}

