/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.debug.internal.model.AbstractIDLBreakpoint;
import com.rsi.idldt.debug.internal.model.IDLBreakpointManager;
import com.rsi.idldt.debug.internal.model.IDLExternalLineBreakpoint;
import com.rsi.idldt.debug.internal.model.IDLLineBreakpoint;
import com.rsi.idldt.debug.model.IIDLBreakpoint;
import com.rsi.idldt.proeditor.utils.ProEditorUtilities;
import com.rsi.idldt.ui.IDLEditorUtilities;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ProToggleBreakpointsTarget
implements IToggleBreakpointsTargetExtension {
    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (part instanceof IEditorPart && selection instanceof ITextSelection) {
            int n = ((ITextSelection)selection).getStartLine();
            IEditorPart editorPart = (IEditorPart)part;
            IEditorInput editorInput = editorPart.getEditorInput();
            IPath path = IDLEditorUtilities.getEditorsAbsolutePath(editorInput);
            String fileName = path.toOSString();
            IBreakpoint[] breakpoints = IDLBreakpointManager.getIDLBreakpoints();
            int i = 0;
            while (i < breakpoints.length) {
                IIDLBreakpoint bp = (IIDLBreakpoint)breakpoints[i];
                if (bp.getLine() == n + 1 && bp.getFilePath().compareToIgnoreCase(fileName) == 0) {
                    return true;
                }
                ++i;
            }
            String s = ProEditorUtilities.getLineAsString((IEditorPart)part, n);
            if (s == null) {
                return false;
            }
            if ((s = s.trim()).length() == 0) {
                return false;
            }
            char c = s.charAt(0);
            return c != ';' && c != '@';
        }
        return false;
    }

    protected ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return (ITextEditor)part.getAdapter(ITextEditor.class);
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor textEditor = this.getTextEditor(part);
        if (textEditor != null) {
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine();
            int offset = textSelection.getOffset();
            IEditorInput input = textEditor.getEditorInput();
            IResource resource = (IResource)input.getAdapter(IResource.class);
            IPath path = null;
            String osFilePath = null;
            if (resource == null) {
                ILocationProvider loc = (ILocationProvider)input.getAdapter(ILocationProvider.class);
                if (loc != null) {
                    path = loc.getPath((Object)input);
                    osFilePath = path.toOSString();
                }
            } else {
                osFilePath = resource.getLocation().toOSString();
            }
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("idl.debugModel");
            int i = 0;
            while (i < breakpoints.length) {
                AbstractIDLBreakpoint breakpoint;
                if (breakpoints[i] instanceof AbstractIDLBreakpoint && (breakpoint = (AbstractIDLBreakpoint)breakpoints[i]).matches(osFilePath, lineNumber + 1)) {
                    breakpoint.delete();
                    return;
                }
                ++i;
            }
            Object lineBreakpoint = resource == null ? new IDLExternalLineBreakpoint(path, lineNumber + 1, offset) : new IDLLineBreakpoint(resource, lineNumber + 1, offset);
            boolean doOnRecompile = false;
            if (textEditor.isDirty()) {
                doOnRecompile = true;
            } else {
                IIDLProcessProxy idl;
                long compileTime;
                IDocumentProvider docProvider = textEditor.getDocumentProvider();
                long modificationTime = docProvider.getModificationStamp((Object)input);
                boolean bl = doOnRecompile = modificationTime > (compileTime = (idl = IDLProcessManager.getActiveProcess()).getCompileTime(osFilePath));
            }
            if (doOnRecompile) {
                lineBreakpoint.setOnRecompile(true);
            }
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)lineBreakpoint);
        }
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (this.canToggleWatchpoints(part, selection)) {
            this.toggleWatchpoints(part, selection);
        } else {
            this.toggleLineBreakpoints(part, selection);
        }
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection) || this.canToggleWatchpoints(part, selection);
    }
}

