/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLDOMManager;
import com.rsi.idldt.core.dom.IIDLRoutine;
import com.rsi.idldt.core.internal.dom.DOMRoutineList;
import com.rsi.idldt.core.internal.dom.IDLDOMManager;
import com.rsi.idldt.core.internal.dom.IDLRoutine;
import com.rsi.idldt.core.utils.Tracer;
import com.rsi.idldt.debug.internal.model.IDLStackFrame;
import com.rsi.idldt.debug.internal.model.IDLValue;
import com.rsi.idldt.debug.internal.model.IDLVariable;
import com.rsi.idldt.internal.ui.IDLBrowserInformationControl;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.proeditor.pro.ProWordFinder;
import com.rsi.idldt.proeditor.utils.ProWordDetector;
import com.rsi.idldt.ui.IDLEditorUtilities;
import com.rsi.jdml.PlatformSupport;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.TreeSet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.keys.IBindingService;
import org.osgi.framework.Bundle;

public class ProTextHover
implements ITextHover,
ITextHoverExtension,
IInformationProviderExtension2 {
    private static int MAX_RECURSE_LEVEL = 10;
    private static int MAX_HOVERHELP_LINE_COUNT = 20;
    private int m_newLineCount = 0;
    private static int WIDTH_RECURSE_LEVEL_INDENTATION = 4;
    private IEditorPart m_editor;
    String m_selStackFrame = "";
    boolean m_bFullHTMLSupport = false;
    private IBindingService m_bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
    private static URL fStyleSheetURL;

    public ProTextHover(IEditorPart editor) {
        this.m_editor = editor;
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (selection == null || selection.isEmpty()) {
                    return;
                }
                String selStackFrame = selection.toString();
                if (selStackFrame.length() == 0) {
                    return;
                }
                int offStart = 0;
                int offEnd = 0;
                try {
                    offStart = selStackFrame.indexOf(91, 1) + 1;
                    offEnd = selStackFrame.indexOf("]]");
                    ProTextHover.this.m_selStackFrame = selStackFrame.substring(offStart, offEnd);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return;
                }
            }
        });
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                ProTextHover.this.checkHTMLAvailability();
                IDLBrowserInformationControl ic = ProTextHover.this.m_bFullHTMLSupport ? new IDLBrowserInformationControl(parent, ProTextHover.this.getHoverAffordanceString()) : new DefaultInformationControl(parent, ProTextHover.this.getHoverAffordanceString(), (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
                return ic;
            }
        };
    }

    String getHoverAffordanceString() {
        if (!EditorsUI.getPreferenceStore().getBoolean("showTextHoverAffordance")) {
            return null;
        }
        String defaultTemplate = Messages.ProTextHover_Template;
        if (this.m_bindingService == null) {
            return defaultTemplate;
        }
        String keySequence = this.m_bindingService.getBestActiveBindingFormattedFor("com.rsi.idldt.ui.commands.Help.HoverHelpAffordance");
        if (keySequence == null) {
            return defaultTemplate;
        }
        return defaultTemplate.replaceAll("F2", keySequence);
    }

    public static IRegion extractTokenRegion(String line, int theOffset) {
        String testString;
        int offset = theOffset;
        if (line.trim().startsWith("@")) {
            int i = 0;
            while (i < line.length()) {
                if (line.charAt(i) == '@') break;
                ++i;
            }
            i = offset = i;
            while (i < line.length()) {
                if (line.charAt(i) == ';') break;
                ++i;
            }
            return new Region(offset, --i - offset + 1);
        }
        int i = offset - 1;
        while (i >= 0) {
            if (!ProWordDetector.isIDLIdentifierCharacter(line.charAt(i)) && ':' != line.charAt(i)) break;
            --offset;
            --i;
        }
        if (offset < 0) {
            offset = 0;
        }
        i = offset;
        while (i < line.length()) {
            char ch = line.charAt(i);
            if (!ProWordDetector.isIDLIdentifierCharacter(ch) && ':' != ch) break;
            ++i;
        }
        String currentToken = line.substring(offset, --i + 1);
        if (currentToken.indexOf("::") == -1 && offset - 6 >= 0 && (testString = line.substring(offset - 6, offset).toLowerCase()).equals("self->")) {
            offset -= 6;
        }
        return new Region(offset, i - offset + 1);
    }

    public static IRegion findTokenRegion(IDocument document, int docOffset) {
        int offset = docOffset;
        try {
            int line_num = document.getLineOfOffset(offset);
            IRegion line_info = document.getLineInformation(line_num);
            String line = document.get(line_info.getOffset(), line_info.getLength());
            int offsetInLine = offset - line_info.getOffset();
            IRegion tokenRegion = ProTextHover.extractTokenRegion(line, offsetInLine);
            int len = tokenRegion.getLength();
            Region urlRegion = new Region(line_info.getOffset() + tokenRegion.getOffset(), len);
            return urlRegion;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private String getEditHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String hoverInfo = "";
        int offset = hoverRegion.getOffset();
        int len = hoverRegion.getLength();
        try {
            IDOMNode node;
            IEditorInput editorInput;
            String token = textViewer.getDocument().get(offset, len);
            String line = ProTextHover.getCurrentLine(textViewer, offset);
            if (this.m_editor != null && (editorInput = this.m_editor.getEditorInput()) != null && (node = IDLEditorUtilities.getEditorsNode(editorInput, offset)) != null) {
                return this.getDomNodeHoverInfo(token, line);
            }
        }
        catch (BadLocationException badLocationException) {}
        return hoverInfo;
    }

    private String getNameOfSelectedFrame() {
        String nameSelFrame = "";
        if (this.m_selStackFrame.length() > 0) {
            return this.m_selStackFrame;
        }
        IDLStackFrame idlStackFrame = IDLProcessManager.getActiveProcess().getDebugTarget().getThread().getTopIDLStackFrame();
        if (idlStackFrame == null) {
            return "";
        }
        nameSelFrame = idlStackFrame.getName();
        return nameSelFrame;
    }

    private boolean isHoverInCurrSelectedStackFrame(int hoverOffset) {
        if (this.m_editor == null) {
            return false;
        }
        IEditorInput editorInput = this.m_editor.getEditorInput();
        if (editorInput == null) {
            return false;
        }
        IDOMNode member = IDLEditorUtilities.getEditorsNode(editorInput, hoverOffset);
        if (member == null) {
            return false;
        }
        if (member.getElementType() == 6) {
            member = member.getParent();
        }
        String DOMMethName = member.getElementName();
        String nameSelFrame = this.getNameOfSelectedFrame();
        return nameSelFrame.length() <= 0 || DOMMethName.length() <= 0 || nameSelFrame.compareToIgnoreCase(DOMMethName) == 0;
    }

    private String getDebugHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String commonName;
        String hoverInfo = "";
        int offset = hoverRegion.getOffset();
        int len = hoverRegion.getLength();
        String token = "";
        boolean bSysVar = false;
        char chPrefix = '\u0000';
        try {
            chPrefix = textViewer.getDocument().getChar(offset - 1);
        }
        catch (BadLocationException badLocationException) {}
        try {
            token = textViewer.getDocument().get(offset, len);
            if (token.length() == 0) {
                return hoverInfo;
            }
        }
        catch (BadLocationException badLocationException) {
            return hoverInfo;
        }
        IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
        if (idl == null) {
            return hoverInfo;
        }
        IDLStackFrame idlStackFrame = null;
        String nameSelFrame = "";
        if (chPrefix == '!') {
            idlStackFrame = idl.getDebugTarget().getThread().getMainIDLStackFrame();
            token = "!" + token;
            bSysVar = true;
        } else {
            nameSelFrame = this.getNameOfSelectedFrame();
            if (nameSelFrame.length() == 0) {
                return hoverInfo;
            }
            idlStackFrame = idl.getDebugTarget().getThread().getIDLStackFrame(nameSelFrame);
        }
        if (idlStackFrame == null) {
            return hoverInfo;
        }
        IDLVariable var = idlStackFrame.getIDLVariable(token);
        if (var == null) {
            try {
                return String.valueOf(Integer.parseInt(token.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                return hoverInfo;
            }
        }
        if (!bSysVar && !this.isHoverInCurrSelectedStackFrame(offset)) {
            return hoverInfo;
        }
        String lhsToken = token.trim();
        if (var.isCommonBlock() && (commonName = var.getCommonBlockName().trim()).length() > 0) {
            lhsToken = String.valueOf(lhsToken) + " (" + commonName + ")";
        }
        String rhsText = this.getVarHoverText(var, 0);
        hoverInfo = "<pre>" + lhsToken + " = " + rhsText + "</pre>";
        return hoverInfo;
    }

    private String getVarHoverText(IDLVariable var, int recurseLevel) {
        if (recurseLevel == MAX_RECURSE_LEVEL) {
            return "...";
        }
        String hoverText = "";
        String tokenVal = "";
        IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
        if (idl == null) {
            return hoverText;
        }
        IDLValue val = (IDLValue)var.getValue();
        if (val == null) {
            return hoverText;
        }
        tokenVal = val.getValueString().trim();
        if (tokenVal.length() == 0) {
            return hoverText;
        }
        tokenVal = tokenVal.replaceAll("<", "&lt;");
        hoverText = tokenVal = tokenVal.replaceAll(">", "&gt;");
        int cSpaces = WIDTH_RECURSE_LEVEL_INDENTATION * (recurseLevel + 1);
        StringBuffer bufIndentation = new StringBuffer(cSpaces);
        int i = 0;
        while (i < cSpaces) {
            bufIndentation.append(" ");
            ++i;
        }
        String indent = bufIndentation.toString();
        if (var.isArray()) {
            hoverText = String.valueOf(hoverText) + "\n";
            IDLValue v = (IDLValue)var.getValue();
            String arrVal = v.getDetailPaneString();
            if (arrVal == null) {
                Tracer.trace((boolean)Tracer.IS_DEBUGGING, (String)"getArrayValue() returned NULL");
            } else {
                arrVal = arrVal.replaceAll("<", "&lt;");
                arrVal = arrVal.replaceAll(">", "&gt;");
                hoverText = String.valueOf(hoverText) + arrVal;
            }
        } else if (var.isStructure() || var.isPointer() || var.isObjref()) {
            IDLVariable[] tags = val.getIDLVariables();
            int i2 = 0;
            while (i2 < tags.length) {
                IDLVariable tag = tags[i2];
                if (tag != null) {
                    String tagName = tag.getName();
                    tagName = tagName.replaceAll("<", "&lt;");
                    tagName = tagName.replaceAll(">", "&gt;");
                    String tagValue = this.getVarHoverText(tag, recurseLevel + 1);
                    String tagElem = "\n";
                    tagElem = var.isStructure() ? String.valueOf(tagElem) + indent + "." + tagName + " = " + tagValue : String.valueOf(tagElem) + indent + "-&gt; " + tagValue;
                    hoverText = String.valueOf(hoverText) + tagElem;
                    ++this.m_newLineCount;
                    if (this.m_newLineCount >= MAX_HOVERHELP_LINE_COUNT) {
                        if (this.m_newLineCount == MAX_HOVERHELP_LINE_COUNT) {
                            hoverText = String.valueOf(hoverText) + "\n" + indent + "...";
                        }
                        return hoverText;
                    }
                }
                ++i2;
            }
        }
        return hoverText;
    }

    @Deprecated
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        this.m_newLineCount = 0;
        this.checkHTMLAvailability();
        String hoverInfo = "";
        if (IDLProcessManager.isDebugging()) {
            hoverInfo = this.getDebugHoverInfo(textViewer, hoverRegion);
            if (hoverInfo == null || hoverInfo.length() == 0) {
                hoverInfo = this.getEditHoverInfo(textViewer, hoverRegion);
            }
        } else {
            hoverInfo = this.getEditHoverInfo(textViewer, hoverRegion);
        }
        if (hoverInfo != null && hoverInfo.length() > 0) {
            StringBuffer buffer = new StringBuffer();
            if (this.m_bFullHTMLSupport) {
                HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (URL)ProTextHover.getStyleSheetURL());
                buffer.append(hoverInfo);
                HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            } else {
                buffer.append(hoverInfo);
            }
            String retStr = buffer.toString();
            return retStr;
        }
        return null;
    }

    public static URL getStyleSheetURL() {
        Bundle bundle;
        if (fStyleSheetURL == null && (fStyleSheetURL = (bundle = Platform.getBundle((String)"com.rsi.idldt.ui")).getEntry("/IDLdocHoverStyleSheet.css")) != null) {
            try {
                fStyleSheetURL = FileLocator.toFileURL((URL)fStyleSheetURL);
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
        }
        return fStyleSheetURL;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return ProWordFinder.findWord(textViewer.getDocument(), offset, true);
    }

    protected HoverRoutine[] filterFoundRoutines(IIDLRoutine[] routines) {
        ArrayList<HoverRoutine> hoverRoutines = new ArrayList<HoverRoutine>();
        int i = 0;
        while (i < routines.length) {
            IIDLRoutine routine = routines[i];
            hoverRoutines.add(new HoverRoutine(routine));
            ++i;
        }
        TreeSet<HoverRoutine> tree = new TreeSet<HoverRoutine>();
        int i2 = 0;
        while (i2 < hoverRoutines.size()) {
            tree.add((HoverRoutine)hoverRoutines.get(i2));
            ++i2;
        }
        HoverRoutine idlLibDirHit = null;
        HoverRoutine idlCatalogHit = null;
        String idlLibDir = DOMRoutineList.getIDLLibDir();
        for (HoverRoutine r : tree) {
            String rname = r.getFilename();
            if (rname == null) {
                idlCatalogHit = r;
                continue;
            }
            if (PlatformSupport.isWindows()) {
                rname = rname.toLowerCase();
            }
            if (!rname.startsWith(idlLibDir)) continue;
            idlLibDirHit = r;
        }
        if (idlCatalogHit != null && idlLibDirHit != null) {
            tree.remove(idlLibDirHit);
        }
        for (HoverRoutine r : tree) {
            r.goGetComments();
        }
        return tree.toArray(new HoverRoutine[tree.size()]);
    }

    protected String getDomNodeHoverInfo(String token, String line) {
        int flags;
        String hoverInfo = "";
        IIDLDOMManager dm = IDLDOMManager.getActiveManager();
        IIDLRoutine[] routines = dm.findRoutines(token, flags = this.setupDOMSearchFlags(token, line));
        HoverRoutine[] filteredRoutines = this.filterFoundRoutines(routines);
        if (filteredRoutines.length == 1) {
            hoverInfo = filteredRoutines[0].getDocString();
        } else if (filteredRoutines.length > 1) {
            hoverInfo = String.valueOf(Messages.ProTextHover_NumberOfMatchesFound) + Integer.toString(filteredRoutines.length);
            int MAX_NUM_MATCHES_TO_SHOW = 5;
            int matches_to_show = MAX_NUM_MATCHES_TO_SHOW < filteredRoutines.length ? MAX_NUM_MATCHES_TO_SHOW : filteredRoutines.length;
            int i = 0;
            while (i < matches_to_show) {
                String matchedFilename = filteredRoutines[i].getFilename();
                if (matchedFilename == null) {
                    matchedFilename = Messages.ProTextHover_System;
                }
                matchedFilename = "  " + matchedFilename;
                hoverInfo = String.valueOf(hoverInfo) + "<br>";
                hoverInfo = String.valueOf(hoverInfo) + "_____________________________________________<br>";
                hoverInfo = String.valueOf(hoverInfo) + "<b>" + Messages.ProTextHover_FileHeader + ' ' + Integer.toString(i + 1) + "</b>" + "<br>";
                hoverInfo = String.valueOf(hoverInfo) + "<pre>" + matchedFilename + "</pre><br>";
                hoverInfo = String.valueOf(hoverInfo) + filteredRoutines[i].getDocString();
                ++i;
            }
            if (filteredRoutines.length > MAX_NUM_MATCHES_TO_SHOW) {
                hoverInfo = String.valueOf(hoverInfo) + "<br>_____________________________________________<br>";
                hoverInfo = String.valueOf(hoverInfo) + "...";
            }
        }
        return hoverInfo;
    }

    private int setupDOMSearchFlags(String token, String line) {
        int idx_double_colon;
        int flags = 114;
        int ioff = line.indexOf(token);
        boolean bjustFunctions = false;
        int i = ioff + token.length();
        while (i < line.length()) {
            char c = line.charAt(i);
            if (c != ' ') {
                if (c != '(') break;
                bjustFunctions = true;
                break;
            }
            ++i;
        }
        if (!bjustFunctions) {
            flags |= 1;
        }
        ioff = line.indexOf(token);
        boolean bClassItems = false;
        int i2 = ioff - 1;
        while (i2 >= 0) {
            char c = line.charAt(i2);
            if (c != ' ') {
                if (c != '>' || i2 - 1 < 0 || line.charAt(i2 - 1) != '-') break;
                bClassItems = true;
                break;
            }
            --i2;
        }
        if ((idx_double_colon = token.indexOf("::")) > -1) {
            bClassItems = true;
        } else if (bClassItems) {
            flags |= 0x400;
        }
        flags = bClassItems ? (flags |= 8) : (flags |= 4);
        return flags;
    }

    private static String getCurrentLine(ITextViewer viewer, int offset) {
        String line;
        IDocument doc = viewer.getDocument();
        try {
            int line_num = doc.getLineOfOffset(offset);
            IRegion line_info = doc.getLineInformation(line_num);
            line = doc.get(line_info.getOffset(), line_info.getLength());
        }
        catch (BadLocationException badLocationException) {
            line = "";
        }
        return line.trim();
    }

    public void checkHTMLAvailability() {
        this.m_bFullHTMLSupport = ProEditor.isFullHTMLSupported();
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                ProTextHover.this.checkHTMLAvailability();
                if (ProTextHover.this.m_bFullHTMLSupport) {
                    return new IDLBrowserInformationControl(parent, null, false);
                }
                return new DefaultInformationControl(parent, true);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HoverRoutine
    implements Comparable<HoverRoutine> {
        IIDLRoutine m_r;
        String m_filename;
        String m_comments;

        public HoverRoutine(IIDLRoutine routine) {
            this.m_r = routine;
            this.m_filename = this.cleanFilename(routine.getFilename());
        }

        @Override
        public int compareTo(HoverRoutine p1) {
            if (this.m_filename == null && p1.m_filename == null) {
                return 0;
            }
            if (this.m_filename == null && p1.m_filename != null) {
                return 1;
            }
            if (this.m_filename != null && p1.m_filename == null) {
                return -1;
            }
            int result = this.m_filename.compareTo(p1.m_filename);
            return result;
        }

        public void goGetComments() {
            this.m_comments = this.m_r.getDocString(ProTextHover.this.m_bFullHTMLSupport);
        }

        public String getDocString() {
            return this.m_comments;
        }

        public boolean hasIDLDoc() {
            IDLRoutine r = (IDLRoutine)this.m_r;
            return r.hasIDLDOC();
        }

        public String getFilename() {
            return this.m_filename;
        }

        protected String cleanFilename(String filename) {
            if (filename == null) {
                return null;
            }
            String clean = filename.trim();
            if (PlatformSupport.isWindows()) {
                clean = filename.replaceAll("/", "\\\\");
                if (clean.charAt(0) == '\\') {
                    clean = clean.substring(1);
                }
                clean = clean.toLowerCase();
            }
            return clean;
        }
    }
}

