/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor;

import com.rsi.idldt.proeditor.ProDocumentTemplateContext;
import com.rsi.idldt.proeditor.ProEditorServices;
import com.rsi.idldt.proeditor.ProTemplateProposal;
import com.rsi.idldt.proeditor.utils.ProWordDetector;
import com.rsi.idldt.ui.UIPlugin;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ProTemplateCompletionProcessor
extends TemplateCompletionProcessor {
    private static final String DEFAULT_IMAGE = "icons/template_obj.gif";
    private String m_prefix;
    private boolean m_bOnlyAcceptingSingleLineTemplates = false;

    public ProTemplateCompletionProcessor(boolean bOnlyAcceptingSingleLineTemplates) {
        this.m_bOnlyAcceptingSingleLineTemplates = bOnlyAcceptingSingleLineTemplates;
    }

    /*
     * Unable to fully structure code
     */
    protected String extractPrefix(ITextViewer viewer, int theOffset) {
        offset = theOffset;
        selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        selectionOffset = selection.getOffset();
        selectionLength = selection.getLength();
        if (selectionOffset == offset) {
            offset = selectionOffset + selectionLength;
        }
        document = viewer.getDocument();
        if (selectionLength > 0) {
            try {
                return document.get(selectionOffset, selectionLength);
            }
            catch (BadLocationException v0) {
                return "";
            }
        }
        i = offset;
        if (i <= document.getLength()) ** GOTO lbl18
        return "";
        {
            while (ProWordDetector.isIDLIdentifierPart(c = document.getChar(i - 1))) {
                --i;
lbl18:
                // 2 sources

                if (i > 0) continue;
            }
            return document.get(i, offset - i);
        }
    }

    protected Template[] getTemplates(String contextID) {
        Template[] templates = ProEditorServices.getTemplateStore().getTemplates();
        ArrayList<Template> matches = new ArrayList<Template>();
        int i = 0;
        while (i < templates.length) {
            Template template = templates[i];
            if (template.getName().regionMatches(true, 0, this.m_prefix, 0, this.m_prefix.length())) {
                matches.add(template);
            }
            ++i;
        }
        return matches.toArray(new Template[matches.size()]);
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return ProEditorServices.getTemplateContextRegistry().getContextType("com.rsi.idldt.ui.proeditor.context");
    }

    protected Image getImage(Template template) {
        ImageRegistry registry = UIPlugin.getDefault().getImageRegistry();
        Image image = registry.get(DEFAULT_IMAGE);
        if (image == null) {
            ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.rsi.idldt.ui", (String)DEFAULT_IMAGE);
            registry.put(DEFAULT_IMAGE, desc);
            image = registry.get(DEFAULT_IMAGE);
        }
        return image;
    }

    public ICompletionProposal[] computeIDLdocCompletionProposals(ITextViewer viewer, int offset, String prefix2) {
        TemplateContextType contextType = ProEditorServices.getTemplateContextRegistry().getContextType("com.rsi.idldt.ui.proeditor.idldoc_context");
        IRegion region = this.getRegion(viewer, offset, prefix2);
        IDocument document = viewer.getDocument();
        ProDocumentTemplateContext context = new ProDocumentTemplateContext(contextType, document, region.getOffset(), region.getLength());
        return this.computeCompletionProposalsForContext((TemplateContext)context, viewer, offset, prefix2);
    }

    public ICompletionProposal[] computeProCodeCompletionProposals(ITextViewer viewer, int offset, String prefix2) {
        TemplateContextType contextType = ProEditorServices.getTemplateContextRegistry().getContextType("com.rsi.idldt.ui.proeditor.context");
        IRegion region = this.getRegion(viewer, offset, prefix2);
        IDocument document = viewer.getDocument();
        ProDocumentTemplateContext context = new ProDocumentTemplateContext(contextType, document, region.getOffset(), region.getLength());
        return this.computeCompletionProposalsForContext((TemplateContext)context, viewer, offset, prefix2);
    }

    protected IRegion getRegion(ITextViewer viewer, int theOffset, String prefix2) {
        int offset = theOffset;
        this.m_prefix = prefix2.toUpperCase();
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        String prefix = this.extractPrefix(viewer, offset);
        Region region = new Region(offset - prefix.length(), prefix.length());
        return region;
    }

    protected ICompletionProposal[] computeCompletionProposalsForContext(TemplateContext context, ITextViewer viewer, int theOffset, String prefix2) {
        int offset = theOffset;
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        IRegion region = this.getRegion(viewer, offset, prefix2);
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        String prefix = this.extractPrefix(viewer, offset);
        String sel = selection.getText();
        if (sel != null && sel.length() > 0) {
            context.setVariable("selection", sel);
        }
        Template[] templates = this.getTemplates(context.getContextType().getId());
        ArrayList<ICompletionProposal> matches = new ArrayList<ICompletionProposal>();
        int i = 0;
        while (i < templates.length) {
            block7: {
                Template template = templates[i];
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    break block7;
                }
                if (template.matches(prefix, context.getContextType().getId())) {
                    String pattern = template.getPattern();
                    if (!this.m_bOnlyAcceptingSingleLineTemplates || pattern.indexOf(10) < 0) {
                        matches.add(this.createProposal(template, context, region, this.getRelevance(template, prefix)));
                    }
                }
            }
            ++i;
        }
        this.m_prefix = "";
        return matches.toArray(new ICompletionProposal[matches.size()]);
    }

    protected int getRelevance(Template template, String prefix) {
        if (template.getName().regionMatches(true, 0, prefix, 0, prefix.length())) {
            return 90;
        }
        return 0;
    }

    protected TemplateContext createContext(ITextViewer viewer, IRegion region) {
        TemplateContextType contextType = this.getContextType(viewer, region);
        if (contextType != null) {
            IDocument document = viewer.getDocument();
            return new ProDocumentTemplateContext(contextType, document, region.getOffset(), region.getLength());
        }
        return null;
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        return new ProTemplateProposal(template, context, region, this.getImage(template), relevance);
    }
}

