/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor;

import com.rsi.idldt.internal.ui.IDLBrowserInformationControl;
import com.rsi.idldt.proeditor.IDLElementHyperlinkDetector;
import com.rsi.idldt.proeditor.ProDocAutoIndentStrategy;
import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.proeditor.ProEditorServices;
import com.rsi.idldt.proeditor.ProTextHover;
import com.rsi.idldt.proeditor.pro.ProCodeScanner;
import com.rsi.idldt.proeditor.pro.ProCompletionProcessor;
import com.rsi.idldt.proeditor.pro.ProDoubleClickStrategy;
import com.rsi.idldt.proeditor.pro.ProWordFormattingStrategy;
import com.rsi.idldt.ui.UIPlugin;
import com.rsi.idldt.ui.UIPreferenceManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.URLHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class ProEditorSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private final String m_documentPartitioner;
    private ProEditor m_editor;
    private boolean m_bContentAssistAutoInsert = true;
    private ContentAssistant m_contentAssistant = null;

    public ProEditorSourceViewerConfiguration(ProEditor editor) {
        super(editor.getPrefStore());
        this.m_documentPartitioner = null;
        this.m_editor = editor;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setRestoreCompletionProposalSize(this.getSettings("completion_proposal_size"));
        ProCompletionProcessor processor = new ProCompletionProcessor();
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "pro_code");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(21);
        assistant.setContextInformationPopupOrientation(21);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.enableAutoInsert(this.m_bContentAssistAutoInsert);
        this.m_contentAssistant = assistant;
        return assistant;
    }

    private IDialogSettings getSettings(String sectionName) {
        IDialogSettings settings = UIPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = UIPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    public void enableContentAssistAutoInsert(boolean value) {
        this.m_bContentAssistAutoInsert = value;
        if (this.m_contentAssistant != null) {
            this.m_contentAssistant.enableAutoInsert(value);
        }
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                if (ProEditor.isFullHTMLSupported()) {
                    return new IDLBrowserInformationControl(parent, "org.eclipse.jface.dialogfont", false);
                }
                return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter());
            }
        };
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new ProDoubleClickStrategy();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        ProCodeScanner scanner = ProEditorServices.getProCodeScanner();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)dr, "pro_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "pro_comment");
        return reconciler;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter formatter = new ContentFormatter();
        ProWordFormattingStrategy keyword = new ProWordFormattingStrategy();
        formatter.setFormattingStrategy((IFormattingStrategy)keyword, "__dftl_partition_content_type");
        return formatter;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        if (this.m_documentPartitioner != null) {
            return this.m_documentPartitioner;
        }
        return super.getConfiguredDocumentPartitioning(sourceViewer);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new ProTextHover((IEditorPart)this.m_editor);
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{";", ""};
    }

    public IEditorPart getEditor() {
        return this.m_editor;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        if (this.m_editor == null) {
            return super.getTabWidth(sourceViewer);
        }
        return UIPreferenceManager.getPreferenceStore().getInt("IDLDT_TAB_WIDTH");
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        String[] indentPrefixes = this.getIndentPrefixesForTab(this.getTabWidth(sourceViewer));
        if (indentPrefixes == null) {
            return null;
        }
        int length = indentPrefixes.length;
        if (length > 2 && UIPreferenceManager.getPreferenceStore().getBoolean("IDLDT_SPACES_FOR_TABS")) {
            String first = indentPrefixes[0];
            indentPrefixes[0] = indentPrefixes[length - 2];
            indentPrefixes[length - 2] = first;
        }
        return indentPrefixes;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] result = new IHyperlinkDetector[]{new URLHyperlinkDetector(), new IDLElementHyperlinkDetector()};
        return result;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new ProDocAutoIndentStrategy()};
    }
}

