/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor;

import com.rsi.idldt.proeditor.ProContextType;
import com.rsi.idldt.proeditor.ProIDLdocContextType;
import com.rsi.idldt.proeditor.pro.ProCodeScanner;
import com.rsi.idldt.proeditor.pro.ProPartitionScanner;
import com.rsi.idldt.proeditor.utils.ProColorProvider;
import com.rsi.idldt.ui.UIPreferenceManager;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

public class ProEditorServices {
    public static final ProEditorServices INSTANCE = new ProEditorServices();
    private static final String PRO_EDITOR_RESOURCES = "com.rsi.idldt.proeditor.ProEditorPluginResources";
    private static final String TEMPLATES_KEY = "com.rsi.idldt.core.ui.proeditor.templates";
    private TemplateStore m_templateStore;
    private ContributionContextTypeRegistry m_contextRegistry;
    private ResourceBundle m_resourceBundle;
    private ProCodeScanner m_proCodeScanner;
    private ProColorProvider m_colorProvider;
    private ProPartitionScanner m_partitionScanner;
    public static final String PRO_PARTITIONING = "__pro_partitioning";

    private ProEditorServices() {
        try {
            this.m_resourceBundle = ResourceBundle.getBundle(PRO_EDITOR_RESOURCES);
        }
        catch (MissingResourceException missingResourceException) {
            this.m_resourceBundle = null;
        }
    }

    private static void verifyInit() {
        if (ProEditorServices.INSTANCE.m_contextRegistry == null) {
            ProEditorServices.INSTANCE.m_contextRegistry = new ContributionContextTypeRegistry();
            ProEditorServices.INSTANCE.m_contextRegistry.addContextType((TemplateContextType)new ProContextType());
            ProEditorServices.INSTANCE.m_contextRegistry.addContextType((TemplateContextType)new ProIDLdocContextType());
        }
        if (ProEditorServices.INSTANCE.m_templateStore == null) {
            ProEditorServices.INSTANCE.m_templateStore = new ContributionTemplateStore((ContextTypeRegistry)ProEditorServices.INSTANCE.m_contextRegistry, UIPreferenceManager.getPreferenceStore(), TEMPLATES_KEY);
            try {
                ProEditorServices.INSTANCE.m_templateStore.load();
            }
            catch (IOException iOException) {}
        }
        if (ProEditorServices.INSTANCE.m_partitionScanner == null) {
            ProEditorServices.INSTANCE.m_partitionScanner = new ProPartitionScanner();
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        try {
            ProEditorServices.verifyInit();
            return ProEditorServices.INSTANCE.m_resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static ResourceBundle getResourceBundle() {
        ProEditorServices.verifyInit();
        return ProEditorServices.INSTANCE.m_resourceBundle;
    }

    public static ProColorProvider getColorProvider() {
        if (ProEditorServices.INSTANCE.m_colorProvider == null) {
            ProEditorServices.INSTANCE.m_colorProvider = new ProColorProvider();
        }
        return ProEditorServices.INSTANCE.m_colorProvider;
    }

    public static ProCodeScanner getProCodeScanner() {
        if (ProEditorServices.INSTANCE.m_proCodeScanner == null) {
            ProEditorServices.INSTANCE.m_proCodeScanner = new ProCodeScanner();
        }
        return ProEditorServices.INSTANCE.m_proCodeScanner;
    }

    public static ProPartitionScanner getProPartitionScanner() {
        ProEditorServices.verifyInit();
        return ProEditorServices.INSTANCE.m_partitionScanner;
    }

    public static TemplateStore getTemplateStore() {
        ProEditorServices.verifyInit();
        return ProEditorServices.INSTANCE.m_templateStore;
    }

    public static ContextTypeRegistry getTemplateContextRegistry() {
        ProEditorServices.verifyInit();
        return ProEditorServices.INSTANCE.m_contextRegistry;
    }
}

