/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor;

import com.rsi.idldt.actions.OpenLocalFileAction;
import com.rsi.idldt.core.IDLDTCorePlugin;
import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IDLProjectNature;
import com.rsi.idldt.core.IIDLProcessListener;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.IIDLDOMManager;
import com.rsi.idldt.core.dom.IIDLRoutine;
import com.rsi.idldt.core.dom.ISourceCodeRange;
import com.rsi.idldt.core.internal.dom.IDLDOMManager;
import com.rsi.idldt.debug.internal.model.IDLDebugTarget;
import com.rsi.idldt.debug.internal.model.IDLExternalLineBreakpoint;
import com.rsi.idldt.debug.internal.model.IDLLineBreakpoint;
import com.rsi.idldt.debug.internal.model.IDLStackFrame;
import com.rsi.idldt.debug.internal.model.IDLThread;
import com.rsi.idldt.internal.ui.IDLBrowserInformationControl;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.internal.ui.NonExistentProEditorInput;
import com.rsi.idldt.internal.ui.views.CommandLineView;
import com.rsi.idldt.internal.ui.views.IDLOutlinePage;
import com.rsi.idldt.proeditor.ProEditorServices;
import com.rsi.idldt.proeditor.ProEditorSourceViewerConfiguration;
import com.rsi.idldt.proeditor.ProFileDocumentProvider;
import com.rsi.idldt.proeditor.ProToggleBreakpointsTarget;
import com.rsi.idldt.proeditor.ProblemsLabelDecorator;
import com.rsi.idldt.proeditor.actions.IndentAction;
import com.rsi.idldt.proeditor.pro.ProWordFinder;
import com.rsi.idldt.proeditor.utils.ProEditorUtilities;
import com.rsi.idldt.proeditor.utils.ProPairMatcher;
import com.rsi.idldt.ui.IDLEditorUtilities;
import com.rsi.idldt.ui.IDLHelpUtilities;
import com.rsi.idldt.ui.IDLProductizer;
import com.rsi.idldt.ui.IDLViewUtilities;
import com.rsi.idldt.ui.UIPlugin;
import com.rsi.idldt.ui.UIPreferenceManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.RunToLineHandler;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITextViewerExtension8;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.CaseAction;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProEditor
extends AbstractDecoratedTextEditor
implements IDocumentListener,
IPropertyChangeListener,
IRunToLineTarget,
IIDLProcessListener {
    public static final String GROUP_NAME_FOLDING = "Folding";
    private ProjectionSupport m_projectionSupport;
    private ProjectionAnnotationModel m_annotationModel;
    private IDLOutlinePage m_outlinePage;
    private ProPairMatcher m_matcher;
    private static ProToggleBreakpointsTarget g_toggleBreakpointService;
    private ProEditorSourceViewerConfiguration m_SourceViewerConfiguration;
    ISourceViewer m_viewer;
    protected InformationPresenter fInformationPresenter;
    protected boolean m_getFoldingPositionsFromDOM_ranOnce = false;
    IMenuManager m_menuManager;
    private boolean m_bAddedToDOM = false;
    private static boolean m_bFullHTMLSupport;
    private static boolean m_bCheckedHTMLAvailability;
    private String m_changeWorkingDirCmd;
    Annotation[] m_OccurrenceAnnotations = null;
    private OccurrencesFinderJob m_OccurrencesFinderJob;
    private static final char[] BRACKETS;
    public static final String EDITOR_MATCHING_BRACKETS = "matchingBrackets";
    public static final String EDITOR_MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    public static final String IDL_TODO_TASK_MARKER = "com.rsi.idldt.ui.marker.IDLTodoTaskMarker";

    static {
        m_bFullHTMLSupport = false;
        m_bCheckedHTMLAvailability = false;
        BRACKETS = new char[]{'(', ')', '[', ']', '{', '}'};
    }

    public IPreferenceStore getPrefStore() {
        return this.getPreferenceStore();
    }

    public ProEditor() {
        g_toggleBreakpointService = new ProToggleBreakpointsTarget();
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.m_SourceViewerConfiguration = new ProEditorSourceViewerConfiguration(this);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.m_SourceViewerConfiguration);
    }

    public void refresh() {
        if (this.getViewer() == null || this.getViewer().getDocument() == null) {
            return;
        }
        this.m_viewer.invalidateTextPresentation();
        this.updateTodoMarkers();
        if (!this.m_getFoldingPositionsFromDOM_ranOnce) {
            this.updateFoldingStructure();
        }
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = ProEditorServices.getResourceBundle();
        Object a = new TextOperationAction(bundle, "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        a = new DefineFoldingRegionAction(bundle, "DefineFoldingRegion.", (ITextEditor)this);
        this.setAction("DefineFoldingRegion", (IAction)a);
        IndentAction action = new IndentAction(bundle, "Editor.ShiftRight.", (ITextEditor)this);
        this.setAction("IndentOnTab", (IAction)action);
        this.markAsStateDependentAction("IndentOnTab", true);
        this.markAsSelectionDependentAction("IndentOnTab", true);
        this.setActionActivationCode("IndentOnTab", '\t', -1, 0);
        a = new CaseAction(bundle, "ToUppercase.", (AbstractTextEditor)this, true);
        this.setAction("ToUppercase", (IAction)a);
        a = new CaseAction(bundle, "ToLowercase.", (AbstractTextEditor)this, false);
        this.setAction("ToLowercase", (IAction)a);
        a = new EnableDisableFoldingAction(bundle, "EnableDisableFoldingAction.", (ITextEditor)this);
        this.setAction("EnableDisableFoldingAction", (IAction)a);
        a = new CollapseAllFoldingAction(bundle, "CollapseAllFoldingAction.", (ITextEditor)this);
        this.setAction("CollapseAllFoldingAction", (IAction)a);
        a = new ExpandAllFoldingAction(bundle, "ExpandAllFoldingAction.", (ITextEditor)this);
        this.setAction("ExpandAllFoldingAction", (IAction)a);
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] pages = super.collectContextMenuPreferencePages();
        String[] mypages = new String[]{"com.rsi.idldt.ui.preferencePage.editor", "com.rsi.idldt.ui.preferencePage.syntaxcolor", "com.rsi.idldt.ui.preferencePage.templates"};
        String[] allpages = new String[pages.length + mypages.length];
        int i = 0;
        while (i < pages.length) {
            allpages[i] = pages[i];
            ++i;
        }
        i = 0;
        while (i < mypages.length) {
            allpages[i + pages.length] = pages[i];
            ++i;
        }
        return allpages;
    }

    private void removeShowInMenuItem(IMenuManager mm) {
        IContributionItem[] children = mm.getItems();
        int i = 0;
        while (i < children.length) {
            String itemId = children[i].getId();
            if (children[i] instanceof IMenuManager) {
                IContributionItem[] kids;
                String sId;
                IMenuManager menu = (IMenuManager)children[i];
                if (itemId == null && (sId = (kids = menu.getItems())[0].getId()).equalsIgnoreCase("viewsShowIn")) {
                    mm.remove(children[i]);
                }
            }
            ++i;
        }
        mm.update();
    }

    void removeUnwantedMenuItems(IMenuManager mm) {
        IContributionItem ci = IDLProductizer.find((IContributionItem)mm, "org.eclipse.debug.ui.contextualLaunch.debug.submenu");
        if (ci != null) {
            mm.remove(ci);
            mm.update(true);
        }
        if ((ci = IDLProductizer.find((IContributionItem)mm, "org.eclipse.debug.ui.contextualLaunch.run.submenu")) != null) {
            mm.remove(ci);
            mm.update(true);
        }
    }

    protected boolean isEditorInputIncludedInContextMenu() {
        return true;
    }

    private void addContextMenuListener() {
        Menu m;
        if (!IDLDTCorePlugin.isIDLWorkbenchProduct()) {
            return;
        }
        Control c = (Control)this.getAdapter(Control.class);
        Menu menu = m = c != null ? c.getMenu() : null;
        if (m != null) {
            m.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    ProEditor.this.removeUnwantedMenuItems(ProEditor.this.m_menuManager);
                }

                public void menuHidden(MenuEvent e) {
                }
            });
        }
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        this.addAction(menu, "ToUppercase");
        this.addAction(menu, "ToLowercase");
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "additions", "ContentAssistProposal");
        this.removeShowInMenuItem(menu);
        this.m_menuManager = menu;
    }

    public void rulerContextMenuAboutToShow(IMenuManager menu) {
        MenuManager subMenu = new MenuManager(Messages.ProEditor_CodeFoldingMenuItem, GROUP_NAME_FOLDING);
        this.addAction((IMenuManager)subMenu, "EnableDisableFoldingAction");
        this.addAction((IMenuManager)subMenu, "CollapseAllFoldingAction");
        this.addAction((IMenuManager)subMenu, "ExpandAllFoldingAction");
        menu.add((IContributionItem)subMenu);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        if (viewer.isProjectionMode()) {
            IAction a = this.getAction("EnableDisableFoldingAction");
            a.setChecked(true);
            a = this.getAction("CollapseAllFoldingAction");
            a.setEnabled(true);
            a = this.getAction("ExpandAllFoldingAction");
            a.setEnabled(true);
        } else {
            IAction a = this.getAction("EnableDisableFoldingAction");
            a.setChecked(false);
            a = this.getAction("CollapseAllFoldingAction");
            a.setEnabled(false);
            a = this.getAction("ExpandAllFoldingAction");
            a.setEnabled(false);
        }
        super.rulerContextMenuAboutToShow(menu);
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        if (this.m_matcher == null) {
            this.m_matcher = new ProPairMatcher(BRACKETS);
        }
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.m_matcher);
        support.setMatchingCharacterPainterPreferenceKeys(EDITOR_MATCHING_BRACKETS, EDITOR_MATCHING_BRACKETS_COLOR);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        this.m_viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport(this.m_viewer);
        return this.m_viewer;
    }

    public void setCodeFolding(boolean bFolding) {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        if (bFolding && viewer.isProjectionMode()) {
            return;
        }
        if (!bFolding && !viewer.isProjectionMode()) {
            return;
        }
        this.toggleCodeFolding();
    }

    public void toggleCodeFolding() {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        viewer.doOperation(19);
        IPreferenceStore store = UIPreferenceManager.getPreferenceStore();
        if (viewer.isProjectionMode()) {
            this.updateFoldingStructure();
            store.setValue("IDLDT_ENABLE_CODE_FOLDING", true);
        } else {
            store.setValue("IDLDT_ENABLE_CODE_FOLDING", false);
        }
    }

    public void foldingExpandAll() {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        if (viewer.isProjectionMode()) {
            viewer.doOperation(20);
        }
    }

    public void foldingCollapseAll() {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        if (viewer.isProjectionMode()) {
            viewer.doOperation(21);
        }
    }

    public void checkHTMLAvailability() {
        if (!m_bCheckedHTMLAvailability) {
            Shell shell = this.getSite().getShell();
            m_bFullHTMLSupport = IDLBrowserInformationControl.isAvailable((Composite)shell);
        }
        m_bCheckedHTMLAvailability = true;
    }

    public static boolean isFullHTMLSupported() {
        return m_bFullHTMLSupport;
    }

    public void createPartControl(Composite parent) {
        boolean enableCodeFolding;
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        viewer.setHoverEnrichMode(ITextViewerExtension8.EnrichMode.IMMEDIATELY);
        this.checkHTMLAvailability();
        StyledText styledText = viewer.getTextWidget();
        styledText.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                ProEditor.this.showHelp();
            }
        });
        styledText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                UIPlugin.getContextManager().activateContext("com.rsi.idldt.ui.proEditorContext", true);
            }

            public void focusLost(FocusEvent e) {
                UIPlugin.getContextManager().activateContext("com.rsi.idldt.ui.proEditorContext", false);
            }
        });
        this.addContextMenuListener();
        this.m_projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.m_projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.m_projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.m_projectionSupport.install();
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model != null) {
            model.connect(document);
        }
        if (enableCodeFolding = UIPreferenceManager.getPreferenceStore().getBoolean("IDLDT_ENABLE_CODE_FOLDING")) {
            this.setCodeFolding(true);
        }
        this.installHighlighter();
    }

    public void showHelp() {
        IEditorInput editorInput = this.getEditorInput();
        IDocument document = this.getDocumentProvider().getDocument((Object)editorInput);
        ISelection selection = this.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        int offset = ((ITextSelection)selection).getOffset();
        IRegion region = ProWordFinder.findWord(document, offset, true);
        if (region == null) {
            return;
        }
        int length = region.getLength();
        if (length <= 0) {
            return;
        }
        try {
            String name = document.get(region.getOffset(), length);
            IDLHelpUtilities.helpTopic(name);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    protected void adjustHighlightRange(int offset, int length) {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            extension.exposeModelRange((IRegion)new Region(offset, length));
        }
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.m_outlinePage == null) {
                this.m_outlinePage = new IDLOutlinePage(this.getDocumentProvider(), this);
                this.m_outlinePage.setInput(this.getEditorInput());
                ISourceViewer viewer = this.getSourceViewer();
                if (viewer instanceof IPostSelectionProvider) {
                    ((IPostSelectionProvider)viewer).addPostSelectionChangedListener((ISelectionChangedListener)this.m_outlinePage);
                }
            }
            return this.m_outlinePage;
        }
        if (IFindReplaceTarget.class.equals((Object)required)) {
            if (this.m_outlinePage != null && this.m_outlinePage.getInput() != this.getEditorInput()) {
                this.m_outlinePage.setInput(this.getEditorInput());
            }
        } else {
            Object adapter;
            if (IToggleBreakpointsTarget.class.equals((Object)required)) {
                return g_toggleBreakpointService;
            }
            if (IRunToLineTarget.class.equals((Object)required)) {
                return this;
            }
            if (IContextProvider.class.equals((Object)required)) {
                return null;
            }
            if (this.m_projectionSupport != null && (adapter = this.m_projectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
                return adapter;
            }
        }
        return super.getAdapter(required);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setDocumentProvider((IDocumentProvider)new ProFileDocumentProvider());
        this.setEditorContextMenuId("#ProEditorContext");
        this.setRulerContextMenuId("#ProEditorRulerContext");
        super.init(site, input);
        this.updateTodoMarkers();
        if (!this.isUntitledProFile()) {
            IPath path = IDLEditorUtilities.getEditorsAbsolutePath(input);
            if (!IDLEditorUtilities.doesFileExist(input)) {
                throw new PartInitException(Messages.bind(Messages.FileDoesNotExist, IDLEditorUtilities.getPathAsString(path)));
            }
            IPreferenceStore iStore = UIPreferenceManager.getPreferenceStore();
            if (iStore.getBoolean("IDLDT_EDIT_CWD")) {
                String dir = path.removeLastSegments(1).toOSString();
                dir = dir.replaceAll("'", "''");
                String cmd = "cd, '" + dir + "'";
                IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
                if (idl != null) {
                    idl.queueSilentExecuteString(cmd);
                } else {
                    this.m_changeWorkingDirCmd = cmd;
                    IDLProcessManager.addProcessListener((IIDLProcessListener)this);
                }
                OpenLocalFileAction.setFilterPath(dir);
            }
        }
        UIPreferenceManager.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        IIDLDOMManager domManager;
        Object f = IDLEditorUtilities.getEditorsFile(this.getEditorInput());
        if (f != null && (domManager = IDLDOMManager.getActiveManager()) != null) {
            domManager.removeEditor(f);
        }
        UIPreferenceManager.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isUntitledProFile() {
        return this.getEditorInput() instanceof NonExistentProEditorInput;
    }

    public void ensureSaved() {
        if (this.isUntitledProFile()) {
            this.doSaveAs();
        } else if (this.isDirty()) {
            this.doSave(this.getProgressMonitor());
        }
    }

    private String getTaskMessage(IDocument document, int[] location) {
        int charStart;
        int charEnd = charStart = location[0];
        String message = null;
        try {
            char c;
            int line = document.getLineOfOffset(charStart);
            IRegion region = document.getLineInformation(line);
            charEnd = region.getOffset() + region.getLength();
            while ((c = document.getChar(charStart)) == ' ' || c == '\t' || c == ';') {
                ++charStart;
            }
            while ((c = document.getChar(charEnd - 1)) == ' ' || c == '\t') {
                --charEnd;
            }
            location[0] = charStart;
            location[1] = line + 1;
            message = document.get(charStart, charEnd - charStart);
        }
        catch (BadLocationException badLocationException) {}
        return message;
    }

    private int findDuplicateTask(IMarker[] markers, int line, String message) {
        if (markers == null) {
            return -1;
        }
        int nOld = markers.length;
        int i = 0;
        while (i < nOld) {
            String markerMessage;
            int markerLine;
            if (markers[i] != null && (markerLine = markers[i].getAttribute("lineNumber", 0)) == line && message.equals(markerMessage = markers[i].getAttribute("message", ""))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void createMarker(IFile file, String message, int priority, int line, int charStart, int charEnd) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(6);
        attributes.put("message", message);
        attributes.put("priority", new Integer(priority));
        attributes.put("userEditable", new Boolean(false));
        attributes.put("lineNumber", new Integer(line));
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
        try {
            IMarker marker = file.createMarker(IDL_TODO_TASK_MARKER);
            marker.setAttributes(attributes);
        }
        catch (CoreException coreException) {}
    }

    private void updateTodoMarkers() {
        IEditorInput input = this.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return;
        }
        IFile file = ((IFileEditorInput)input).getFile();
        if (file == null) {
            return;
        }
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        IDocument document = provider.getDocument((Object)input);
        if (document == null) {
            return;
        }
        document.addDocumentListener((IDocumentListener)this);
        IMarker[] oldMarkers = null;
        try {
            oldMarkers = file.findMarkers(IDL_TODO_TASK_MARKER, true, 2);
        }
        catch (CoreException coreException) {}
        FindReplaceDocumentAdapter findAdapter = new FindReplaceDocumentAdapter(document);
        boolean needRefresh = false;
        String taskTag = null;
        int priority = 0;
        IPreferenceStore ps = UIPreferenceManager.getPreferenceStore();
        int tag = 0;
        while (tag <= 2) {
            switch (tag) {
                case 0: {
                    taskTag = ps.getString("IDLDT_TASK_TAG_LOW");
                    priority = 0;
                    break;
                }
                case 1: {
                    taskTag = ps.getString("IDLDT_TASK_TAG_NORMAL");
                    priority = 1;
                    break;
                }
                case 2: {
                    taskTag = ps.getString("IDLDT_TASK_TAG_HIGH");
                    priority = 2;
                }
            }
            if (taskTag != null && taskTag.length() != 0) {
                int start = 0;
                String regex = ";[ \t]*" + taskTag + "\\W";
                while (true) {
                    int[] location;
                    String message;
                    IRegion region;
                    try {
                        region = findAdapter.find(start, regex, true, false, false, true);
                    }
                    catch (BadLocationException badLocationException) {
                        break;
                    }
                    if (region == null || (message = this.getTaskMessage(document, location = new int[]{region.getOffset(), -1})) == null) break;
                    int charStart = location[0];
                    int line = location[1];
                    int charEnd = charStart + message.length();
                    int duplicate = this.findDuplicateTask(oldMarkers, line, message);
                    if (duplicate >= 0 && oldMarkers != null) {
                        oldMarkers[duplicate] = null;
                    } else {
                        this.createMarker(file, message, priority, line, charStart, charEnd);
                        needRefresh = true;
                    }
                    start = charEnd;
                }
            }
            ++tag;
        }
        if (oldMarkers != null) {
            int i = 0;
            while (i < oldMarkers.length) {
                if (oldMarkers[i] != null) {
                    needRefresh = true;
                    try {
                        oldMarkers[i].delete();
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
        if (needRefresh) {
            IDLViewUtilities.highlightView("org.eclipse.ui.views.TaskList", false);
        }
    }

    public void editorSaved() {
        super.editorSaved();
        this.updateTodoMarkers();
        boolean compileOnSave = UIPreferenceManager.getPreferenceStore().getBoolean("IDLDT_COMPILE_ON_SAVE");
        if (compileOnSave) {
            this.compileSavedFile();
        }
        IIDLDOMManager domManager = IDLDOMManager.getActiveManager();
        Object f = IDLEditorUtilities.getEditorsFile(this.getEditorInput());
        if (domManager != null && f instanceof File) {
            domManager.parseCompilationUnitNow((File)f);
        }
        this.updateFoldingStructure();
    }

    protected void compileSavedFile() {
        IEditorInput editorInput = this.getEditorInput();
        IPath path = IDLEditorUtilities.getEditorsAbsolutePath(editorInput);
        if (path != null && path.toFile().canRead()) {
            String command = ".COMPILE '" + path.toOSString() + "'";
            IDLProcessManager.getActiveProcess().queueSilentExecuteString(command);
        }
    }

    private IEditorInput getWorkspaceSaveAsInput(IProgressMonitor progressMonitor) {
        Shell shell = this.getSite().getShell();
        IEditorInput input = this.getEditorInput();
        String defaultName = this.generateAutoPopulateName(input);
        IDocumentProvider provider = this.getDocumentProvider();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        IProject project = null;
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            if (file != null) {
                project = file.getProject();
            }
        } else {
            project = this.determineSaveAsDefaultProject();
        }
        IFile defaultFileHandle = this.determineSaveAsDefaultFile(project, defaultName);
        if (project == null) {
            MessageDialog.openError((Shell)shell, (String)Messages.ProEditor_ErrorNoOpenProjectsTitle, (String)Messages.ProEditor_ErrorNoOpenProjectsMessage);
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return null;
        }
        if (defaultFileHandle != null) {
            dialog.setOriginalFile(defaultFileHandle);
        }
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "com.rsi.idldt.ui.dialog_save_as");
        if (provider == null) {
            return null;
        }
        if (dialog.open() == 1) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return null;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        return new FileEditorInput(file);
    }

    public boolean wasAddedToDOM() {
        return this.m_bAddedToDOM;
    }

    protected void doSetInput(IEditorInput newInput) throws CoreException {
        IIDLDOMManager manager;
        IEditorInput oldInput = this.getEditorInput();
        Object oldFile = IDLEditorUtilities.getEditorsFile(oldInput);
        Object newFile = IDLEditorUtilities.getEditorsFile(newInput);
        if (this.m_outlinePage != null) {
            this.m_outlinePage.setInput(newInput);
        }
        if ((manager = IDLDOMManager.getActiveManager()) != null) {
            ProEditorUtilities.transferBreakpoints(oldInput, newInput);
            manager.removeEditor(oldFile);
            if (!UIPlugin.editorAddedOnStartup(newInput)) {
                manager.addEditor(newFile);
            }
            this.m_bAddedToDOM = true;
        }
        super.doSetInput(newInput);
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean success;
        block18: {
            Shell shell = this.getSite().getShell();
            IEditorInput input = this.getEditorInput();
            IDocumentProvider provider = this.getDocumentProvider();
            IEditorInput newInput = null;
            newInput = this.getWorkspaceSaveAsInput(progressMonitor);
            if (newInput == null) {
                return;
            }
            success = false;
            try {
                try {
                    provider.aboutToChange((Object)newInput);
                    provider.saveDocument(progressMonitor, (Object)newInput, provider.getDocument((Object)input), true);
                    success = true;
                }
                catch (CoreException e) {
                    IStatus status = e.getStatus();
                    if (status == null || status.getSeverity() != 8) {
                        String title = Messages.ProEditor_ErrorSavingTitle;
                        String msg = Messages.ProEditor_ErrorSavingMessage;
                        if (status != null) {
                            switch (status.getSeverity()) {
                                case 1: {
                                    MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                                    break;
                                }
                                case 2: {
                                    MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                                    break;
                                }
                                default: {
                                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                                    break;
                                }
                            }
                        } else {
                            MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                        }
                    }
                    provider.changed((Object)newInput);
                    if (success) {
                        this.setInput(newInput);
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                provider.changed((Object)newInput);
                if (success) {
                    this.setInput(newInput);
                }
                throw throwable;
            }
            provider.changed((Object)newInput);
            if (success) {
                this.setInput(newInput);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
        if (success) {
            this.m_annotationModel = null;
            this.editorSaved();
        }
    }

    protected boolean lineExists(int line_num) {
        boolean exists = false;
        IDocument doc = this.m_viewer.getDocument();
        try {
            doc.getLineInformation(line_num);
            exists = true;
        }
        catch (BadLocationException badLocationException) {}
        return exists;
    }

    protected ArrayList<Position> getFoldingPositionsForCommentBlocks() {
        IEditorInput input = this.getEditorInput();
        IDocumentProvider provider = this.getDocumentProvider();
        String contents = provider.getDocument((Object)input).get();
        ArrayList<Position> positions = new ArrayList<Position>();
        int blockOffset = 0;
        int blockLength = 0;
        int numLinesInBlock = 0;
        boolean bInCommentBlock = false;
        int i = 0;
        while (i < contents.length()) {
            if (i == -1) {
                if (!bInCommentBlock) break;
                if (numLinesInBlock > 1) {
                    Position p = new Position(blockOffset, blockLength);
                    positions.add(p);
                }
                bInCommentBlock = false;
                blockLength = 0;
                numLinesInBlock = 0;
                break;
            }
            boolean bCommentOnlyLine = this.commentOnlyLine(contents, i);
            if (bInCommentBlock) {
                if (bCommentOnlyLine) {
                    ++numLinesInBlock;
                    blockLength += this.getEndOfLineOffset(contents, i) - i;
                } else {
                    if (numLinesInBlock > 1) {
                        Position p = new Position(blockOffset, blockLength);
                        positions.add(p);
                    }
                    bInCommentBlock = false;
                    blockLength = 0;
                    numLinesInBlock = 0;
                }
            } else if (bCommentOnlyLine) {
                blockOffset = i;
                blockLength = this.getEndOfLineOffset(contents, i) - i;
                bInCommentBlock = true;
                ++numLinesInBlock;
            }
            i = this.getBeginningOffsetOfNextLine(contents, i);
        }
        return positions;
    }

    protected int getEndOfLineOffset(String contents, int start) {
        int i = start;
        while (i < contents.length()) {
            char c = contents.charAt(i);
            if (c == '\n') {
                return i + 1;
            }
            ++i;
        }
        return i;
    }

    protected boolean commentOnlyLine(String contents, int start) {
        for (int i = start; i < contents.length(); ++i) {
            char c = contents.charAt(i);
            if (c == ';') {
                return true;
            }
            if (c == '\r' || c == '\n') {
                return false;
            }
            if (Character.isWhitespace(c)) {
                continue;
            }
            return false;
        }
        return false;
    }

    protected int getBeginningOffsetOfNextLine(String contents, int start) {
        int i = start;
        while (i < contents.length()) {
            if (contents.charAt(i) == '\n') {
                if (i + 1 < contents.length()) {
                    return i + 1;
                }
                return -1;
            }
            ++i;
        }
        return -1;
    }

    protected ArrayList<Position> getFoldingPositionsFromDOM() {
        IDocument doc = this.m_viewer.getDocument();
        IEditorInput input = this.getEditorInput();
        IDocumentProvider provider = this.getDocumentProvider();
        String contents = provider.getDocument((Object)input).get();
        this.m_getFoldingPositionsFromDOM_ranOnce = true;
        IIDLCompilationUnit cu = IDLDOMManager.temporaryParseString((String)contents);
        IIDLRoutine[] methods = cu.getRoutines();
        long num_methods = methods.length;
        ArrayList<Position> positions = new ArrayList<Position>();
        int i = 0;
        while ((long)i < num_methods) {
            ISourceCodeRange scr = methods[i].getSourceRange();
            try {
                int end_line = doc.getLineOfOffset(scr.getOffset() + scr.getLength());
                boolean useLineEnd = true;
                if (this.lineExists(end_line + 1)) {
                    useLineEnd = false;
                    ++end_line;
                }
                IRegion r = doc.getLineInformation(end_line);
                int endOffset = r.getOffset();
                Position p = new Position(scr.getOffset(), (endOffset += useLineEnd ? r.getLength() : 0) - scr.getOffset());
                positions.add(p);
            }
            catch (BadLocationException badLocationException) {}
            ++i;
        }
        return positions;
    }

    protected void updateFoldingStructure() {
        boolean bHaveRoutinePositions;
        ArrayList<Position> positions = this.getFoldingPositionsForCommentBlocks();
        ArrayList<Position> routinePositions = this.getFoldingPositionsFromDOM();
        boolean bl = bHaveRoutinePositions = routinePositions != null && routinePositions.size() != 0;
        if (bHaveRoutinePositions && routinePositions != null) {
            while (routinePositions.size() > 0) {
                positions.add(routinePositions.remove(0));
            }
        }
        if (this.m_annotationModel == null) {
            ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
            this.m_annotationModel = viewer.getProjectionAnnotationModel();
            if (this.m_annotationModel == null) {
                return;
            }
        }
        Annotation[] annotations = new Annotation[positions.size()];
        HashMap<Position, ProjectionAnnotation> positionToAnnotationMap = new HashMap<Position, ProjectionAnnotation>();
        int i = 0;
        while (i < positions.size()) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            positionToAnnotationMap.put(positions.get(i), annotation);
            annotations[i] = annotation;
            ++i;
        }
        ArrayList<Annotation> annotationsToDeleteList = new ArrayList<Annotation>();
        HashMap<Annotation, Position> annotationsToAddMap = new HashMap<Annotation, Position>();
        this.computeFoldingDifferences(this.m_annotationModel, positionToAnnotationMap, annotationsToDeleteList, annotationsToAddMap);
        Annotation[] annotationsToDelete = annotationsToDeleteList.toArray(new Annotation[annotationsToDeleteList.size()]);
        if (!annotationsToDeleteList.isEmpty() || !annotationsToAddMap.isEmpty()) {
            this.m_annotationModel.modifyAnnotations(annotationsToDelete, annotationsToAddMap, new Annotation[0]);
        }
    }

    private void computeFoldingDifferences(ProjectionAnnotationModel model, Map<Position, ProjectionAnnotation> positionToAnnotationMap, List<Annotation> annotationsToDeleteList, Map<Annotation, Position> annotationsToAddMap) {
        Iterator<Position> iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Object annotation = iter.next();
            if (!(annotation instanceof ProjectionAnnotation)) continue;
            Position position = model.getPosition((Annotation)annotation);
            if (positionToAnnotationMap.containsKey(position)) {
                positionToAnnotationMap.remove(position);
                continue;
            }
            annotationsToDeleteList.add((Annotation)((ProjectionAnnotation)annotation));
        }
        for (Position position : positionToAnnotationMap.keySet()) {
            ProjectionAnnotation annotation = positionToAnnotationMap.get(position);
            annotationsToAddMap.put((Annotation)annotation, position);
        }
    }

    private IFile determineSaveAsDefaultFile(IProject project, String fileName) {
        IFile original = null;
        if (project != null) {
            original = project.getFile(fileName);
        }
        return original;
    }

    private IProject determineSaveAsDefaultProject() {
        IProject project = null;
        IWorkspace wk = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = wk.getRoot();
        IProject[] projects = root.getProjects();
        if (projects.length == 0) {
            project = IDLProjectNature.createDefaultProjectIfNecessary();
        } else {
            project = root.getProject(IDLProjectNature.getDefaultProjectName());
            if (project != null && !project.isOpen()) {
                project = null;
            }
            int i = 0;
            while (i < projects.length) {
                if (projects[i].isOpen()) {
                    project = projects[i];
                    break;
                }
                ++i;
            }
        }
        return project;
    }

    public String generateAutoPopulateName(IEditorInput input) {
        String name = null;
        IDocumentProvider provider = this.getDocumentProvider();
        String contents = provider.getDocument((Object)input).get();
        IIDLCompilationUnit cu = IDLDOMManager.temporaryParseString((String)contents);
        IIDLRoutine[] methods = cu.getRoutines();
        if (methods != null && methods.length > 0) {
            name = methods[methods.length - 1].getElementName();
        }
        if (name == null || name.length() == 0) {
            name = this.getTitle();
        }
        if (!(name = name.replaceAll("[: ]", "_").toLowerCase()).toLowerCase().endsWith(".pro")) {
            name = String.valueOf(name) + ".pro";
        }
        return name;
    }

    public void gotoMatchingBracket() {
        ISelection selection;
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        if (this.m_matcher == null) {
            this.m_matcher = new ProPairMatcher(BRACKETS);
        }
        if (!((selection = this.getSelectionProvider().getSelection()) instanceof ITextSelection)) {
            return;
        }
        ITextSelection textSelect = (ITextSelection)selection;
        int length = textSelect.getLength();
        int offset = textSelect.getOffset() + length;
        if (length > 1) {
            this.setStatusLineErrorMessage(Messages.GotoMatchingBracket_ErrorInvalidSelection);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        IRegion region = this.m_matcher.match(document, offset);
        if (region == null) {
            this.setStatusLineErrorMessage(Messages.GotoMatchingBracket_ErrorNoMatchingBracket);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int newoffset = region.getOffset() + 1;
        if (offset == newoffset) {
            newoffset += region.getLength() - 1;
        }
        this.selectAndReveal(newoffset, 0);
    }

    public ISourceViewer getSourceViewerWrapper() {
        return this.getSourceViewer();
    }

    public ITextViewer getViewer() {
        return this.m_viewer;
    }

    public int getTabWidth() {
        return this.m_SourceViewerConfiguration.getTabWidth(this.getSourceViewer());
    }

    public void enableContentAssistAutoInsert(boolean value) {
        this.m_SourceViewerConfiguration.enableContentAssistAutoInsert(value);
    }

    public int getCaretOffset() {
        int caret;
        try {
            caret = this.getSourceViewer().getTextWidget().getCaretOffset();
        }
        catch (Exception exception) {
            caret = 0;
        }
        return ProEditor.widgetOffset2ModelOffset((ISourceViewer)this.getSourceViewer(), (int)caret);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        IDocumentProvider dp = this.getDocumentProvider();
        if (dp == null) {
            return;
        }
        if (this.m_OccurrencesFinderJob != null) {
            this.m_OccurrencesFinderJob.doCancel();
        }
        IDocument document = dp.getDocument((Object)this.getEditorInput());
        int offset = event.getOffset();
        int length = event.getLength();
        IEditorInput input = this.getEditorInput();
        IFile file = ((IFileEditorInput)input).getFile();
        if (file == null) {
            return;
        }
        IMarker[] problemMarkers = null;
        try {
            problemMarkers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int firstChangedLine = document.getLineOfOffset(offset);
            int lastChangedLine = document.getLineOfOffset(offset + length);
            boolean bNeedUpdate = false;
            int i = 0;
            while (i < problemMarkers.length) {
                int lineOfMarker;
                IMarker marker = problemMarkers[i];
                if (marker != null && (lineOfMarker = ((Integer)marker.getAttribute("lineNumber")).intValue()) >= firstChangedLine && lineOfMarker <= lastChangedLine) {
                    marker.delete();
                    bNeedUpdate = true;
                }
                ++i;
            }
            if (bNeedUpdate) {
                ProblemsLabelDecorator.update();
            }
        }
        catch (CoreException coreException) {
        }
        catch (BadLocationException badLocationException) {}
    }

    public void documentChanged(DocumentEvent event) {
        if (this.getDocumentProvider() == null) {
            return;
        }
        final IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        IResource resource = (IResource)this.getEditorInput().getAdapter(IResource.class);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(resource)){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    ((AbstractMarkerAnnotationModel)ProEditor.this.getSourceViewer().getAnnotationModel()).updateMarkers(document);
                    IMarker[] problemMarkers = null;
                    IEditorInput input = ProEditor.this.getEditorInput();
                    IFile file = ((IFileEditorInput)input).getFile();
                    if (file == null) {
                        return;
                    }
                    problemMarkers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                    int i = 0;
                    while (i < problemMarkers.length) {
                        Integer markerLine = (Integer)problemMarkers[i].getAttribute("lineNumber");
                        if (markerLine != null) {
                            String location = String.valueOf(Messages.IDLStackFrame_LineNumber) + " " + Integer.toString(markerLine);
                            problemMarkers[i].setAttribute("location", (Object)location);
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
        };
        try {
            op.run(null);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        if (this.m_OccurrencesFinderJob != null) {
            this.m_OccurrencesFinderJob.doCancel();
        }
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        IPreferenceStore store;
        String prop = event.getProperty();
        if ("IDLDT_TASK_TAG_HIGH".equals(prop) || "IDLDT_TASK_TAG_NORMAL".equals(prop) || "IDLDT_TASK_TAG_LOW".equals(prop)) {
            this.updateTodoMarkers();
            return;
        }
        if ("IDLDT_ENABLE_CODE_FOLDING".equals(prop) && (store = UIPreferenceManager.getPreferenceStore()) != null) {
            boolean enableCodeFolding = store.getBoolean("IDLDT_ENABLE_CODE_FOLDING");
            this.setCodeFolding(enableCodeFolding);
        }
        if ("IDLDT_MARK_OCCURRENCES".equals(prop)) {
            ISelection selection = this.doGetSelection();
            this.getSelectionProvider().setSelection(selection);
        }
        if ("IDLDT_SPACES_FOR_TABS".equals(prop)) {
            if (this.isTabsToSpacesConversionEnabled()) {
                this.installTabsToSpacesConverter();
            } else {
                this.uninstallTabsToSpacesConverter();
            }
            return;
        }
        if ("IDLDT_TAB_WIDTH".equals(prop)) {
            store = UIPreferenceManager.getPreferenceStore();
            if (store != null) {
                int topIndex = this.getSourceViewer().getTopIndex();
                this.getSourceViewer().getTextWidget().setTabs(store.getInt("IDLDT_TAB_WIDTH"));
                this.getSourceViewer().setTopIndex(topIndex);
            }
            if (this.isTabsToSpacesConversionEnabled()) {
                this.uninstallTabsToSpacesConverter();
                this.installTabsToSpacesConverter();
            }
            return;
        }
        if ("spacesForTabs".equals(prop) || "tabWidth".equals(prop)) {
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.handlePreferenceStoreChanged(event);
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        IPreferenceStore store = UIPreferenceManager.getPreferenceStore();
        return store != null ? store.getBoolean("IDLDT_SPACES_FOR_TABS") : false;
    }

    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        return (target instanceof IDLThread || target instanceof IDLStackFrame) && target.canResume() && this.isOnStatementLine(part, selection);
    }

    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        ITextSelection textSelection = (ITextSelection)selection;
        int lineNumber = textSelection.getStartLine() + 1;
        int offset = textSelection.getOffset();
        IIDLProcessProxy activeProcess = IDLProcessManager.getActiveProcess();
        IDLDebugTarget dt = activeProcess.getDebugTarget();
        IEditorInput input = this.getEditorInput();
        IResource resource = (IResource)input.getAdapter(IResource.class);
        IDLLineBreakpoint bp = null;
        if (resource != null) {
            bp = new IDLLineBreakpoint(resource, lineNumber, offset, true);
        } else {
            ILocationProvider loc = (ILocationProvider)input.getAdapter(ILocationProvider.class);
            IPath path = loc != null ? loc.getPath((Object)input) : null;
            bp = new IDLExternalLineBreakpoint(path, lineNumber, offset, true);
        }
        RunToLineHandler runHandler = new RunToLineHandler((IDebugTarget)dt, target, (IBreakpoint)bp);
        runHandler.run(this.getProgressMonitor());
    }

    private boolean isOnStatementLine(IWorkbenchPart part, ISelection selection) {
        if (part instanceof IEditorPart && selection instanceof ITextSelection) {
            int n = ((ITextSelection)selection).getStartLine();
            String s = ProEditorUtilities.getLineAsString((IEditorPart)part, n);
            if (s == null) {
                return false;
            }
            if ((s = s.trim()).length() == 0) {
                return false;
            }
            char c = s.charAt(0);
            return c != ';' && c != '@';
        }
        return false;
    }

    void installHighlighter() {
        ISourceViewer viewer = this.getSourceViewer();
        EditorSelectionChangedListener findOccurSelChangedListener = new EditorSelectionChangedListener();
        if (viewer instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)viewer).addPostSelectionChangedListener((ISelectionChangedListener)findOccurSelChangedListener);
        }
    }

    void updateOccurrenceAnnotations(TextSelection selection) {
        this.removeOccurrenceAnnotations();
        IAnnotationModel annotationModel = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null) {
            return;
        }
        if (selection == null) {
            return;
        }
        boolean bMarkOccurrences = UIPreferenceManager.getPreferenceStore().getBoolean("IDLDT_MARK_OCCURRENCES");
        if (!bMarkOccurrences) {
            return;
        }
        if (this.m_OccurrencesFinderJob != null) {
            this.m_OccurrencesFinderJob.cancel();
        }
        this.m_OccurrencesFinderJob = new OccurrencesFinderJob(annotationModel, selection);
        this.m_OccurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOccurrenceAnnotations() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null || this.m_OccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.m_OccurrenceAnnotations, null);
            } else {
                int i = 0;
                int length = this.m_OccurrenceAnnotations.length;
                while (i < length) {
                    annotationModel.removeAnnotation(this.m_OccurrenceAnnotations[i]);
                    ++i;
                }
            }
            this.m_OccurrenceAnnotations = null;
        }
    }

    Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    public void performIDLProcedureOnSelectedText(String procedureName) {
        String selectedText;
        Point sel = this.m_viewer.getSelectedRange();
        if (sel == null) {
            return;
        }
        IEditorInput editorInput = this.getEditorInput();
        IDocument document = this.getDocumentProvider().getDocument((Object)editorInput);
        try {
            selectedText = document.get(sel.x, sel.y);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        int iEnd = selectedText.length() - 1;
        if (selectedText.charAt(iEnd) != '\n') {
            String newline = System.getProperty("line.separator");
            selectedText = String.valueOf(selectedText) + newline;
        }
        CommandLineView.getInstance().doDropTextIntoCommandLine(String.valueOf(procedureName) + ", " + selectedText, 0);
    }

    public void runSelectedText() {
        String selectedText;
        Point sel = this.m_viewer.getSelectedRange();
        if (sel == null) {
            return;
        }
        IEditorInput editorInput = this.getEditorInput();
        IDocument document = this.getDocumentProvider().getDocument((Object)editorInput);
        try {
            selectedText = document.get(sel.x, sel.y);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        int iEnd = selectedText.length() - 1;
        if (selectedText.charAt(iEnd) != '\n') {
            String newline = System.getProperty("line.separator");
            selectedText = String.valueOf(selectedText) + newline;
        }
        CommandLineView.getInstance().doDropTextIntoCommandLine(selectedText, 0);
    }

    public void handleActivatedProcess(IIDLProcessProxy idl) {
        if (this.m_changeWorkingDirCmd != null) {
            idl.queueSilentExecuteString(this.m_changeWorkingDirCmd);
            this.m_changeWorkingDirCmd = null;
        }
    }

    public void handleDeletedProcess(IIDLProcessProxy idl) {
    }

    public void handleNewProcess(IIDLProcessProxy idl) {
    }

    private class CollapseAllFoldingAction
    extends TextEditorAction {
        public CollapseAllFoldingAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        public void run() {
            ITextEditor editor = this.getTextEditor();
            ((ProEditor)editor).foldingCollapseAll();
        }
    }

    private class DefineFoldingRegionAction
    extends TextEditorAction {
        public DefineFoldingRegionAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        private IAnnotationModel getAnnotationModel(ITextEditor editor) {
            return (IAnnotationModel)editor.getAdapter(ProjectionAnnotationModel.class);
        }

        public void run() {
            IAnnotationModel model;
            ITextSelection textSelection;
            ITextEditor editor = this.getTextEditor();
            ISelection selection = editor.getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection && !(textSelection = (ITextSelection)selection).isEmpty() && (model = this.getAnnotationModel(editor)) != null) {
                int start_line = textSelection.getStartLine();
                int end_line = textSelection.getEndLine();
                try {
                    IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                    int offset = document.getLineOffset(start_line);
                    IRegion r = document.getLineInformation(end_line);
                    int endOffset = r.getOffset() + r.getLength();
                    Position position = new Position(offset, endOffset - offset);
                    model.addAnnotation((Annotation)new ProjectionAnnotation(), position);
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    class EditorSelectionChangedListener
    extends AbstractTextEditor.AbstractSelectionChangedListener {
        EditorSelectionChangedListener() {
            super((AbstractTextEditor)ProEditor.this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ProEditor.this.updateOccurrenceAnnotations((TextSelection)event.getSelection());
        }
    }

    private class EnableDisableFoldingAction
    extends TextEditorAction {
        public EnableDisableFoldingAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor, 2);
        }

        public void run() {
            ITextEditor editor = this.getTextEditor();
            ((ProEditor)editor).toggleCodeFolding();
        }
    }

    private class ExpandAllFoldingAction
    extends TextEditorAction {
        public ExpandAllFoldingAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        public void run() {
            ITextEditor editor = this.getTextEditor();
            ((ProEditor)editor).foldingExpandAll();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OccurrencesFinderJob
    extends Job {
        private IAnnotationModel fannotationModel;
        private TextSelection fSelection;
        private boolean fCanceled;
        private IProgressMonitor fProgressMonitor;

        public OccurrencesFinderJob(IAnnotationModel annotationModel, TextSelection selection) {
            super(Messages.ProEditor_FindOccurrencesJob);
            this.fCanceled = false;
            this.fannotationModel = annotationModel;
            this.fSelection = selection;
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled() {
            return this.fCanceled || this.fProgressMonitor.isCanceled();
        }

        protected String getSelectedWord() {
            String sSelection;
            block7: {
                char ch;
                int offset;
                IDocument document;
                block8: {
                    sSelection = "";
                    if (this.fSelection.getLength() > 1) {
                        sSelection = ProEditor.this.m_viewer.getDocument().get(this.fSelection.getOffset(), this.fSelection.getLength());
                        break block7;
                    }
                    document = ProEditor.this.m_viewer.getDocument();
                    ch = document.getChar(offset = this.fSelection.getOffset());
                    if (!Character.isWhitespace(ch)) break block8;
                    return "";
                }
                try {
                    --offset;
                    while (offset >= 0) {
                        ch = document.getChar(offset);
                        if (!Character.isLetterOrDigit(ch) && ch != '_') break;
                        --offset;
                    }
                    ++offset;
                    while (offset < document.getLength()) {
                        ch = document.getChar(offset);
                        if (Character.isLetterOrDigit(ch) || ch == '_') {
                            sSelection = String.valueOf(sSelection) + ch;
                            ++offset;
                            continue;
                        }
                        break;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            return sSelection;
        }

        public HashMap<Annotation, Position> buildAnnotationMap(String wordOfInterest) {
            IDocument doc = ProEditor.this.m_viewer.getDocument();
            HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>();
            String findString = wordOfInterest;
            boolean forwardSearch = true;
            boolean caseSensitive = false;
            boolean wholeWord = true;
            boolean regExSearch = false;
            if (findString == null || findString.length() == 0) {
                return annotationMap;
            }
            try {
                FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(doc);
                int start_line_num = 0;
                IRegion line_info = doc.getLineInformation(start_line_num);
                int startOffset = line_info.getOffset();
                IRegion r = adapter.find(startOffset, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
                while (r != null && !this.isCanceled()) {
                    int line_num = doc.getLineOfOffset(r.getOffset());
                    line_info = doc.getLineInformation(line_num);
                    String word = doc.get(r.getOffset(), r.getLength());
                    Position position = new Position(r.getOffset(), r.getLength());
                    annotationMap.put(new Annotation("com.rsi.idldt.ui.occurrences", false, word), position);
                    int offset = forwardSearch ? r.getOffset() + r.getLength() : r.getOffset() - 1;
                    r = adapter.find(offset, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
                }
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (PatternSyntaxException patternSyntaxException) {}
            return annotationMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            this.fProgressMonitor = progressMonitor;
            if (this.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (this.fannotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            Object object = ProEditor.this.getLockObject(this.fannotationModel);
            synchronized (object) {
                String word = this.getSelectedWord();
                if (word == null || word.length() == 0) {
                    return Status.OK_STATUS;
                }
                HashMap<Annotation, Position> annotationMap = this.buildAnnotationMap(word);
                if (this.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (annotationMap == null) {
                    return Status.OK_STATUS;
                }
                if (annotationMap.size() == 1) {
                    return Status.OK_STATUS;
                }
                if (this.fannotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)this.fannotationModel).replaceAnnotations(ProEditor.this.m_OccurrenceAnnotations, annotationMap);
                } else {
                    for (Map.Entry<Annotation, Position> mapEntry : annotationMap.entrySet()) {
                        this.fannotationModel.addAnnotation(mapEntry.getKey(), mapEntry.getValue());
                    }
                }
                ProEditor.this.m_OccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
            }
            return Status.OK_STATUS;
        }
    }
}

