/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor;

import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.proeditor.pro.ProWordFormattingStrategy;
import com.rsi.idldt.ui.UIPlugin;
import com.rsi.idldt.ui.UIPreferenceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class ProDocumentTemplateContext
extends DocumentTemplateContext {
    int m_caretOffsetInLine = 0;
    boolean m_isFirstLineIndentionNeeded = true;
    boolean m_useSpaces = false;
    int m_tabWidth = 4;

    public ProDocumentTemplateContext(TemplateContextType type, IDocument document, int offset, int length) {
        super(type, document, new Position(offset, length));
    }

    private String getIndentationString() {
        int start = this.getStart();
        IDocument document = this.getDocument();
        String lineContent = "";
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor instanceof ProEditor) {
            this.m_tabWidth = ((ProEditor)activeEditor).getTabWidth();
            this.m_useSpaces = UIPreferenceManager.getPreferenceStore().getBoolean("IDLDT_SPACES_FOR_TABS");
        }
        try {
            IRegion region = document.getLineInformationOfOffset(start);
            lineContent = document.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException badLocationException) {}
        this.m_isFirstLineIndentionNeeded = lineContent.length() == 0;
        return this.getAllLeadingWhiteSpaceInCurrentLine(lineContent);
    }

    public TemplateBuffer evaluate(Template theTemplate) throws BadLocationException, TemplateException {
        Template template = theTemplate;
        if (!this.canEvaluate(template)) {
            return null;
        }
        if (this.isReadOnly()) {
            String s = "<pre>" + template.getPattern() + "</pre>";
            return new TemplateBuffer(s, new TemplateVariable[0]);
        }
        String sep = System.getProperty("line.separator");
        String pattern = template.getPattern();
        pattern = pattern.replaceAll("\r\n", "\n");
        if ("\r\n".equals(sep)) {
            pattern = pattern.replaceAll("\n", "\r\n");
        }
        template = new Template(template.getName(), template.getDescription(), template.getContextTypeId(), pattern, template.isAutoInsertable());
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        String s = buffer.getString();
        int[] lineOffsetOrig = this.computeLineOffsets(s);
        ProWordFormattingStrategy formatter = new ProWordFormattingStrategy();
        TemplateVariable[] vars = buffer.getVariables();
        if (template.getContextTypeId().equals("com.rsi.idldt.ui.proeditor.idldoc_context")) {
            this.getIndentationString();
            s = formatter.formatIDLdocTemplates(s, this.m_isFirstLineIndentionNeeded, vars);
        } else {
            String currentIndentation = this.getIndentationString();
            formatter.formatterStarts(currentIndentation);
            String indentChars = this.getConfiguredIndentation();
            s = formatter.format(s, this.m_isFirstLineIndentionNeeded, indentChars, null);
            int[] lineOffsetNew = this.computeLineOffsets(s);
            int i = 0;
            while (i < vars.length) {
                int[] vos = vars[i].getOffsets();
                int j = 0;
                while (j < vos.length) {
                    int k = lineOffsetOrig.length - 2;
                    while (k >= 0) {
                        if (vos[j] >= lineOffsetOrig[k]) {
                            int n = j;
                            vos[n] = vos[n] + (lineOffsetNew[k + 1] - lineOffsetOrig[k + 1]);
                            break;
                        }
                        --k;
                    }
                    ++j;
                }
                vars[i].setOffsets(vos);
                ++i;
            }
        }
        buffer.setContent(s, vars);
        return buffer;
    }

    private String getConfiguredIndentation() {
        if (this.m_useSpaces) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.m_tabWidth) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        return "\t";
    }

    private int[] computeLineOffsets(String string) {
        int lf = 0;
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) == '\n') {
                ++lf;
            }
            ++i;
        }
        if (++lf == 1) {
            int[] offsets = new int[]{0, string.length()};
            return offsets;
        }
        int[] offsets = new int[lf];
        lf = 1;
        int i2 = 0;
        while (i2 < string.length()) {
            if (string.charAt(i2) == '\n') {
                offsets[lf] = i2 + 1;
                ++lf;
            }
            ++i2;
        }
        return offsets;
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchWindow wbw = UIPlugin.getActiveWorkbenchWindow();
        if (wbw == null) {
            return null;
        }
        IWorkbenchPage activePage = wbw.getActivePage();
        if (activePage == null) {
            return null;
        }
        return activePage.getActiveEditor();
    }

    private String getAllLeadingWhiteSpaceInCurrentLine(String lineContent) {
        String result = "";
        int i = 0;
        while (i < lineContent.length()) {
            char ch = lineContent.charAt(i);
            if (!Character.isWhitespace(ch) || ch == '\r' || ch == '\n') break;
            result = String.valueOf(result) + ch;
            ++i;
        }
        return result;
    }
}

