/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor;

import com.rsi.idldt.ui.UIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class ProDocAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private boolean isSmartMode() {
        IWorkbenchWindow wbw = UIPlugin.getActiveWorkbenchWindow();
        if (wbw == null) {
            return true;
        }
        IWorkbenchPage page = wbw.getActivePage();
        if (page != null) {
            IEditorPart part = page.getActiveEditor();
            if (part == null) {
                return true;
            }
            if (part instanceof ITextEditorExtension3) {
                ITextEditorExtension3 extension = (ITextEditorExtension3)part;
                return extension.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
            }
        }
        return false;
    }

    private IRegion findPrefixRange(IDocument document, IRegion line) throws BadLocationException {
        int lineOffset = line.getOffset();
        int lineEnd = lineOffset + line.getLength();
        String cstr = document.get(lineOffset, line.getLength());
        int i = 0;
        i = 0;
        while (i < cstr.length()) {
            if (cstr.charAt(i) == ';') break;
            ++i;
        }
        i = i == cstr.length() ? 0 : ++i;
        int indentEnd = this.findEndOfWhiteSpace(document, lineOffset + i, lineEnd);
        return new Region(lineOffset, indentEnd - lineOffset);
    }

    private boolean indentAfterNewLine(IDocument d, DocumentCommand c) {
        boolean bHandledIt = false;
        int offset = c.offset;
        if (offset == -1 || d.getLength() == 0) {
            return bHandledIt;
        }
        try {
            int p = offset == d.getLength() ? offset - 1 : offset;
            IRegion lineAbove = d.getLineInformationOfOffset(p);
            int lineNum = d.getLineOfOffset(c.offset);
            IRegion lineBelowRegion = d.getLineInformation(++lineNum);
            String lineBelow = d.get(lineBelowRegion.getOffset(), lineBelowRegion.getLength());
            char ch = ' ';
            int i = 0;
            while (i < lineBelow.length()) {
                ch = lineBelow.charAt(i);
                if (!Character.isWhitespace(ch)) break;
                ++i;
            }
            if (i == lineBelow.length()) {
                return bHandledIt;
            }
            if (ch != ';') {
                return bHandledIt;
            }
            StringBuffer buf = new StringBuffer(c.text);
            IRegion prefix = this.findPrefixRange(d, lineAbove);
            String indentation = d.get(prefix.getOffset(), prefix.getLength());
            if (!this.isPureCommentLine(indentation)) {
                bHandledIt = false;
                return bHandledIt;
            }
            int lengthToAdd = Math.min(offset - prefix.getOffset(), prefix.getLength());
            buf.append(indentation.substring(0, lengthToAdd));
            if (lengthToAdd < prefix.getLength()) {
                c.caretOffset = offset + prefix.getLength() - lengthToAdd;
            }
            c.text = buf.toString();
            bHandledIt = true;
        }
        catch (BadLocationException badLocationException) {}
        return bHandledIt;
    }

    protected boolean isPureCommentLine(String prefix) {
        return prefix.trim().startsWith(";");
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        String[] lineDelimiters;
        int index;
        if (!this.isSmartMode()) {
            super.customizeDocumentCommand(document, command);
            return;
        }
        boolean bHandledIt = false;
        if (command.text != null && command.length == 0 && (index = TextUtilities.endsWith((String[])(lineDelimiters = document.getLegalLineDelimiters()), (String)command.text)) > -1 && lineDelimiters[index].equals(command.text)) {
            bHandledIt = this.indentAfterNewLine(document, command);
        }
        if (!bHandledIt) {
            super.customizeDocumentCommand(document, command);
        }
    }
}

