/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor;

import com.rsi.idldt.proeditor.IDLElementHyperlink;
import com.rsi.idldt.proeditor.ProTextHover;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class IDLElementHyperlinkDetector
extends AbstractHyperlinkDetector {
    private String getTextOnLine(int line_num, ITextViewer viewer) {
        String line = "";
        IDocument doc = viewer.getDocument();
        try {
            IRegion line_info = doc.getLineInformation(line_num);
            line = doc.get(line_info.getOffset(), line_info.getLength());
        }
        catch (BadLocationException badLocationException) {}
        return line;
    }

    protected String getClassNameFromLine(String theLine) {
        StringBuffer className = new StringBuffer();
        String line = theLine;
        if ((line = line.toLowerCase().trim()).startsWith("pro") || line.startsWith("function")) {
            int index = line.indexOf("::");
            if (--index < 0) {
                index = line.indexOf("__define");
                --index;
            }
            while (index >= 0) {
                char ch = line.charAt(index);
                if (ch == ' ') break;
                className.append(ch);
                --index;
            }
        }
        if (className.length() > 0) {
            className.reverse();
            return className.toString();
        }
        return null;
    }

    protected String getClassNameForOffset(int docOffset, ITextViewer viewer) {
        int line_num = 0;
        String className = null;
        try {
            IDocument doc = viewer.getDocument();
            line_num = doc.getLineOfOffset(docOffset);
        }
        catch (BadLocationException badLocationException) {}
        while (line_num >= 0 && className == null) {
            String line = this.getTextOnLine(line_num, viewer);
            className = this.getClassNameFromLine(line);
            --line_num;
        }
        return className;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String linkTarget;
        if (region == null) {
            return null;
        }
        IRegion linkRegion = ProTextHover.findTokenRegion(textViewer.getDocument(), region.getOffset());
        if (linkRegion == null || linkRegion.getLength() <= 0) {
            return null;
        }
        try {
            linkTarget = textViewer.getDocument().get(linkRegion.getOffset(), linkRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        if (linkTarget.toLowerCase().startsWith("self->")) {
            linkTarget = linkTarget.substring(6);
            String className = this.getClassNameForOffset(linkRegion.getOffset(), textViewer);
            if (className != null) {
                linkTarget = "self->" + className + "::" + linkTarget;
            }
        }
        if (linkTarget != null && IDLElementHyperlink.canLocateFileAndOffsetForTarget(linkTarget)) {
            return new IHyperlink[]{new IDLElementHyperlink(linkRegion, linkTarget)};
        }
        return null;
    }
}

