/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;

public class ExternalProAnnotationModel
extends AbstractMarkerAnnotationModel
implements IResourceChangeListener {
    private IWorkspace m_workspace;
    private IWorkspaceRoot m_root;
    private String m_documentPath;

    public ExternalProAnnotationModel(IWorkspace workspace, File f) {
        this.m_workspace = workspace;
        this.m_root = workspace.getRoot();
        this.m_documentPath = this.getCanonicalPath(f);
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        if (this.m_root != null) {
            IMarker[] markers = this.m_root.findMarkers("org.eclipse.core.resources.marker", true, 0);
            return markers;
        }
        return null;
    }

    protected boolean isAcceptable(IMarker marker) {
        String markerPath = marker.getAttribute("EXTERNAL_FILE_PATH", "");
        return this.m_documentPath.compareTo(markerPath) == 0;
    }

    protected void deleteMarkers(IMarker[] markers) throws CoreException {
        if (this.m_root != null) {
            this.m_root.deleteMarkers("org.eclipse.core.resources.marker", true, 0);
        }
    }

    protected void listenToMarkerChanges(boolean listen) {
        if (listen) {
            this.m_workspace.addResourceChangeListener((IResourceChangeListener)this);
        } else {
            this.m_workspace.removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public void resourceChanged(IResourceChangeEvent e) {
        IMarkerDelta[] markerDeltas = e.findMarkerDeltas("org.eclipse.core.resources.marker", true);
        boolean modelChanged = false;
        int i = 0;
        while (i < markerDeltas.length) {
            IMarkerDelta delta = markerDeltas[i];
            IMarker marker = markerDeltas[i].getMarker();
            switch (delta.getKind()) {
                case 1: {
                    this.addMarkerAnnotation(marker);
                    break;
                }
                case 2: {
                    this.removeMarkerAnnotation(marker);
                    break;
                }
                case 4: {
                    this.modifyMarkerAnnotation(marker);
                }
            }
            modelChanged = true;
            ++i;
        }
        if (modelChanged) {
            this.fireModelChanged();
        }
    }

    private String getCanonicalPath(File f) {
        String s = null;
        try {
            s = f.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }
}

