/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.proeditor;

import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.IIDLKeyword;
import com.rsi.idldt.core.dom.IIDLParameter;
import com.rsi.idldt.core.dom.IIDLRoutine;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.preferences.IDLdocPrefPage;
import com.rsi.idldt.proeditor.ProContextType;
import com.rsi.idldt.proeditor.ProDocumentTemplateContext;
import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.ui.UIPlugin;
import com.rsi.idldt.ui.UIPreferenceManager;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class AddIDLDocStubOperation
implements IWorkspaceRunnable {
    private static final String HOARKY = "_9q`Y_";
    private IIDLRoutine m_routine;
    private IIDLCompilationUnit m_compilationUnit;

    public AddIDLDocStubOperation(IDOMNode node) {
        if (node.getElementType() == 1) {
            this.m_compilationUnit = (IIDLCompilationUnit)node;
        } else {
            this.m_routine = (IIDLRoutine)node;
        }
    }

    protected TemplateVar locateTemplateVariable(String template) {
        int ioffset = template.indexOf("${");
        if (ioffset == -1) {
            return null;
        }
        int iend = 0;
        int i = ioffset + 2;
        while (i < template.length()) {
            if (template.charAt(i) == '}') {
                iend = i;
                break;
            }
            ++i;
        }
        if (iend == 0) {
            return null;
        }
        String value = template.substring(ioffset + 2, iend);
        TemplateVar var = new TemplateVar(ioffset, iend - ioffset, value);
        return var;
    }

    protected String substituteValue(TemplateVar var, String theTemplate, String value) {
        int istart = var.getOffset();
        int iend = istart + var.getLength();
        String template = String.valueOf(theTemplate.substring(0, istart)) + value + theTemplate.substring(iend + 1);
        return template;
    }

    private String getRoutineParameters(IIDLRoutine routine, String lineDelimiter) {
        IIDLParameter[] parameters = routine.getParameters();
        String nl = lineDelimiter;
        StringBuffer sb = new StringBuffer();
        if (parameters != null && parameters.length > 0) {
            sb.append(":Params:");
            int i = 0;
            while (i < parameters.length) {
                sb.append(String.valueOf(nl) + ";    " + parameters[i].getElementName());
                ++i;
            }
        }
        return sb.toString();
    }

    private String getRoutineKeywords(IIDLRoutine routine, String lineDelimiter) {
        IIDLKeyword[] keywords = routine.getKeywords();
        String nl = lineDelimiter;
        StringBuffer sb = new StringBuffer();
        if (keywords != null && keywords.length > 0) {
            sb.append(":Keywords:");
            int i = 0;
            while (i < keywords.length) {
                sb.append(String.valueOf(nl) + ";    " + keywords[i].getElementName());
                ++i;
            }
        }
        return sb.toString();
    }

    private String evaluateVariable(TemplateVar var, String theTemplate, String lineDelimiter) {
        String varName = var.getName();
        String template = theTemplate;
        if (varName.equals("file")) {
            IIDLCompilationUnit cu = this.m_routine != null ? (IIDLCompilationUnit)this.m_routine.getParent() : this.m_compilationUnit;
            template = this.substituteValue(var, template, cu.getDOMFile().getCanonicalPath());
        } else if (varName.equals("date")) {
            Date date = new Date();
            String strDate = DateFormat.getDateInstance().format(date);
            template = this.substituteValue(var, template, strDate);
        } else if (varName.equals("time")) {
            Date date = new Date();
            String strDate = DateFormat.getTimeInstance().format(date);
            template = this.substituteValue(var, template, strDate);
        } else if (varName.equals("year")) {
            Calendar calendar = Calendar.getInstance();
            String strDate = Integer.toString(calendar.get(1));
            template = this.substituteValue(var, template, strDate);
        } else if (varName.equals("user")) {
            String strUser = System.getProperty("user.name");
            template = this.substituteValue(var, template, strUser);
        } else if (varName.equals("routine_name")) {
            String rname = this.m_routine != null ? this.m_routine.getRoutineName() : " ";
            template = this.substituteValue(var, template, rname);
        } else if (varName.equals("parameters")) {
            String value = this.m_routine != null ? this.getRoutineParameters(this.m_routine, lineDelimiter) : " ";
            template = this.substituteValue(var, template, value);
        } else if (varName.equals("keywords")) {
            String value = this.m_routine != null ? this.getRoutineKeywords(this.m_routine, lineDelimiter) : " ";
            template = this.substituteValue(var, template, value);
        } else {
            String value = template.substring(var.getOffset(), var.getOffset() + var.getLength() + 1);
            value = String.valueOf(value.substring(0, 1)) + HOARKY + value.substring(1);
            template = this.substituteValue(var, template, value);
        }
        return template;
    }

    private String evaluateTemplateVariables(String theTemplate, String lineDelimiter) {
        String template = theTemplate;
        TemplateVar var = this.locateTemplateVariable(template);
        while (var != null) {
            template = this.evaluateVariable(var, template, lineDelimiter);
            var = this.locateTemplateVariable(template);
        }
        template = template.replaceAll(HOARKY, "");
        return template;
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchWindow wbw = UIPlugin.getActiveWorkbenchWindow();
        if (wbw == null) {
            return null;
        }
        IWorkbenchPage activePage = wbw.getActivePage();
        if (activePage == null) {
            return null;
        }
        return activePage.getActiveEditor();
    }

    protected IDocument getActiveDocument() {
        IEditorPart activeEditor = this.getActiveEditor();
        IDocument document = null;
        if (activeEditor instanceof ProEditor) {
            ProEditor proEditor = (ProEditor)activeEditor;
            IEditorInput input = proEditor.getEditorInput();
            IDocumentProvider docProvider = proEditor.getDocumentProvider();
            document = docProvider.getDocument((Object)input);
        }
        return document;
    }

    protected String getIndentationString() {
        IPreferenceStore ps;
        boolean useSpaces;
        IEditorPart activeEditor = this.getActiveEditor();
        int tabWidth = 4;
        if (activeEditor instanceof ProEditor) {
            tabWidth = ((ProEditor)activeEditor).getTabWidth();
        }
        if (useSpaces = (ps = UIPreferenceManager.getPreferenceStore()).getBoolean("IDLDT_SPACES_FOR_TABS")) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < tabWidth) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        return "\t";
    }

    protected String indentTemplate(String template) {
        String is = this.getIndentationString();
        StringBuffer sb = new StringBuffer();
        sb.append(is);
        int i = 0;
        while (i < template.length()) {
            char ch = template.charAt(i);
            if (ch != '\n') {
                sb.append(ch);
            } else {
                sb.append(ch);
                sb.append(is);
            }
            ++i;
        }
        return sb.toString();
    }

    private String createRoutineComment(String lineDelimiter) {
        String template = IDLdocPrefPage.getRoutineTemplate();
        template = this.evaluateTemplateVariables(template, lineDelimiter);
        if (!IDLdocPrefPage.getRoutineCommentInsertionPosition().equals("above")) {
            template = this.indentTemplate(template);
        }
        return template;
    }

    private String createFileComment(String lineDelimiter) {
        String template = IDLdocPrefPage.getFileTemplate();
        return this.evaluateTemplateVariables(template, lineDelimiter);
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void run(IProgressMonitor theMonitor) throws CoreException, OperationCanceledException {
        IProgressMonitor monitor = theMonitor;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (this.m_routine == null && this.m_compilationUnit == null) {
            return;
        }
        try {
            monitor.beginTask(Messages.AddIDLDocStubOperation_AddIDLDocComments, 1);
            this.addIDLdocComments(monitor);
        }
        finally {
            monitor.done();
        }
    }

    private String getLineStringFromDocument(IDocument doc, int lineNum) throws BadLocationException {
        IRegion line_info = doc.getLineInformation(lineNum);
        String line = doc.get(line_info.getOffset(), line_info.getLength()).trim();
        return line;
    }

    private int computeOffsetForCommentInsertion(IDocument doc, String lineDelim) {
        int offsetForCommentInsertion;
        if (this.m_routine != null) {
            offsetForCommentInsertion = this.m_routine.getSourceRange().getOffset();
            if (!IDLdocPrefPage.getRoutineCommentInsertionPosition().equals("above")) {
                try {
                    int lineNum;
                    int endLine;
                    block10: {
                        int startLine = doc.getLineOfOffset(this.m_routine.getSourceRange().getOffset());
                        endLine = doc.getLineOfOffset(this.m_routine.getSourceRange().getOffset() + this.m_routine.getSourceRange().getLength());
                        lineNum = startLine;
                        try {
                            String lineStr = this.getLineStringFromDocument(doc, lineNum);
                            if (!lineStr.endsWith("$")) break block10;
                            ++lineNum;
                            while (lineNum <= endLine) {
                                lineStr = this.getLineStringFromDocument(doc, lineNum);
                                if (lineStr.endsWith("$") || lineStr.startsWith(";") || lineStr.length() == 0) {
                                    ++lineNum;
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            --lineNum;
                        }
                    }
                    if (lineNum > endLine) {
                        lineNum = endLine;
                    }
                    IRegion line_info = doc.getLineInformation(lineNum);
                    offsetForCommentInsertion = line_info.getOffset() + line_info.getLength();
                    offsetForCommentInsertion += lineDelim.length();
                }
                catch (BadLocationException badLocationException) {}
            }
        } else {
            offsetForCommentInsertion = 0;
        }
        return offsetForCommentInsertion;
    }

    private void addIDLdocComments(IProgressMonitor monitor) throws CoreException {
        IEditorPart editor;
        IDocument document = this.getActiveDocument();
        if (document == null) {
            return;
        }
        String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        String comment = null;
        comment = this.m_routine != null ? this.createRoutineComment(lineDelim) : this.createFileComment(lineDelim);
        if (comment == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(";+").append(lineDelim);
            buf.append("; ").append(lineDelim);
            buf.append(";-").append(lineDelim);
            comment = buf.toString();
        }
        if (!comment.endsWith(lineDelim)) {
            comment = String.valueOf(comment) + lineDelim;
        }
        if ((editor = this.getActiveEditor()) instanceof ProEditor) {
            ProEditor pro_editor = (ProEditor)editor;
            int offset = this.computeOffsetForCommentInsertion(document, lineDelim);
            ProContextType type = new ProContextType();
            ProDocumentTemplateContext context = new ProDocumentTemplateContext(type, document, offset, 0);
            Template template = new Template("idldoc", "idldoc description", "com.rsi.idldt.proeditor.ProDocumentTemplateContext", comment, true);
            Region region = new Region(offset, 0);
            TemplateProposal p = new TemplateProposal(template, (TemplateContext)context, (IRegion)region, null, 90);
            int stateMask = 0;
            char trigger = '\u0000';
            p.apply(pro_editor.getViewer(), trigger, stateMask, offset);
            Point selection = p.getSelection(document);
            pro_editor.setHighlightRange(selection.x, 0, true);
        }
        monitor.worked(1);
    }

    class TemplateVar {
        int m_offset;
        int m_length;
        String m_value;

        TemplateVar(int offset, int length, String value) {
            this.m_offset = offset;
            this.m_length = length;
            this.m_value = value;
        }

        public String getName() {
            return this.m_value;
        }

        public int getOffset() {
            return this.m_offset;
        }

        public int getLength() {
            return this.m_length;
        }
    }
}

