/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.preferences.controls;

import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.preferences.IPrefPageControl;
import com.rsi.idldt.ui.UIPreferenceManager;
import com.rsi.jdml.PlatformSupport;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PPC_WindowLayout
implements IPrefPageControl {
    protected String[] prefName;
    protected String[] labelText;
    Button button;
    Text widthText;
    Text heightText;
    private Composite sizeBase;
    private int numCols = 4;
    private String[] initialValue;
    private boolean[] initialValueFlag;
    boolean setFlag;

    public PPC_WindowLayout() {
        String platform = PlatformSupport.isWindows() ? "WIN" : "X";
        this.prefName = new String[]{"IDL_GR_" + platform + "_QSCREEN", "IDL_GR_" + platform + "_WIDTH", "IDL_GR_" + platform + "_HEIGHT"};
        this.labelText = new String[]{Messages.PPC_WindowLayout_QScreenSize, Messages.PPC_WindowLayout_Width, Messages.PPC_WindowLayout_Height, Messages.PPC_WindowLayout_DefaultSize};
        this.initialValue = new String[this.prefName.length];
        this.initialValueFlag = new boolean[this.prefName.length];
        int i = 0;
        while (i < this.initialValueFlag.length) {
            this.initialValueFlag[i] = false;
            ++i;
        }
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        base.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        base.setLayout((Layout)gridLayout);
        Label label = new Label(base, 0);
        label.setText(this.labelText[3]);
        this.sizeBase = new Composite(base, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 20;
        this.sizeBase.setLayout((Layout)gridLayout);
        data = new GridData();
        data.horizontalAlignment = 4;
        this.sizeBase.setLayoutData((Object)data);
        Composite widthBase = new Composite(this.sizeBase, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        widthBase.setLayout((Layout)gridLayout);
        this.widthText = new Text(widthBase, 2052);
        data = new GridData();
        data.horizontalAlignment = 16384;
        data.grabExcessHorizontalSpace = false;
        GC gc = new GC((Drawable)this.widthText);
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        data.widthHint = this.widthText.computeSize((int)(this.numCols * fm.getAverageCharWidth()), (int)this.widthText.getLineHeight()).x;
        this.widthText.setTextLimit(this.numCols);
        this.widthText.setLayoutData((Object)data);
        Label widthLabel = new Label(widthBase, 0);
        widthLabel.setText(this.labelText[1]);
        Composite heightBase = new Composite(this.sizeBase, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        heightBase.setLayout((Layout)gridLayout);
        this.heightText = new Text(heightBase, 2052);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        gc = new GC((Drawable)this.heightText);
        fm = gc.getFontMetrics();
        gc.dispose();
        data.widthHint = this.heightText.computeSize((int)(this.numCols * fm.getAverageCharWidth()), (int)this.heightText.getLineHeight()).x;
        this.heightText.setTextLimit(this.numCols);
        this.heightText.setLayoutData((Object)data);
        Label heightLabel = new Label(heightBase, 0);
        heightLabel.setText(this.labelText[2]);
        this.button = new Button(this.sizeBase, 32);
        this.button.setText(this.labelText[0]);
        this.button.addSelectionListener((SelectionListener)new ButtonListener());
        this.widthText.addVerifyListener((VerifyListener)new TextVerifyListener());
        this.heightText.addVerifyListener((VerifyListener)new TextVerifyListener());
    }

    public String[] getPrefName() {
        String currentValue;
        String[] names = new String[this.prefName.length];
        int i = 0;
        while (i < names.length) {
            names[i] = "";
            ++i;
        }
        int pos = 0;
        String string = currentValue = this.button.getSelection() ? "1" : "0";
        if (!this.initialValueFlag[pos] || !currentValue.equals(this.initialValue[pos])) {
            names[pos] = this.prefName[pos];
        }
        pos = 1;
        currentValue = this.widthText.getText();
        if (!this.initialValueFlag[pos] || !currentValue.equals(this.initialValue[pos])) {
            names[pos] = this.prefName[pos];
        }
        pos = 2;
        currentValue = this.heightText.getText();
        if (!this.initialValueFlag[pos] || !currentValue.equals(this.initialValue[pos])) {
            names[pos] = this.prefName[pos];
        }
        return names;
    }

    public void setValue(Object[] value) {
        if (value == null || value.length != this.prefName.length) {
            return;
        }
        try {
            this.button.setSelection(Integer.parseInt((String)value[0]) != 0);
            if (!this.initialValueFlag[0]) {
                this.initialValue[0] = this.button.getSelection() ? "1" : "0";
                this.initialValueFlag[0] = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.button.setSelection(false);
        }
        this.setFlag = true;
        if (value[1] == null) {
            this.widthText.setText("");
        } else {
            this.widthText.setText((String)value[1]);
            if (!this.initialValueFlag[1]) {
                this.initialValue[1] = this.widthText.getText();
                this.initialValueFlag[1] = true;
            }
        }
        this.setFlag = false;
        this.setFlag = true;
        if (value[2] == null) {
            this.heightText.setText("");
        } else {
            this.heightText.setText((String)value[2]);
            if (!this.initialValueFlag[2]) {
                this.initialValue[2] = this.heightText.getText();
                this.initialValueFlag[2] = true;
            }
        }
        this.setFlag = false;
        boolean selected = this.button.getSelection();
        this.widthText.setEnabled(!selected);
        this.heightText.setEnabled(!selected);
    }

    public String[] getValue() {
        String QScreenVal = this.button.getSelection() ? "1" : "0";
        String wVal = this.widthText.getText();
        String hVal = this.heightText.getText();
        return new String[]{QScreenVal, wVal, hVal};
    }

    public void performOk() {
        String QScreenVal = this.button.getSelection() ? "1" : "0";
        UIPreferenceManager.getPreferenceStore().setValue(this.prefName[0], QScreenVal);
        this.initialValue[0] = QScreenVal;
        this.initialValueFlag[0] = true;
        String wVal = this.widthText.getText();
        UIPreferenceManager.getPreferenceStore().setValue(this.prefName[1], wVal);
        this.initialValue[1] = wVal;
        this.initialValueFlag[1] = true;
        String hVal = this.heightText.getText();
        UIPreferenceManager.getPreferenceStore().setValue(this.prefName[2], hVal);
        this.initialValue[2] = hVal;
        this.initialValueFlag[2] = true;
    }

    public void performDefaults() {
        this.setFlag = true;
        int i = UIPreferenceManager.getPreferenceStore().getDefaultInt(this.prefName[0]);
        this.button.setSelection(i != 0);
        String str = UIPreferenceManager.getPreferenceStore().getDefaultString(this.prefName[1]);
        this.widthText.setText(str);
        str = UIPreferenceManager.getPreferenceStore().getDefaultString(this.prefName[2]);
        this.heightText.setText(str);
        this.setFlag = false;
        boolean selected = this.button.getSelection();
        this.widthText.setEnabled(!selected);
        this.heightText.setEnabled(!selected);
    }

    class ButtonListener
    implements SelectionListener {
        ButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            boolean selected = PPC_WindowLayout.this.button.getSelection();
            PPC_WindowLayout.this.widthText.setEnabled(!selected);
            PPC_WindowLayout.this.heightText.setEnabled(!selected);
        }
    }

    class TextVerifyListener
    implements VerifyListener {
        TextVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            if (PPC_WindowLayout.this.setFlag) {
                return;
            }
            if (e.character >= '0' && e.character <= '9') {
                return;
            }
            if (e.character == '\b' || e.character == '\u007f') {
                return;
            }
            e.doit = false;
        }
    }
}

