/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.preferences.controls;

import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.preferences.IPrefPageControl;
import com.rsi.idldt.preferences.PPC_Path;
import com.rsi.idldt.ui.UIPreferenceManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PPC_IDLPaths
implements IPrefPageControl {
    private String[] prefNames;
    private String[] prefs = new String[]{"IDL_PATH", "IDL_DLM_PATH", "IDL_HELP_PATH"};
    Combo combo;
    PPC_Path path;
    private String[] initialValue;
    String[] currentValue;
    private boolean[] initialValueFlag;
    int currentPos = -1;

    public PPC_IDLPaths() {
        this.prefNames = new String[]{Messages.PPC_IDLPaths_IDLPath, Messages.PPC_IDLPaths_DLMPath, Messages.PPC_IDLPaths_HelpPath};
        this.currentValue = new String[this.prefs.length];
        this.initialValue = new String[this.prefs.length];
        this.initialValueFlag = new boolean[this.prefs.length];
        int i = 0;
        while (i < this.initialValueFlag.length) {
            this.currentValue[i] = "";
            this.initialValue[i] = "";
            this.initialValueFlag[i] = false;
            ++i;
        }
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        base.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        base.setLayoutData((Object)data);
        Label label = new Label(base, 0);
        label.setText(Messages.PPC_IDLPaths_SelectPath);
        this.combo = new Combo(base, 2056);
        this.combo.setItems(this.prefNames);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.combo.setLayoutData((Object)data);
        this.combo.select(0);
        this.currentPos = 0;
        this.path = new PPC_Path(base, "<IDL_DEFAULT>");
        this.combo.addSelectionListener((SelectionListener)new ComboListener());
    }

    public String[] getPrefName() {
        if (this.currentPos != -1) {
            this.currentValue[this.currentPos] = this.path.getValue()[0];
        }
        String[] names = new String[this.prefs.length];
        int i = 0;
        while (i < names.length) {
            names[i] = this.initialValueFlag[i] && this.currentValue[i].equals(this.initialValue[i]) ? "" : this.prefs[i];
            ++i;
        }
        return names;
    }

    private void setInitialValue() {
        int i = 0;
        while (i < this.prefs.length) {
            this.initialValue[i] = this.currentValue[i];
            this.initialValueFlag[i] = true;
            ++i;
        }
    }

    public void setValue(Object[] value) {
        if (value == null || value.length != this.prefs.length) {
            return;
        }
        int i = 0;
        while (i < this.prefs.length) {
            if (value[i] != null) {
                this.currentValue[i] = (String)value[i];
            }
            ++i;
        }
        if (!this.initialValueFlag[0]) {
            this.setInitialValue();
        }
        if (this.currentPos != -1) {
            this.path.setValue(new String[]{this.currentValue[this.currentPos]});
        } else {
            this.path.setValue(null);
        }
    }

    public String[] getValue() {
        if (this.currentPos != -1) {
            this.currentValue[this.currentPos] = this.path.getValue()[0];
        }
        return this.currentValue;
    }

    public void performOk() {
        if (this.currentPos != -1) {
            this.currentValue[this.currentPos] = this.path.getValue()[0];
        }
        int i = 0;
        while (i < this.prefs.length) {
            UIPreferenceManager.getPreferenceStore().setValue(this.prefs[i], this.currentValue[i]);
            ++i;
        }
        this.setInitialValue();
    }

    public void performDefaults() {
        int i = 0;
        while (i < this.prefs.length) {
            this.currentValue[i] = UIPreferenceManager.getPreferenceStore().getDefaultString(this.prefs[i]);
            ++i;
        }
        if (this.currentPos != -1) {
            this.path.setValue(new String[]{this.currentValue[this.currentPos]});
        }
    }

    class ComboListener
    implements SelectionListener {
        ComboListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            PPC_IDLPaths.this.currentValue[PPC_IDLPaths.this.currentPos] = PPC_IDLPaths.this.path.getValue()[0];
            PPC_IDLPaths.this.currentPos = PPC_IDLPaths.this.combo.getSelectionIndex();
            if (PPC_IDLPaths.this.currentPos != -1) {
                PPC_IDLPaths.this.path.setValue(new String[]{PPC_IDLPaths.this.currentValue[PPC_IDLPaths.this.currentPos]});
            }
        }
    }
}

