/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.preferences.controls;

import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.preferences.ColorButton;
import com.rsi.idldt.preferences.IPrefPageControl;
import com.rsi.idldt.ui.UIPreferenceManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class PPC_CommandLineBackgroundColor
implements IPrefPageControl {
    ColorButton colorButton;
    Button useBackgroundButton;
    private IPreferenceStore prefStore;

    public void createControl(Composite parent) {
        this.prefStore = UIPreferenceManager.getPreferenceStore();
        Composite base = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        base.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        base.setLayoutData((Object)data);
        Label label = new Label(base, 16384);
        label.setText(Messages.PrefPage_BackgroundColor);
        this.colorButton = new ColorButton(base, 0x1000000);
        this.colorButton.setColor(PreferenceConverter.getColor((IPreferenceStore)this.prefStore, (String)"IDLDT_COMMAND_LINE_BACKGROUND_COLOR"));
        this.colorButton.addListener(13, new ColorButtonListener());
        this.useBackgroundButton = new Button(base, 32);
        data = new GridData();
        data.horizontalIndent = 5;
        this.useBackgroundButton.setLayoutData((Object)data);
        this.useBackgroundButton.setText(Messages.PrefPage_UseSystemDefault);
        this.useBackgroundButton.setSelection(this.prefStore.getBoolean("IDLDT_COMMAND_LINE_USE_DEFAULT_BGCOLOR"));
        this.useBackgroundButton.addListener(13, (Listener)new UseBackgroundButtonListener());
        this.colorButton.setEnabled(!this.useBackgroundButton.getSelection());
    }

    public void performDefaults() {
        boolean val = this.prefStore.getDefaultBoolean("IDLDT_COMMAND_LINE_USE_DEFAULT_BGCOLOR");
        this.useBackgroundButton.setSelection(val);
        this.colorButton.setColor(PreferenceConverter.getDefaultColor((IPreferenceStore)this.prefStore, (String)"IDLDT_COMMAND_LINE_BACKGROUND_COLOR"));
        this.colorButton.setEnabled(!val);
    }

    public void performOk() {
        this.prefStore.setValue("IDLDT_COMMAND_LINE_USE_DEFAULT_BGCOLOR", this.useBackgroundButton.getSelection());
        PreferenceConverter.setValue((IPreferenceStore)this.prefStore, (String)"IDLDT_COMMAND_LINE_BACKGROUND_COLOR", (RGB)this.colorButton.getRGB());
    }

    public String[] getPrefName() {
        return new String[]{""};
    }

    public String[] getValue() {
        return null;
    }

    public void setValue(Object[] value) {
    }

    class ColorButtonListener
    implements Listener {
        ColorButtonListener() {
        }

        public void handleEvent(Event event) {
            ColorDialog clrDlg = new ColorDialog(PPC_CommandLineBackgroundColor.this.colorButton.getShell());
            clrDlg.setRGB(PPC_CommandLineBackgroundColor.this.colorButton.getRGB());
            RGB rgb = clrDlg.open();
            if (rgb != null) {
                PPC_CommandLineBackgroundColor.this.colorButton.setColor(rgb);
            }
        }
    }

    class UseBackgroundButtonListener
    implements Listener {
        UseBackgroundButtonListener() {
        }

        public void handleEvent(Event event) {
            boolean useSysDef = PPC_CommandLineBackgroundColor.this.useBackgroundButton.getSelection();
            PPC_CommandLineBackgroundColor.this.colorButton.setEnabled(!useSysDef);
        }
    }
}

