/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.preferences;

import com.rsi.idldt.preferences.IDLdocPrefPageCompletionProcessor;
import com.rsi.idldt.proeditor.ProDocAutoIndentStrategy;
import com.rsi.idldt.proeditor.pro.ProCodeScanner;
import com.rsi.idldt.ui.UIPreferenceManager;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;

public class SyntaxColorSourceViewerConfiguration
extends SourceViewerConfiguration {
    private ProCodeScanner m_scanner;
    ContentAssistant m_assistant;
    private boolean m_bContentAssistIDLdocFileTagsOnly = false;
    private boolean m_enableAutoInsert = true;

    public SyntaxColorSourceViewerConfiguration(ProCodeScanner scanner) {
        this.m_scanner = scanner;
    }

    public SyntaxColorSourceViewerConfiguration(ProCodeScanner scanner, boolean bFileTagsOnly) {
        this.m_scanner = scanner;
        this.m_bContentAssistIDLdocFileTagsOnly = bFileTagsOnly;
    }

    public void enableContentAssistAutoInsert(boolean value) {
        this.m_enableAutoInsert = value;
        if (this.m_assistant != null) {
            this.m_assistant.enableAutoInsert(value);
        }
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.m_scanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.m_scanner);
        reconciler.setDamager((IPresentationDamager)dr, "pro_code");
        reconciler.setRepairer((IPresentationRepairer)dr, "pro_code");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        this.m_assistant = new ContentAssistant();
        IDLdocPrefPageCompletionProcessor processor = new IDLdocPrefPageCompletionProcessor(this.m_bContentAssistIDLdocFileTagsOnly);
        if (this.m_bContentAssistIDLdocFileTagsOnly) {
            processor.setIDLdocFindFlags(1);
        } else {
            processor.setIDLdocFindFlags(2);
        }
        this.m_assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        this.m_assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "pro_code");
        this.m_assistant.enableAutoActivation(true);
        this.m_assistant.setAutoActivationDelay(500);
        this.m_assistant.setProposalPopupOrientation(21);
        this.m_assistant.setContextInformationPopupOrientation(21);
        this.m_assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        this.m_assistant.enableAutoInsert(this.m_enableAutoInsert);
        return this.m_assistant;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new ProDocAutoIndentStrategy()};
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter());
            }
        };
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return UIPreferenceManager.getPreferenceStore().getInt("IDLDT_TAB_WIDTH");
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        String[] indentPrefixes = this.getIndentPrefixesForTab(this.getTabWidth(sourceViewer));
        if (indentPrefixes == null) {
            return null;
        }
        int length = indentPrefixes.length;
        if (length > 2 && UIPreferenceManager.getPreferenceStore().getBoolean("IDLDT_SPACES_FOR_TABS")) {
            String first = indentPrefixes[0];
            indentPrefixes[0] = indentPrefixes[length - 2];
            indentPrefixes[length - 2] = first;
        }
        return indentPrefixes;
    }
}

