/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.preferences;

import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.preferences.ColorButton;
import com.rsi.idldt.preferences.SyntaxColorSourceViewerConfiguration;
import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.proeditor.ProEditorServices;
import com.rsi.idldt.proeditor.pro.ProCodeScanner;
import com.rsi.idldt.proeditor.utils.ProColorProvider;
import com.rsi.idldt.proeditor.utils.ProEditorUtilities;
import com.rsi.idldt.ui.UIPlugin;
import com.rsi.idldt.ui.UIPreferenceManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class SyntaxColorPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static String SAMPLE_CODE = null;
    private IPreferenceStore prefStore;
    IPreferenceStore tmpPS;
    private List ElementList;
    ColorButton cButton;
    ColorButton cBGButton;
    Button useBGColor;
    Button boldButton;
    Button italicButton;
    ColorButton eBGButton;
    Button eUseBGColor;
    SourceViewer m_viewer;
    ProCodeScanner m_scanner;
    ProColorProvider m_provider;
    StyledText text;
    private ProEditor editor = new ProEditor();
    private IPreferenceStore editorPrefStore = this.editor.getPrefStore();
    private Button defButton;

    public SyntaxColorPrefPage() {
    }

    public SyntaxColorPrefPage(String title) {
        super(title);
    }

    public SyntaxColorPrefPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite base = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.rsi.idldt.ui.preferences_syntax_color");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        base.setLayout((Layout)gridLayout);
        Label eLabel = new Label(base, 0);
        eLabel.setText(Messages.SyntaxColorPrefPage_Element);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        eLabel.setLayoutData((Object)data);
        this.ElementList = new List(base, 2816);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.ElementList.setLayoutData((Object)data);
        String[] colorNames = UIPreferenceManager.getChromacodeNames();
        int i = 0;
        while (i < colorNames.length) {
            this.ElementList.add(colorNames[i]);
            ++i;
        }
        this.ElementList.addListener(13, (Listener)new ElementListListener());
        this.ElementList.addKeyListener((KeyListener)new ElementListKeyListener());
        String[] chromacodeIds = UIPreferenceManager.getChromacodeIds();
        this.tmpPS = new PreferenceStore();
        int i2 = 0;
        while (i2 < colorNames.length) {
            RGB color = PreferenceConverter.getDefaultColor((IPreferenceStore)this.prefStore, (String)chromacodeIds[i2]);
            RGB bgColor = PreferenceConverter.getDefaultColor((IPreferenceStore)this.prefStore, (String)(String.valueOf(chromacodeIds[i2]) + "_BACKGROUND"));
            boolean useBG = this.prefStore.getDefaultBoolean(String.valueOf(chromacodeIds[i2]) + "_BACKGROUND_USE_DEFAULT");
            int style = this.prefStore.getDefaultInt(String.valueOf(chromacodeIds[i2]) + "_FONTSTYLE");
            PreferenceConverter.setDefault((IPreferenceStore)this.tmpPS, (String)chromacodeIds[i2], (RGB)color);
            PreferenceConverter.setDefault((IPreferenceStore)this.tmpPS, (String)(String.valueOf(chromacodeIds[i2]) + "_BACKGROUND"), (RGB)bgColor);
            this.tmpPS.setDefault(String.valueOf(chromacodeIds[i2]) + "_BACKGROUND_USE_DEFAULT", useBG);
            this.tmpPS.setDefault(String.valueOf(chromacodeIds[i2]) + "_FONTSTYLE", style);
            color = PreferenceConverter.getColor((IPreferenceStore)this.prefStore, (String)chromacodeIds[i2]);
            bgColor = PreferenceConverter.getColor((IPreferenceStore)this.prefStore, (String)(String.valueOf(chromacodeIds[i2]) + "_BACKGROUND"));
            useBG = this.prefStore.getBoolean(String.valueOf(chromacodeIds[i2]) + "_BACKGROUND_USE_DEFAULT");
            style = this.prefStore.getInt(String.valueOf(chromacodeIds[i2]) + "_FONTSTYLE");
            PreferenceConverter.setValue((IPreferenceStore)this.tmpPS, (String)chromacodeIds[i2], (RGB)color);
            PreferenceConverter.setValue((IPreferenceStore)this.tmpPS, (String)(String.valueOf(chromacodeIds[i2]) + "_BACKGROUND"), (RGB)bgColor);
            this.tmpPS.setValue(String.valueOf(chromacodeIds[i2]) + "_BACKGROUND_USE_DEFAULT", useBG);
            this.tmpPS.setValue(String.valueOf(chromacodeIds[i2]) + "_FONTSTYLE", style);
            ++i2;
        }
        Composite colBase = new Composite(base, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        colBase.setLayout((Layout)gridLayout);
        data = new GridData();
        data.verticalAlignment = 128;
        data.horizontalAlignment = 4;
        colBase.setLayoutData((Object)data);
        Composite rowBase = new Composite(colBase, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        rowBase.setLayout((Layout)gridLayout);
        Label label = new Label(rowBase, 0x1000000);
        label.setText(Messages.SyntaxColorPrefPage_Color);
        this.cButton = new ColorButton(rowBase, 0x1000000);
        this.cButton.setEnabled(false);
        this.cButton.setColor(128, 128, 128);
        this.cButton.addListener(13, new ColorButtonListener("", this.cButton));
        Label bg_label = new Label(rowBase, 0x1000000);
        bg_label.setText(Messages.PrefPage_BackgroundColor);
        this.cBGButton = new ColorButton(rowBase, 0x1000000);
        this.cBGButton.setEnabled(false);
        this.cBGButton.setColor(128, 128, 128);
        this.cBGButton.addListener(13, new ColorButtonListener("_BACKGROUND", this.cBGButton));
        Composite bgBase = new Composite(rowBase, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        bgBase.setLayout((Layout)gridLayout);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        bgBase.setLayoutData((Object)data);
        this.useBGColor = new Button(bgBase, 32);
        this.useBGColor.setText(Messages.SyntaxColorPrefPage_UseEditorBackgroundColor);
        this.useBGColor.setEnabled(false);
        this.useBGColor.addListener(13, (Listener)new UseBGButtonListener());
        Composite ButtonBase = new Composite(colBase, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        fillLayout.spacing = 2;
        ButtonBase.setLayout((Layout)fillLayout);
        this.boldButton = new Button(ButtonBase, 32);
        this.boldButton.setText(Messages.SyntaxColorPrefPage_Bold);
        this.italicButton = new Button(ButtonBase, 32);
        this.italicButton.setText(Messages.SyntaxColorPrefPage_Italic);
        this.boldButton.setEnabled(false);
        this.italicButton.setEnabled(false);
        this.boldButton.addListener(13, (Listener)new FontButtonListener());
        this.italicButton.addListener(13, (Listener)new FontButtonListener());
        Composite editorBGbase = new Composite(base, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        editorBGbase.setLayout((Layout)gridLayout);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        editorBGbase.setLayoutData((Object)data);
        Label ebgLabel = new Label(editorBGbase, 0);
        ebgLabel.setText(Messages.SyntaxColorPrefPage_EditorBackgroundColor);
        this.eBGButton = new ColorButton(editorBGbase, 0x1000000);
        this.eBGButton.setColor(PreferenceConverter.getColor((IPreferenceStore)this.editorPrefStore, (String)"AbstractTextEditor.Color.Background"));
        this.eBGButton.addListener(13, new EditorColorButtonListener());
        this.eUseBGColor = new Button(editorBGbase, 32);
        data = new GridData();
        data.horizontalIndent = 5;
        this.eUseBGColor.setLayoutData((Object)data);
        this.eUseBGColor.setText(Messages.PrefPage_UseSystemDefault);
        this.eUseBGColor.setSelection(this.editorPrefStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault"));
        this.eUseBGColor.addListener(13, (Listener)new EditorUseBGButtonListener());
        this.eBGButton.setEnabled(!this.eUseBGColor.getSelection());
        Label pLabel = new Label(base, 0);
        pLabel.setText(Messages.SyntaxColorPrefPage_Preview);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        pLabel.setLayoutData((Object)data);
        this.m_viewer = new SourceViewer(base, null, 2560);
        this.m_viewer.setDocument((IDocument)new Document());
        this.m_provider = new ProColorProvider(this.tmpPS);
        this.m_scanner = new ProCodeScanner(this.m_provider);
        SyntaxColorSourceViewerConfiguration m_sourceViewerConfig = new SyntaxColorSourceViewerConfiguration(this.m_scanner);
        this.m_viewer.configure((SourceViewerConfiguration)m_sourceViewerConfig);
        this.text = this.m_viewer.getTextWidget();
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        this.text.setFont(JFaceResources.getTextFont());
        GC gc = new GC((Drawable)this.text);
        gc.setFont(this.text.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        data.heightHint = 9 * fontMetrics.getHeight();
        this.text.setLayoutData((Object)data);
        this.setPreviewText(this.text);
        this.defButton = new Button(base, 0);
        this.defButton.setSize(1, 1);
        this.defButton.setVisible(false);
        this.defButton.getShell().setDefaultButton(this.defButton);
        return base;
    }

    private void initSampleCode() {
        Path p;
        if (SAMPLE_CODE != null) {
            return;
        }
        Bundle bundle = Platform.getBundle((String)"com.rsi.idldt.ui");
        URL url = FileLocator.find((Bundle)bundle, (IPath)(p = new Path("$nl$/templates/syntaxcolor_samplecode.pro")), null);
        if (url != null) {
            StringBuffer sb = new StringBuffer();
            try {
                String line;
                InputStream stream = url.openStream();
                InputStreamReader isr = new InputStreamReader(stream, "UTF8");
                LineNumberReader lnr = new LineNumberReader(isr);
                while ((line = lnr.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
                lnr.close();
                isr.close();
                stream.close();
            }
            catch (IOException iOException) {}
            if (sb.length() > 0) {
                SAMPLE_CODE = sb.toString();
            }
        }
        if (SAMPLE_CODE == null) {
            SAMPLE_CODE = "pro test\nend\n";
        }
    }

    public void init(IWorkbench workbench) {
        this.prefStore = UIPreferenceManager.getPreferenceStore();
        this.initSampleCode();
    }

    public void dispose() {
        if (this.m_provider != null) {
            this.m_provider.dispose();
        }
        super.dispose();
    }

    String getCurrentSelectionId() {
        int currentSelection = this.ElementList.getSelectionIndex();
        String[] chromacodeIds = UIPreferenceManager.getChromacodeIds();
        if (currentSelection >= 0) {
            return chromacodeIds[currentSelection];
        }
        return "";
    }

    void updatePreview() {
        this.m_scanner.updateTokens();
        this.m_viewer.invalidateTextPresentation();
        this.text.redraw();
        this.text.update();
    }

    public boolean performOk() {
        String[] chromacodeIds = UIPreferenceManager.getChromacodeIds();
        int i = 0;
        while (i < chromacodeIds.length) {
            RGB color = PreferenceConverter.getColor((IPreferenceStore)this.tmpPS, (String)chromacodeIds[i]);
            RGB bgColor = PreferenceConverter.getColor((IPreferenceStore)this.tmpPS, (String)(String.valueOf(chromacodeIds[i]) + "_BACKGROUND"));
            boolean useDefault = this.tmpPS.getBoolean(String.valueOf(chromacodeIds[i]) + "_BACKGROUND_USE_DEFAULT");
            int style = this.tmpPS.getInt(String.valueOf(chromacodeIds[i]) + "_FONTSTYLE");
            PreferenceConverter.setValue((IPreferenceStore)this.prefStore, (String)chromacodeIds[i], (RGB)color);
            PreferenceConverter.setValue((IPreferenceStore)this.prefStore, (String)(String.valueOf(chromacodeIds[i]) + "_BACKGROUND"), (RGB)bgColor);
            this.prefStore.setValue(String.valueOf(chromacodeIds[i]) + "_BACKGROUND_USE_DEFAULT", useDefault);
            this.prefStore.setValue(String.valueOf(chromacodeIds[i]) + "_FONTSTYLE", style);
            ++i;
        }
        PreferenceConverter.setValue((IPreferenceStore)this.editorPrefStore, (String)"AbstractTextEditor.Color.Background", (RGB)this.eBGButton.getRGB());
        this.editorPrefStore.setValue("AbstractTextEditor.Color.Background.SystemDefault", this.eUseBGColor.getSelection());
        ProCodeScanner scanner = ProEditorServices.getProCodeScanner();
        if (scanner != null) {
            scanner.updateTokens();
        }
        ProEditorUtilities.refreshEditors();
        UIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        String[] chromacodeIds = UIPreferenceManager.getChromacodeIds();
        int i = 0;
        while (i < chromacodeIds.length) {
            this.tmpPS.setToDefault(chromacodeIds[i]);
            this.tmpPS.setToDefault(String.valueOf(chromacodeIds[i]) + "_BACKGROUND");
            this.tmpPS.setToDefault(String.valueOf(chromacodeIds[i]) + "_BACKGROUND_USE_DEFAULT");
            this.tmpPS.setToDefault(String.valueOf(chromacodeIds[i]) + "_FONTSTYLE");
            ++i;
        }
        new ElementListListener().handleEvent(new Event());
        this.text.setBackground(null);
        this.eBGButton.setEnabled(false);
        this.eBGButton.setColor(255, 255, 255);
        this.eUseBGColor.setSelection(true);
        this.updatePreview();
    }

    private void setPreviewText(StyledText text1) {
        text1.setText(SAMPLE_CODE);
        text1.setBackground(this.eUseBGColor.getSelection() ? null : this.eBGButton.getColor());
    }

    private class ColorButtonListener
    implements Listener {
        private String m_suffix;
        private ColorButton colButton;

        public ColorButtonListener(String idSuffix, ColorButton cButtonIn) {
            this.m_suffix = idSuffix;
            this.colButton = cButtonIn;
        }

        public void handleEvent(Event event) {
            ColorDialog clrDlg = new ColorDialog(this.colButton.getShell());
            clrDlg.setRGB(this.colButton.getRGB());
            RGB rgb = clrDlg.open();
            if (rgb != null) {
                this.colButton.setColor(rgb);
                PreferenceConverter.setValue((IPreferenceStore)SyntaxColorPrefPage.this.tmpPS, (String)(String.valueOf(SyntaxColorPrefPage.this.getCurrentSelectionId()) + this.m_suffix), (RGB)rgb);
                SyntaxColorPrefPage.this.updatePreview();
            }
        }
    }

    class EditorColorButtonListener
    implements Listener {
        EditorColorButtonListener() {
        }

        public void handleEvent(Event event) {
            ColorDialog clrDlg = new ColorDialog(SyntaxColorPrefPage.this.eBGButton.getShell());
            clrDlg.setRGB(SyntaxColorPrefPage.this.eBGButton.getRGB());
            RGB rgb = clrDlg.open();
            if (rgb != null) {
                SyntaxColorPrefPage.this.eBGButton.setColor(rgb);
                if (!SyntaxColorPrefPage.this.eUseBGColor.getSelection()) {
                    SyntaxColorPrefPage.this.text.setBackground(SyntaxColorPrefPage.this.eBGButton.getColor());
                }
            }
        }
    }

    class EditorUseBGButtonListener
    implements Listener {
        EditorUseBGButtonListener() {
        }

        public void handleEvent(Event event) {
            boolean useSysDef = SyntaxColorPrefPage.this.eUseBGColor.getSelection();
            SyntaxColorPrefPage.this.eBGButton.setEnabled(!useSysDef);
            SyntaxColorPrefPage.this.text.setBackground(useSysDef ? null : SyntaxColorPrefPage.this.eBGButton.getColor());
        }
    }

    class ElementListKeyListener
    extends KeyAdapter {
        ElementListKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.character == '\r') {
                new ColorButtonListener("", SyntaxColorPrefPage.this.cButton).handleEvent(new Event());
            }
        }
    }

    class ElementListListener
    implements Listener {
        ElementListListener() {
        }

        public void handleEvent(Event event) {
            String id = SyntaxColorPrefPage.this.getCurrentSelectionId();
            SyntaxColorPrefPage.this.cButton.setEnabled(id.length() > 0);
            SyntaxColorPrefPage.this.useBGColor.setEnabled(id.length() > 0);
            SyntaxColorPrefPage.this.cBGButton.setEnabled(false);
            SyntaxColorPrefPage.this.boldButton.setEnabled(id.length() > 0);
            SyntaxColorPrefPage.this.italicButton.setEnabled(id.length() > 0);
            if (id.length() > 0) {
                RGB color = PreferenceConverter.getColor((IPreferenceStore)SyntaxColorPrefPage.this.tmpPS, (String)id);
                RGB bgColor = PreferenceConverter.getColor((IPreferenceStore)SyntaxColorPrefPage.this.tmpPS, (String)(String.valueOf(id) + "_BACKGROUND"));
                boolean useDefault = SyntaxColorPrefPage.this.tmpPS.getBoolean(String.valueOf(id) + "_BACKGROUND_USE_DEFAULT");
                int style = SyntaxColorPrefPage.this.tmpPS.getInt(String.valueOf(id) + "_FONTSTYLE");
                SyntaxColorPrefPage.this.cButton.setColor(color);
                SyntaxColorPrefPage.this.useBGColor.setSelection(useDefault);
                SyntaxColorPrefPage.this.cBGButton.setColor(bgColor);
                SyntaxColorPrefPage.this.cBGButton.setEnabled(!useDefault);
                SyntaxColorPrefPage.this.boldButton.setSelection((style & 1) != 0);
                SyntaxColorPrefPage.this.italicButton.setSelection((style & 2) != 0);
            } else {
                SyntaxColorPrefPage.this.cButton.setColor(128, 128, 128);
                SyntaxColorPrefPage.this.boldButton.setSelection(false);
                SyntaxColorPrefPage.this.italicButton.setSelection(false);
            }
        }
    }

    class FontButtonListener
    implements Listener {
        FontButtonListener() {
        }

        public void handleEvent(Event event) {
            int style = (SyntaxColorPrefPage.this.boldButton.getSelection() ? 1 : 0) | (SyntaxColorPrefPage.this.italicButton.getSelection() ? 2 : 0);
            SyntaxColorPrefPage.this.tmpPS.setValue(String.valueOf(SyntaxColorPrefPage.this.getCurrentSelectionId()) + "_FONTSTYLE", style);
            SyntaxColorPrefPage.this.updatePreview();
        }
    }

    class UseBGButtonListener
    implements Listener {
        UseBGButtonListener() {
        }

        public void handleEvent(Event event) {
            boolean useDefault = SyntaxColorPrefPage.this.useBGColor.getSelection();
            SyntaxColorPrefPage.this.cBGButton.setEnabled(!useDefault);
            SyntaxColorPrefPage.this.tmpPS.setValue(String.valueOf(SyntaxColorPrefPage.this.getCurrentSelectionId()) + "_BACKGROUND_USE_DEFAULT", useDefault);
            SyntaxColorPrefPage.this.updatePreview();
        }
    }
}

