/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.preferences;

import com.rsi.idldt.preferences.IPrefPageControl;
import com.rsi.idldt.ui.UIPreferenceManager;
import java.util.ArrayList;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PPC_Radio
implements IPrefPageControl {
    protected String prefName = "";
    protected String labelText = "";
    protected Composite radioBase;
    private int initialValue;
    private boolean initialValueFlag = false;
    private ArrayList<Button> m_radioButtonList = new ArrayList();

    public void createControl(Composite parent) {
        if (this.labelText.length() > 0) {
            Label label = new Label(parent, 0);
            label.setText(this.labelText);
        }
        this.radioBase = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 10;
        this.radioBase.setLayout((Layout)rowLayout);
    }

    public void performDefaults() {
        String s = UIPreferenceManager.getPreferenceStore().getDefaultString(this.prefName);
        int index = 0;
        try {
            index = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {}
        this.select(index);
    }

    public void performOk() {
        int pos = this.getSelectionIndex();
        if (pos != -1) {
            UIPreferenceManager.getPreferenceStore().setValue(this.prefName, pos);
            this.setInitialValue();
        }
    }

    public String[] getPrefName() {
        int currentValue = this.getSelectionIndex();
        if (this.initialValueFlag && currentValue == this.initialValue) {
            return new String[]{""};
        }
        return new String[]{this.prefName};
    }

    public String[] getValue() {
        String val = Integer.toString(this.getSelectionIndex());
        return new String[]{val};
    }

    private void setInitialValue() {
        this.initialValue = this.getSelectionIndex();
        this.initialValueFlag = true;
    }

    public void setValue(Object[] value) {
        if (value == null) {
            int val = UIPreferenceManager.getPreferenceStore().getInt(this.prefName);
            this.select(val);
            return;
        }
        try {
            this.select(Integer.parseInt((String)value[0]));
        }
        catch (NumberFormatException numberFormatException) {
            this.select(0);
        }
        if (!this.initialValueFlag) {
            this.setInitialValue();
        }
    }

    protected Button createRadioButton(Composite parent, String text) {
        Button button = new Button(parent, 16);
        button.setText(text);
        this.m_radioButtonList.add(button);
        return button;
    }

    private int getSelectionIndex() {
        if (this.m_radioButtonList == null) {
            return -1;
        }
        int i = 0;
        while (i < this.m_radioButtonList.size()) {
            Button button = this.m_radioButtonList.get(i);
            if (button != null && button.getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void select(int index) {
        if (this.m_radioButtonList == null) {
            return;
        }
        int i = 0;
        while (i < this.m_radioButtonList.size()) {
            Button button = this.m_radioButtonList.get(i);
            if (button != null) {
                button.setSelection(i == index);
            }
            ++i;
        }
    }
}

