/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.preferences;

import com.rsi.idldt.core.utils.Tracer;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.preferences.IPrefPageControl;
import com.rsi.idldt.ui.UIPreferenceManager;
import com.rsi.jdml.PlatformSupport;
import java.io.File;
import java.io.FileFilter;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PPC_Path
implements IPrefPageControl {
    protected String prefName = "";
    protected String labelText = "";
    String defaultValue = "";
    Table table;
    private TableEditor editor;
    private Button insert;
    private Button insertDefault;
    private Button remove;
    private Button moveUp;
    private Button moveDown;
    private Button expand;
    private String currentInsertDir = "";
    private boolean hasDefault = false;
    private Vector<Integer> expandFlag = new Vector(10, 10);

    public PPC_Path() {
    }

    public PPC_Path(String defaultIn) {
        this.defaultValue = defaultIn;
    }

    public PPC_Path(Composite parent) {
        this.createControl(parent);
    }

    public PPC_Path(Composite parent, String defaultIn) {
        this.defaultValue = defaultIn;
        this.createControl(parent);
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = ((GridLayout)base.getParent().getLayout()).numColumns;
        base.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        base.setLayout((Layout)gridLayout);
        this.table = new Table(base, 2850);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 200;
        this.table.setLayoutData((Object)data);
        this.table.addSelectionListener((SelectionListener)new TableListener());
        this.table.addKeyListener((KeyListener)new TableKeyListener());
        Composite OuterButtonBase = new Composite(base, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        OuterButtonBase.setLayout((Layout)gridLayout);
        data = new GridData();
        data.verticalAlignment = 128;
        OuterButtonBase.setLayoutData((Object)data);
        Composite ButtonBase = new Composite(OuterButtonBase, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        fillLayout.spacing = 1;
        ButtonBase.setLayout((Layout)fillLayout);
        this.insert = new Button(ButtonBase, 8);
        this.insert.setText(Messages.PPC_Path_Insert);
        this.insert.setEnabled(true);
        this.insert.addSelectionListener((SelectionListener)new InsertListener());
        if (this.defaultValue != "") {
            this.insertDefault = new Button(ButtonBase, 8);
            this.insertDefault.setText(Messages.PPC_Path_InsertDefault);
            this.insertDefault.setEnabled(true);
            this.insertDefault.addSelectionListener((SelectionListener)new InsertDefaultListener());
        }
        this.remove = new Button(ButtonBase, 8);
        this.remove.setText(Messages.PPC_Path_Remove);
        this.remove.setEnabled(true);
        this.remove.addSelectionListener((SelectionListener)new RemoveListener());
        Label junk = new Label(ButtonBase, 258);
        junk.setVisible(false);
        this.moveUp = new Button(ButtonBase, 8);
        this.moveUp.setText(Messages.PPC_Path_MoveUp);
        this.moveUp.setEnabled(true);
        this.moveUp.addSelectionListener((SelectionListener)new MoveUpListener());
        this.moveDown = new Button(ButtonBase, 8);
        this.moveDown.setText(Messages.PPC_Path_MoveDown);
        this.moveDown.setEnabled(true);
        this.moveDown.addSelectionListener((SelectionListener)new MoveDownListener());
        this.expand = new Button(ButtonBase, 8);
        this.expand.setText(Messages.PPC_Path_Expand);
        this.expand.setEnabled(true);
        this.expand.addSelectionListener((SelectionListener)new ExpandListener());
        Label label = new Label(base, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = ((GridLayout)label.getParent().getLayout()).numColumns;
        label.setLayoutData((Object)data);
        label.setText(Messages.PPC_Path_IncludeSubdirs);
        this.editor = new TableEditor(this.table);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
    }

    public void performDefaults() {
        String def = UIPreferenceManager.getPreferenceStore().getDefaultString(this.prefName);
        this.setValue(new String[]{def});
    }

    public void performOk() {
        UIPreferenceManager.getPreferenceStore().setValue(this.prefName, this.getValue()[0]);
    }

    public String[] getPrefName() {
        return new String[]{this.prefName};
    }

    public String[] getValue() {
        String s = "";
        String separator = PlatformSupport.isWindows() ? ";" : ":";
        TableItem[] tableItems = this.table.getItems();
        int i = 0;
        while (i < tableItems.length) {
            s = String.valueOf(s) + (tableItems[i].getChecked() && !tableItems[i].getGrayed() ? "+" : "") + tableItems[i].getText() + (i < tableItems.length - 1 ? separator : "");
            ++i;
        }
        return new String[]{s};
    }

    public void setValue(Object[] value) {
        this.table.setRedraw(false);
        this.table.removeAll();
        this.hasDefault = false;
        if (value == null) {
            return;
        }
        int prevPos = 0;
        int pos = 0;
        Vector<String> pathItems = new Vector<String>(10);
        String s = (String)value[0];
        int separator = 59;
        pos = s.indexOf(separator);
        if (pos == -1 && !Platform.getOS().equals("win32")) {
            separator = 58;
            pos = 0;
        }
        while (pos != -1) {
            pos = s.indexOf(separator, prevPos);
            if (pos == -1) continue;
            pathItems.add(s.substring(prevPos, pos));
            prevPos = pos + 1;
        }
        if (prevPos < s.length()) {
            pathItems.add(s.substring(prevPos));
        }
        int i = 0;
        while (i < pathItems.size()) {
            String name = (String)pathItems.get(i);
            if (name.length() >= 1) {
                TableItem item = new TableItem(this.table, 0);
                boolean plus = name.substring(0, 1).equals("+");
                item.setText(plus ? name.substring(1) : name);
                item.setChecked(plus);
            }
            ++i;
        }
        this.table.setRedraw(true);
        this.updateButtons();
    }

    public void setPrefName(String s) {
        this.prefName = s;
    }

    public void setDefaultValue(String s) {
        this.defaultValue = s;
    }

    void updateButtons() {
        this.updateButtons(true);
    }

    private void updateButtons(boolean clearExpandedFlag) {
        int[] indices = this.table.getSelectionIndices();
        TableItem[] selectedItems = this.table.getSelection();
        TableItem[] items = this.table.getItems();
        this.hasDefault = false;
        int i = 0;
        while (i < items.length) {
            String name = items[i].getText();
            if (name.equalsIgnoreCase(this.defaultValue)) {
                items[i].setChecked(true);
                items[i].setGrayed(true);
                this.hasDefault = true;
            } else {
                items[i].setGrayed(false);
            }
            ++i;
        }
        this.insertDefault.setEnabled(!this.hasDefault);
        boolean removable = indices.length != 0;
        this.remove.setEnabled(removable);
        boolean[] selected = new boolean[this.table.getItemCount()];
        int i2 = 0;
        while (i2 < selected.length) {
            selected[i2] = false;
            ++i2;
        }
        i2 = 0;
        while (i2 < indices.length) {
            selected[indices[i2]] = true;
            ++i2;
        }
        boolean moveUpable = false;
        int i3 = selected.length - 1;
        while (i3 > 0) {
            if (selected[i3] && !selected[i3 - 1]) {
                moveUpable = true;
                break;
            }
            --i3;
        }
        this.moveUp.setEnabled(moveUpable);
        boolean moveDownable = false;
        int i4 = 0;
        while (i4 < selected.length - 1) {
            if (selected[i4] && !selected[i4 + 1]) {
                moveDownable = true;
                break;
            }
            ++i4;
        }
        this.moveDown.setEnabled(moveDownable);
        boolean expandable = false;
        int i5 = 0;
        while (i5 < selectedItems.length) {
            if (!selectedItems[i5].getText().equalsIgnoreCase(this.defaultValue) && selectedItems[i5].getChecked()) {
                expandable = true;
                break;
            }
            ++i5;
        }
        this.expand.setEnabled(expandable);
        if (clearExpandedFlag) {
            this.expandFlag.clear();
        }
    }

    void handleEditCell() {
        TableItem[] items;
        if (this.table.isDisposed()) {
            return;
        }
        Control oldControl = this.editor.getEditor();
        if (oldControl != null && !oldControl.isDisposed()) {
            oldControl.dispose();
        }
        if ((items = this.table.getSelection()).length == 0) {
            return;
        }
        final TableItem item = items[0];
        if (item == null) {
            return;
        }
        final Composite borderControl = new Composite((Composite)this.table, 2048);
        GridData data = new GridData(4, 4, true, true);
        borderControl.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        borderControl.setLayout((Layout)layout);
        final Text text = new Text(borderControl, 4);
        data = new GridData(4, 4, true, true);
        text.setLayoutData((Object)data);
        text.setText(item.getText());
        Listener textListener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 16: {
                        item.setText(text.getText());
                        PPC_Path.this.updateButtons();
                        borderControl.dispose();
                        break;
                    }
                    case 31: {
                        switch (e.detail) {
                            case 4: {
                                item.setText(text.getText());
                                PPC_Path.this.updateButtons();
                            }
                            case 2: {
                                borderControl.dispose();
                                e.doit = false;
                            }
                        }
                    }
                }
            }
        };
        text.addListener(16, textListener);
        text.addListener(31, textListener);
        text.selectAll();
        text.setFocus();
        this.editor.setEditor((Control)borderControl, item, 0);
    }

    void insertRoutine() {
        DirectoryDialog dialog = new DirectoryDialog(this.insert.getShell());
        dialog.setText(Messages.PPC_DirectoryBrowse_TitleSelectDirectory);
        dialog.setMessage(Messages.PPC_DirectoryBrowse_MessageSelectDirectory);
        dialog.setFilterPath(this.currentInsertDir);
        String path = dialog.open();
        if (path != null) {
            this.currentInsertDir = path;
            int[] indices = this.table.getSelectionIndices();
            if (indices.length == 0) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(this.currentInsertDir);
                this.table.setSelection(this.table.getItemCount() - 1);
            } else {
                int max = 0;
                int i = 0;
                while (i < indices.length) {
                    if (indices[i] > max) {
                        max = indices[i];
                    }
                    ++i;
                }
                TableItem item = new TableItem(this.table, 0, max + 1);
                item.setText(this.currentInsertDir);
                this.table.setSelection(max + 1);
            }
            this.updateButtons();
        }
    }

    void removeRoutine() {
        if (this.table.getItemCount() == 0) {
            return;
        }
        if (this.expandFlag.size() != 0) {
            int[] indices = this.table.getSelectionIndices();
            if (indices.length != 0) {
                this.table.remove(indices);
            }
            int[] sel = new int[this.expandFlag.size()];
            int i = 0;
            while (i < sel.length) {
                sel[i] = this.expandFlag.get(i);
                ++i;
            }
            this.table.setSelection(sel);
            TableItem[] items = this.table.getSelection();
            int i2 = 0;
            while (i2 < items.length) {
                items[i2].setChecked(true);
                ++i2;
            }
            this.expandFlag.clear();
        } else {
            int[] indices = this.table.getSelectionIndices();
            if (indices.length != 0) {
                TableItem[] selectedItems = this.table.getSelection();
                int i = 0;
                while (i < selectedItems.length) {
                    if (selectedItems[i].getText().equalsIgnoreCase(this.defaultValue)) {
                        this.hasDefault = false;
                    }
                    ++i;
                }
                this.table.remove(indices);
                if (indices[0] < this.table.getItemCount()) {
                    this.table.setSelection(indices[0]);
                } else {
                    this.table.setSelection(this.table.getItemCount() - 1);
                }
            }
        }
        this.updateButtons();
    }

    void moveUpRoutine() {
        if (this.table.getItemCount() == 0) {
            return;
        }
        this.table.setRedraw(false);
        boolean[] moveable = new boolean[this.table.getItemCount()];
        int i = 0;
        while (i < moveable.length) {
            moveable[i] = true;
            ++i;
        }
        int[] indices = this.table.getSelectionIndices();
        int[] newSelection = new int[indices.length];
        boolean[] toMove = new boolean[this.table.getItemCount()];
        int i2 = 0;
        while (i2 < toMove.length) {
            toMove[i2] = false;
            ++i2;
        }
        i2 = 0;
        while (i2 < indices.length) {
            toMove[indices[i2]] = true;
            ++i2;
        }
        int[] currentOrder = new int[this.table.getItemCount()];
        int i3 = 0;
        while (i3 < currentOrder.length) {
            currentOrder[i3] = i3;
            ++i3;
        }
        TableItem[] items = this.table.getItems();
        if (indices[0] == 0) {
            moveable[0] = false;
        }
        int cnt = 0;
        int i4 = 0;
        while (i4 < currentOrder.length) {
            if (toMove[i4]) {
                if (i4 != 0 && moveable[i4 - 1]) {
                    int tempPos = currentOrder[i4];
                    currentOrder[i4] = currentOrder[i4 - 1];
                    currentOrder[i4 - 1] = tempPos;
                    newSelection[cnt++] = i4 - 1;
                } else {
                    moveable[i4] = false;
                    newSelection[cnt++] = i4;
                }
            }
            ++i4;
        }
        String[] text = new String[currentOrder.length];
        boolean[] checked = new boolean[currentOrder.length];
        int i5 = 0;
        while (i5 < currentOrder.length) {
            text[i5] = items[i5].getText();
            checked[i5] = items[i5].getChecked();
            ++i5;
        }
        i5 = 0;
        while (i5 < currentOrder.length) {
            items[i5].setText(text[currentOrder[i5]]);
            items[i5].setChecked(checked[currentOrder[i5]]);
            ++i5;
        }
        this.table.setSelection(newSelection);
        this.table.setRedraw(true);
        this.updateButtons();
    }

    void moveDownRoutine() {
        if (this.table.getItemCount() == 0) {
            return;
        }
        this.table.setRedraw(false);
        boolean[] moveable = new boolean[this.table.getItemCount()];
        int i = 0;
        while (i < moveable.length) {
            moveable[i] = true;
            ++i;
        }
        int[] indices = this.table.getSelectionIndices();
        int[] newSelection = new int[indices.length];
        boolean[] toMove = new boolean[this.table.getItemCount()];
        int i2 = 0;
        while (i2 < toMove.length) {
            toMove[i2] = false;
            ++i2;
        }
        i2 = 0;
        while (i2 < indices.length) {
            toMove[indices[i2]] = true;
            ++i2;
        }
        int[] currentOrder = new int[this.table.getItemCount()];
        int i3 = 0;
        while (i3 < currentOrder.length) {
            currentOrder[i3] = i3;
            ++i3;
        }
        TableItem[] items = this.table.getItems();
        int bottom = indices.length - 1;
        if (indices[bottom] == 0) {
            moveable[bottom] = false;
        }
        int cnt = 0;
        int i4 = currentOrder.length - 1;
        while (i4 >= 0) {
            if (toMove[i4]) {
                if (i4 != currentOrder.length - 1 && moveable[i4 + 1]) {
                    int tempPos = currentOrder[i4];
                    currentOrder[i4] = currentOrder[i4 + 1];
                    currentOrder[i4 + 1] = tempPos;
                    newSelection[cnt++] = i4 + 1;
                } else {
                    moveable[i4] = false;
                    newSelection[cnt++] = i4;
                }
            }
            --i4;
        }
        String[] text = new String[currentOrder.length];
        boolean[] checked = new boolean[currentOrder.length];
        int i5 = 0;
        while (i5 < currentOrder.length) {
            text[i5] = items[i5].getText();
            checked[i5] = items[i5].getChecked();
            ++i5;
        }
        i5 = 0;
        while (i5 < currentOrder.length) {
            items[i5].setText(text[currentOrder[i5]]);
            items[i5].setChecked(checked[currentOrder[i5]]);
            ++i5;
        }
        this.table.setSelection(newSelection);
        this.table.setRedraw(true);
        this.updateButtons();
    }

    void expandRoutine() {
        int[] indices = this.table.getSelectionIndices();
        if (indices.length == 0) {
            return;
        }
        this.table.setRedraw(false);
        TableItem[] items = this.table.getItems();
        boolean tableChanged = false;
        this.table.deselectAll();
        this.expandFlag.clear();
        int offset = 0;
        int i = 0;
        while (i < indices.length) {
            if (items[indices[i]].getChecked() && !items[indices[i]].getText().equalsIgnoreCase(this.defaultValue)) {
                this.expandFlag.add(new Integer(indices[i]));
                File file = new File(items[indices[i]].getText());
                File[] dirs = file.listFiles(new MyDirFilter());
                if (dirs != null) {
                    int j = 0;
                    while (j < dirs.length) {
                        TableItem item = new TableItem(this.table, 0, indices[i] + j + 1 + offset);
                        item.setText(dirs[j].getAbsolutePath());
                        item.setChecked(true);
                        this.table.select(indices[i] + j + 1 + offset);
                        ++j;
                    }
                    items[indices[i]].setChecked(false);
                    tableChanged = true;
                    offset += dirs.length;
                }
            }
            ++i;
        }
        if (!tableChanged) {
            this.table.setSelection(indices);
        }
        this.table.setRedraw(true);
        this.updateButtons(false);
    }

    class ExpandListener
    implements SelectionListener {
        ExpandListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            PPC_Path.this.expandRoutine();
        }
    }

    class InsertDefaultListener
    implements SelectionListener {
        InsertDefaultListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            TableItem item;
            int[] indices = PPC_Path.this.table.getSelectionIndices();
            if (indices.length == 0) {
                item = new TableItem(PPC_Path.this.table, 0);
                PPC_Path.this.table.setSelection(PPC_Path.this.table.getItemCount() - 1);
            } else {
                int max = 0;
                int i = 0;
                while (i < indices.length) {
                    if (indices[i] > max) {
                        max = indices[i];
                    }
                    ++i;
                }
                item = new TableItem(PPC_Path.this.table, 0, max + 1);
                PPC_Path.this.table.setSelection(max + 1);
            }
            item.setText(PPC_Path.this.defaultValue);
            PPC_Path.this.updateButtons();
        }
    }

    class InsertListener
    implements SelectionListener {
        InsertListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            PPC_Path.this.insertRoutine();
        }
    }

    class MoveDownListener
    implements SelectionListener {
        MoveDownListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            PPC_Path.this.moveDownRoutine();
        }
    }

    class MoveUpListener
    implements SelectionListener {
        MoveUpListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            PPC_Path.this.moveUpRoutine();
        }
    }

    class MyDirFilter
    implements FileFilter {
        MyDirFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }

    class RemoveListener
    implements SelectionListener {
        RemoveListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            PPC_Path.this.removeRoutine();
        }
    }

    class TableKeyListener
    implements KeyListener {
        TableKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.character == '\u007f') {
                PPC_Path.this.removeRoutine();
            }
            if (e.keyCode == 0x1000001 && e.stateMask == SWT.MOD1) {
                PPC_Path.this.moveUpRoutine();
            }
            if (e.keyCode == 0x1000002 && e.stateMask == SWT.MOD1) {
                PPC_Path.this.moveDownRoutine();
            }
            if (e.keyCode == 105 && e.stateMask == SWT.MOD1) {
                PPC_Path.this.insertRoutine();
            }
            if (e.keyCode == 101 && e.stateMask == SWT.MOD1) {
                PPC_Path.this.expandRoutine();
            }
            if (e.keyCode == 0x100000B) {
                PPC_Path.this.handleEditCell();
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    class TableListener
    implements SelectionListener {
        Object previousSelection;

        TableListener() {
        }

        private void handleCheckEvent(TableItem item) {
            TableItem[] selectedItems = PPC_Path.this.table.getSelection();
            boolean selected = false;
            int i = 0;
            while (i < selectedItems.length) {
                if (selectedItems[i].equals(item)) {
                    selected = true;
                    break;
                }
                ++i;
            }
            if (!selected) {
                if (item.getText().equalsIgnoreCase(PPC_Path.this.defaultValue)) {
                    item.setChecked(true);
                }
                return;
            }
            boolean checked = item.getChecked();
            int i2 = 0;
            while (i2 < selectedItems.length) {
                if (selectedItems[i2].getText().equalsIgnoreCase(PPC_Path.this.defaultValue)) {
                    selectedItems[i2].setChecked(true);
                } else {
                    selectedItems[i2].setChecked(checked);
                }
                ++i2;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Tracer.trace((boolean)Tracer.IS_DEBUGGING, (String)e.toString());
            if (e.detail == 32) {
                this.handleCheckEvent((TableItem)e.item);
                this.previousSelection = null;
            } else {
                TableItem[] items = PPC_Path.this.table.getSelection();
                if (items.length == 1 && items[0] == e.item) {
                    if (this.previousSelection == e.item) {
                        final Object itemToEdit = this.previousSelection;
                        Display.getCurrent().timerExec(1000, new Runnable(){

                            public void run() {
                                if (TableListener.this.previousSelection == itemToEdit) {
                                    PPC_Path.this.handleEditCell();
                                }
                            }
                        });
                    } else {
                        this.previousSelection = e.item;
                    }
                } else {
                    this.previousSelection = null;
                }
            }
            PPC_Path.this.updateButtons();
        }
    }
}

