/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.preferences;

import com.rsi.idldt.preferences.IPrefPageControl;
import com.rsi.idldt.ui.UIPreferenceManager;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class PPC_Integer
implements IPrefPageControl {
    protected String prefName = "";
    protected String labelText = "";
    protected boolean allowNegative = false;
    protected boolean allowZero = true;
    protected int numCols = -1;
    protected boolean useDefaultText = false;
    protected int defaultValue = 0;
    protected String defaultText = "0";
    protected Text text;
    boolean showingDefaultText = false;
    private String initialValue;
    private boolean initialValueFlag = false;
    boolean setFlag;
    boolean setFlagModify;

    public void createControl(Composite parent) {
        this.defaultValue = UIPreferenceManager.getPreferenceStore().getDefaultInt(this.prefName);
        Label label = new Label(parent, 0);
        label.setText(this.labelText);
        this.text = new Text(parent, 2052);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.text.setLayoutData((Object)data);
        if (this.numCols != -1) {
            data.grabExcessHorizontalSpace = false;
            data.horizontalAlignment = 16384;
            GC gc = new GC((Drawable)this.text);
            FontMetrics fm = gc.getFontMetrics();
            gc.dispose();
            data.widthHint = this.text.computeSize((int)(this.numCols * fm.getAverageCharWidth()), (int)this.text.getLineHeight()).x;
            this.text.setTextLimit(this.numCols);
        }
        this.text.addVerifyListener((VerifyListener)new TextVerifyListener());
        this.text.addModifyListener((ModifyListener)new TextModifyListener());
        this.text.addFocusListener((FocusListener)new TextFocusListener());
    }

    public void performDefaults() {
        this.setFlag = true;
        this.text.setText(Integer.toString(this.defaultValue));
        this.setFlag = false;
    }

    public void performOk() {
        int val;
        try {
            val = Integer.parseInt(this.getValue()[0]);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        UIPreferenceManager.getPreferenceStore().setValue(this.prefName, val);
        this.setInitialValue();
    }

    public String[] getPrefName() {
        String currentValue = this.text.getText();
        if (this.initialValueFlag && currentValue.equals(this.initialValue)) {
            return new String[]{""};
        }
        return new String[]{this.prefName};
    }

    public String[] getValue() {
        String val = this.showingDefaultText ? Integer.toString(this.defaultValue) : this.text.getText();
        return new String[]{val};
    }

    private void setInitialValue() {
        this.initialValue = this.text.getText();
        this.initialValueFlag = true;
    }

    public void setValue(Object[] value) {
        this.setFlag = true;
        if (value == null) {
            int val = UIPreferenceManager.getPreferenceStore().getInt(this.prefName);
            this.text.setText(Integer.toString(val));
            return;
        }
        this.text.setText((String)value[0]);
        this.setFlag = false;
        if (!this.initialValueFlag) {
            this.setInitialValue();
        }
    }

    class TextFocusListener
    implements FocusListener {
        TextFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent fe) {
            String s = PPC_Integer.this.text.getText();
            PPC_Integer.this.setFlag = true;
            try {
                int val = Integer.parseInt(PPC_Integer.this.getValue()[0]);
                if (val < 0 && !PPC_Integer.this.allowNegative) {
                    s = Integer.toString(0);
                }
                if (val == 0 && !PPC_Integer.this.allowZero) {
                    s = Integer.toString(1);
                }
                if (PPC_Integer.this.showingDefaultText) {
                    s = PPC_Integer.this.defaultText;
                }
                PPC_Integer.this.text.setText(s);
            }
            catch (NumberFormatException numberFormatException) {
                PPC_Integer.this.text.setText(PPC_Integer.this.allowZero ? "0" : "1");
            }
            PPC_Integer.this.setFlag = false;
        }
    }

    class TextModifyListener
    implements ModifyListener {
        TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (PPC_Integer.this.setFlagModify) {
                return;
            }
            String s = PPC_Integer.this.text.getText();
            try {
                int value = Integer.parseInt(s);
                if (PPC_Integer.this.useDefaultText && value == PPC_Integer.this.defaultValue) {
                    PPC_Integer.this.setFlag = true;
                    PPC_Integer.this.setFlagModify = true;
                    PPC_Integer.this.text.setText(PPC_Integer.this.defaultText);
                    PPC_Integer.this.setFlag = false;
                    PPC_Integer.this.setFlagModify = false;
                    PPC_Integer.this.showingDefaultText = true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    class TextVerifyListener
    implements VerifyListener {
        TextVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            if (PPC_Integer.this.setFlag) {
                return;
            }
            if (PPC_Integer.this.showingDefaultText) {
                PPC_Integer.this.setFlag = true;
                PPC_Integer.this.text.setText("");
                PPC_Integer.this.setFlag = false;
                PPC_Integer.this.showingDefaultText = false;
            }
            if (e.character >= '0' && e.character <= '9') {
                return;
            }
            if (e.character == '\b' || e.character == '\u007f') {
                return;
            }
            if (e.character == '-') {
                if (!PPC_Integer.this.allowNegative) {
                    e.doit = false;
                    return;
                }
                if (e.start == 0) {
                    return;
                }
            }
            e.doit = false;
        }
    }
}

