/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.preferences;

import com.rsi.idldt.preferences.IPrefPageControl;
import com.rsi.idldt.ui.UIPreferenceManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class PPC_Combo
implements IPrefPageControl {
    private String prefName = "";
    private String labelText = "";
    private Combo combo;
    private int initialValue;
    private boolean initialValueFlag = false;
    private IPreferenceStore prefStore;

    public PPC_Combo(String prefName1, String labelText1) {
        this(prefName1, labelText1, null);
    }

    public PPC_Combo(String prefName1, String labelText1, IPreferenceStore prefStore1) {
        this.prefName = prefName1;
        this.labelText = labelText1;
        this.prefStore = prefStore1 != null ? prefStore1 : UIPreferenceManager.getPreferenceStore();
    }

    public void createControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.labelText);
        this.combo = new Combo(parent, 2056);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.combo.setLayoutData((Object)data);
    }

    public void addToCombo(String item) {
        this.combo.add(item);
    }

    public void performDefaults() {
        String s = this.prefStore.getDefaultString(this.prefName);
        try {
            this.combo.select(Integer.parseInt(s));
        }
        catch (NumberFormatException numberFormatException) {
            this.combo.select(0);
        }
    }

    public void performOk() {
        int pos = this.combo.getSelectionIndex();
        if (pos != -1) {
            this.prefStore.setValue(this.prefName, pos);
            this.setInitialValue();
        }
    }

    public String[] getPrefName() {
        int currentValue = this.combo.getSelectionIndex();
        if (this.initialValueFlag && currentValue == this.initialValue) {
            return new String[]{""};
        }
        return new String[]{this.prefName};
    }

    public String[] getValue() {
        String val = Integer.toString(this.combo.getSelectionIndex());
        return new String[]{val};
    }

    private void setInitialValue() {
        this.initialValue = this.combo.getSelectionIndex();
        this.initialValueFlag = true;
    }

    public void setValue(Object[] value) {
        int val = 0;
        if (value != null) {
            try {
                val = Integer.parseInt((String)value[0]);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            val = this.prefStore.getInt(this.prefName);
        }
        this.combo.select(val);
        if (!this.initialValueFlag) {
            this.setInitialValue();
        }
    }
}

