/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.preferences;

import com.rsi.idldt.preferences.IPrefPageControl;
import com.rsi.idldt.ui.UIPreferenceManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PPC_Boolean
implements IPrefPageControl {
    protected String prefName = "";
    private String labelText = "";
    private IPreferenceStore prefStore;
    protected Button button;
    protected String parmName;
    private boolean reverseLogic = false;
    private boolean initialValue;
    private boolean initialValueFlag = false;
    PPC_Boolean[] dependents = null;
    String[] strDependents = null;

    public PPC_Boolean(String prefName1, String labelText1) {
        this(prefName1, labelText1, false, null);
    }

    public Control getControl() {
        return this.button;
    }

    public PPC_Boolean(String prefName1, String labelText1, boolean reverseLogic1) {
        this(prefName1, labelText1, reverseLogic1, null);
    }

    public PPC_Boolean(String prefName1, String labelText1, boolean reverseLogic1, IPreferenceStore prefStore1) {
        this.prefName = prefName1;
        this.labelText = labelText1;
        this.reverseLogic = reverseLogic1;
        this.prefStore = prefStore1 != null ? prefStore1 : UIPreferenceManager.getPreferenceStore();
    }

    public void setParmName(String parmName1) {
        this.parmName = parmName1;
    }

    public String getParmName() {
        return this.parmName;
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        base.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        base.setLayout((Layout)gridLayout);
        this.button = new Button(base, 32);
        this.button.setText(this.labelText);
        if (this.dependents != null) {
            this.button.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean bIsSelected = PPC_Boolean.this.button.getSelection();
                    int i = 0;
                    while (i < PPC_Boolean.this.dependents.length) {
                        PPC_Boolean.this.dependents[i].getControl().setEnabled(bIsSelected);
                        ++i;
                    }
                }
            });
        }
    }

    public void performDefaults() {
        boolean val = this.prefStore.getDefaultBoolean(this.prefName);
        this.button.setSelection(val ^ this.reverseLogic);
    }

    public void performOk() {
        this.prefStore.setValue(this.prefName, this.button.getSelection() ^ this.reverseLogic);
        this.setInitialValue();
    }

    public String[] getPrefName() {
        boolean currentValue = this.button.getSelection();
        if (this.initialValueFlag && currentValue == this.initialValue) {
            return new String[]{""};
        }
        return new String[]{this.prefName};
    }

    public String[] getValue() {
        String val = this.button.getSelection() ^ this.reverseLogic ? "1" : "0";
        return new String[]{val};
    }

    private void setInitialValue() {
        this.initialValue = this.button.getSelection();
        this.initialValueFlag = true;
    }

    public void setValue(Object[] value) {
        if (value == null) {
            boolean val = this.getPreferenceStore().getBoolean(this.prefName);
            this.button.setSelection(val);
            return;
        }
        try {
            this.button.setSelection(Integer.parseInt((String)value[0]) != 0 ^ this.reverseLogic);
        }
        catch (NumberFormatException numberFormatException) {
            this.button.setSelection(false);
        }
        if (!this.initialValueFlag) {
            this.setInitialValue();
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return this.prefStore;
    }

    public void setDependents(String[] controls) {
        this.strDependents = controls;
    }

    public String[] getStrDependents() {
        return this.strDependents;
    }

    public void setDependents(PPC_Boolean[] controls) {
        this.dependents = controls;
    }
}

