/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.preferences;

import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.preferences.SyntaxColorSourceViewerConfiguration;
import com.rsi.idldt.proeditor.pro.ProCodeScanner;
import com.rsi.idldt.proeditor.utils.ProColorProvider;
import com.rsi.idldt.ui.UIPreferenceManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TabsToSpacesConverter;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.osgi.framework.Bundle;

public class IDLdocPrefPageTemplateEditor
implements IPropertyChangeListener {
    public static final int ROUTINE_TYPE = 0;
    public static final int FILE_TYPE = 1;
    protected String INSERT_TEMPLATE_VARIABLE_TEXT = Messages.IDLdocPrefPageTemplateEditor_InsertVariable;
    private String DEFAULT_TEMPLATE;
    private IPreferenceStore m_preferenceStore;
    private SyntaxColorSourceViewerConfiguration m_sourceViewerConfig;
    private KeyStroke m_contentAssistKeyStroke = this.getContentAssistKeyStroke();
    int m_type;
    SourceViewer m_viewer;
    ProCodeScanner m_scanner;
    ProColorProvider m_provider;
    StyledText m_text;
    Button m_InsertVariableButton;
    Button m_aboveButton;
    Button m_belowButton;
    String m_routinePosition;
    Action m_cutAction;
    Action m_copyAction;
    Action m_pasteAction;
    Action m_undoAction;
    Action m_redoAction;
    Action m_selectAllAction;
    Action m_insertTemplateVariableAction;

    public IDLdocPrefPageTemplateEditor(int type) {
        this.m_type = type;
    }

    public Composite createContents(Composite parent) {
        Composite base = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        base.setLayout((Layout)gridLayout);
        this.m_viewer = new SourceViewer(base, null, 2560);
        this.m_viewer.setDocument((IDocument)new Document());
        this.m_provider = new ProColorProvider(this.m_preferenceStore);
        this.m_scanner = new ProCodeScanner(this.m_provider);
        this.m_sourceViewerConfig = this.m_type == 0 ? new SyntaxColorSourceViewerConfiguration(this.m_scanner) : new SyntaxColorSourceViewerConfiguration(this.m_scanner, true);
        this.m_viewer.configure((SourceViewerConfiguration)this.m_sourceViewerConfig);
        this.addContextMenus();
        this.m_viewer.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                IDLdocPrefPageTemplateEditor.this.handleVerifyKeyPressed(event);
            }
        });
        this.m_text = this.m_viewer.getTextWidget();
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        this.m_text.setFont(JFaceResources.getTextFont());
        this.m_text.setLayoutData((Object)data);
        this.setTemplateText(this.getTemplate());
        this.m_InsertVariableButton = new Button(base, 0);
        data = new GridData();
        this.m_InsertVariableButton.setLayoutData((Object)data);
        this.m_InsertVariableButton.setText(String.valueOf(this.INSERT_TEMPLATE_VARIABLE_TEXT) + "...");
        this.m_InsertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IDLdocPrefPageTemplateEditor.this.m_viewer.getTextWidget().setFocus();
                IDLdocPrefPageTemplateEditor.this.m_viewer.doOperation(13);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        UIPreferenceManager.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        return base;
    }

    public void enableContentAssistAutoInsert(boolean value) {
        this.m_sourceViewerConfig.enableContentAssistAutoInsert(value);
    }

    public void createAdditionalContentsOnBase(Composite base) {
        if (this.m_type == 0) {
            Composite group = new Composite(base, 0);
            group.setLayout((Layout)new RowLayout());
            Label label = new Label(group, 0);
            label.setText(String.valueOf(Messages.IDLdocPrefPageTemplateEditor_AddComments) + ": ");
            String declaration = Messages.IDLdocPrefPageTemplateEditor_Declaration;
            this.m_aboveButton = new Button(group, 16);
            this.m_aboveButton.setText(String.valueOf(Messages.IDLdocPrefPageTemplateEditor_Above) + " " + declaration);
            this.m_belowButton = new Button(group, 16);
            this.m_belowButton.setText(String.valueOf(Messages.IDLdocPrefPageTemplateEditor_Below) + " " + declaration);
            this.updateRoutinePositionRadioButtons();
        }
    }

    private void addContextMenus() {
        TextViewerUndoManager undoManager = new TextViewerUndoManager(25);
        undoManager.connect((ITextViewer)this.m_viewer);
        this.m_viewer.setUndoManager((IUndoManager)undoManager);
        this.m_undoAction = new Action(){

            public void run() {
                IDLdocPrefPageTemplateEditor.this.m_viewer.doOperation(1);
            }
        };
        this.m_undoAction.setText(Messages.IDLdocPrefPageTemplateEditor_UndoTyping);
        this.m_undoAction.setToolTipText(Messages.IDLdocPrefPageTemplateEditor_UndoTyping);
        this.m_redoAction = new Action(){

            public void run() {
                IDLdocPrefPageTemplateEditor.this.m_viewer.doOperation(2);
            }
        };
        this.m_redoAction.setText(Messages.IDLdocPrefPageTemplateEditor_RedoTyping);
        this.m_redoAction.setToolTipText(Messages.IDLdocPrefPageTemplateEditor_RedoTyping);
        this.m_cutAction = new Action(){

            public void run() {
                IDLdocPrefPageTemplateEditor.this.m_viewer.doOperation(3);
            }
        };
        this.m_cutAction.setText(Messages.CommandLineView_CutText);
        this.m_cutAction.setToolTipText(Messages.CommandLineView_CutText);
        this.m_copyAction = new Action(){

            public void run() {
                IDLdocPrefPageTemplateEditor.this.m_viewer.doOperation(4);
            }
        };
        this.m_copyAction.setText(Messages.CommandLineView_CopyText);
        this.m_copyAction.setToolTipText(Messages.CommandLineView_CopyText);
        this.m_pasteAction = new Action(){

            public void run() {
                IDLdocPrefPageTemplateEditor.this.m_viewer.doOperation(5);
            }
        };
        this.m_pasteAction.setText(Messages.CommandLineView_PasteText);
        this.m_pasteAction.setToolTipText(Messages.CommandLineView_PasteText);
        this.m_selectAllAction = new Action(){

            public void run() {
                IDLdocPrefPageTemplateEditor.this.m_viewer.doOperation(7);
            }
        };
        String text = Messages.IDLdocPrefPageTemplateEditor_SelectAll;
        this.m_selectAllAction.setText(text);
        this.m_selectAllAction.setToolTipText(text);
        this.m_insertTemplateVariableAction = new Action(){

            public void run() {
                IDLdocPrefPageTemplateEditor.this.m_viewer.doOperation(13);
            }
        };
        this.m_insertTemplateVariableAction.setText(String.valueOf(this.INSERT_TEMPLATE_VARIABLE_TEXT) + "...");
        this.m_insertTemplateVariableAction.setToolTipText(this.INSERT_TEMPLATE_VARIABLE_TEXT);
        this.m_viewer.addPostSelectionChangedListener(new ISelectionChangedListener((IUndoManager)undoManager){
            private final /* synthetic */ IUndoManager val$undoManager;
            {
                this.val$undoManager = iUndoManager;
            }

            public void selectionChanged(SelectionChangedEvent event) {
                IDLdocPrefPageTemplateEditor.this.m_undoAction.setEnabled(this.val$undoManager.undoable());
                IDLdocPrefPageTemplateEditor.this.m_redoAction.setEnabled(this.val$undoManager.redoable());
                boolean canCut = IDLdocPrefPageTemplateEditor.this.m_viewer.canDoOperation(3);
                IDLdocPrefPageTemplateEditor.this.m_cutAction.setEnabled(canCut);
                boolean canCopy = IDLdocPrefPageTemplateEditor.this.m_viewer.canDoOperation(4);
                IDLdocPrefPageTemplateEditor.this.m_copyAction.setEnabled(canCopy);
            }
        });
        this.hookContextMenu((Viewer)this.m_viewer);
    }

    private void hookContextMenu(Viewer viewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IDLdocPrefPageTemplateEditor.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.m_undoAction);
        manager.add((IAction)this.m_redoAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.m_cutAction);
        manager.add((IAction)this.m_copyAction);
        manager.add((IAction)this.m_pasteAction);
        manager.add((IAction)this.m_selectAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.m_insertTemplateVariableAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    void handleVerifyKeyPressed(VerifyEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.stateMask == this.m_contentAssistKeyStroke.getModifierKeys() && event.keyCode == this.m_contentAssistKeyStroke.getNaturalKey()) {
            this.m_viewer.doOperation(13);
            event.doit = false;
            return;
        }
        if (event.stateMask != SWT.MOD1) {
            return;
        }
        switch (event.character) {
            case '\u001a': {
                this.m_viewer.doOperation(1);
                event.doit = false;
                break;
            }
            case '\u0019': {
                this.m_viewer.doOperation(2);
                event.doit = false;
            }
        }
    }

    private String getTemplateFromPreferenceStore() {
        String template = this.m_type == 0 ? this.m_preferenceStore.getString("IDLDT_IDLDOC_ROUTINE_TEMPLATE") : this.m_preferenceStore.getString("IDLDT_IDLDOC_FILE_TEMPLATE");
        if (template.equals("default")) {
            template = this.DEFAULT_TEMPLATE;
        }
        return template;
    }

    public String getTemplate() {
        if (this.DEFAULT_TEMPLATE == null) {
            this.initDefaultTemplate();
        }
        String template = this.getTemplateFromPreferenceStore();
        return template.trim();
    }

    public String getRoutineCommentInsertionPosition() {
        if (this.m_routinePosition == null) {
            this.m_routinePosition = this.m_preferenceStore.getString("IDLDT_IDLDOC_ROUTINE_POSITION");
        }
        return this.m_routinePosition;
    }

    public void initDefaultTemplate() {
        if (this.m_preferenceStore == null) {
            this.m_preferenceStore = UIPreferenceManager.getPreferenceStore();
        }
        if (this.m_type == 0) {
            this.m_routinePosition = this.m_preferenceStore.getString("IDLDT_IDLDOC_ROUTINE_POSITION");
            this.DEFAULT_TEMPLATE = this.initDefaultTemplate("$nl$/templates/idldoc_default_routine_template.pro");
        } else {
            this.DEFAULT_TEMPLATE = this.initDefaultTemplate("$nl$/templates/idldoc_default_file_template.pro");
        }
    }

    private String initDefaultTemplate(String fileName) {
        Path p;
        StringBuffer sb = new StringBuffer();
        Bundle bundle = Platform.getBundle((String)"com.rsi.idldt.ui");
        URL url = FileLocator.find((Bundle)bundle, (IPath)(p = new Path(fileName)), null);
        if (url != null) {
            try {
                String line;
                InputStream stream = url.openStream();
                InputStreamReader isr = new InputStreamReader(stream, "UTF8");
                LineNumberReader lnr = new LineNumberReader(isr);
                while ((line = lnr.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
                lnr.close();
                isr.close();
                stream.close();
            }
            catch (IOException iOException) {}
        }
        if (sb.length() == 0) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private void updateTemplate() {
        this.m_scanner.updateTokens();
        this.m_viewer.invalidateTextPresentation();
        this.m_text.redraw();
        this.m_text.update();
    }

    private void updateRoutinePositionRadioButtons() {
        if (this.m_routinePosition.equalsIgnoreCase("above")) {
            this.m_aboveButton.setSelection(true);
            this.m_belowButton.setSelection(false);
        } else {
            this.m_aboveButton.setSelection(false);
            this.m_belowButton.setSelection(true);
        }
    }

    private void setTemplateText(String template) {
        this.m_text.setText(template);
    }

    protected String getTemplateFromSourceViewer() {
        return this.m_text.getText();
    }

    public void performOk() {
        String value = this.getTemplateFromSourceViewer();
        if (this.m_type == 0) {
            this.m_preferenceStore.setValue("IDLDT_IDLDOC_ROUTINE_TEMPLATE", value);
        } else {
            this.m_preferenceStore.setValue("IDLDT_IDLDOC_FILE_TEMPLATE", value);
        }
        if (this.m_type == 0) {
            this.m_routinePosition = this.m_aboveButton.getSelection() ? "above" : "below";
            this.m_preferenceStore.setValue("IDLDT_IDLDOC_ROUTINE_POSITION", this.m_routinePosition);
        }
    }

    public void performDefaults() {
        this.setTemplateText(this.DEFAULT_TEMPLATE);
        this.updateTemplate();
        if (this.m_type == 0) {
            this.m_routinePosition = this.m_preferenceStore.getDefaultString("IDLDT_IDLDOC_ROUTINE_POSITION");
            this.updateRoutinePositionRadioButtons();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getProperty();
        if ("IDLDT_SPACES_FOR_TABS".equals(prop)) {
            if (this.isTabsToSpacesConversionEnabled()) {
                this.installTabsToSpacesConverter();
            } else {
                this.uninstallTabsToSpacesConverter();
            }
            return;
        }
        if ("IDLDT_TAB_WIDTH".equals(prop)) {
            IPreferenceStore store = UIPreferenceManager.getPreferenceStore();
            if (store != null) {
                int topIndex = this.m_viewer.getTopIndex();
                this.m_viewer.getTextWidget().setTabs(store.getInt("IDLDT_TAB_WIDTH"));
                this.m_viewer.setTopIndex(topIndex);
            }
            if (this.isTabsToSpacesConversionEnabled()) {
                this.uninstallTabsToSpacesConverter();
                this.installTabsToSpacesConverter();
            }
            return;
        }
        this.m_scanner.updateTokens();
        this.m_viewer.invalidateTextPresentation();
        StyledText st = this.m_viewer.getTextWidget();
        if (st != null) {
            st.redraw();
            st.update();
        }
        if ("spacesForTabs".equals(prop) || "tabWidth".equals(prop)) {
            return;
        }
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        IPreferenceStore store = UIPreferenceManager.getPreferenceStore();
        return store != null ? store.getBoolean("IDLDT_SPACES_FOR_TABS") : false;
    }

    protected void installTabsToSpacesConverter() {
        SyntaxColorSourceViewerConfiguration config = this.m_sourceViewerConfig;
        if (config != null && this.m_viewer != null) {
            int tabWidth = config.getTabWidth((ISourceViewer)this.m_viewer);
            TabsToSpacesConverter tabToSpacesConverter = new TabsToSpacesConverter();
            tabToSpacesConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
            tabToSpacesConverter.setNumberOfSpacesPerTab(tabWidth);
            this.m_viewer.setTabsToSpacesConverter((IAutoEditStrategy)tabToSpacesConverter);
            this.updateIndentPrefixes();
        }
    }

    protected void uninstallTabsToSpacesConverter() {
        if (this.m_viewer != null) {
            this.m_viewer.setTabsToSpacesConverter(null);
            if (this.m_viewer.getTextWidget() != null) {
                this.updateIndentPrefixes();
            }
        }
    }

    protected final void updateIndentPrefixes() {
        SyntaxColorSourceViewerConfiguration configuration = this.m_sourceViewerConfig;
        String[] types = configuration.getConfiguredContentTypes((ISourceViewer)this.m_viewer);
        int i = 0;
        while (i < types.length) {
            String[] prefixes = configuration.getIndentPrefixes((ISourceViewer)this.m_viewer, types[i]);
            if (prefixes != null && prefixes.length > 0) {
                this.m_viewer.setIndentPrefixes(prefixes, types[i]);
            }
            ++i;
        }
    }

    protected KeyStroke getContentAssistKeyStroke() {
        KeyStroke keyStroke;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        String seq = null;
        TriggerSequence tseq = bindingService.getBestActiveBindingFor("com.rsi.idldt.ui.commands.cmdLine.ContentAssist");
        if (tseq != null) {
            seq = tseq.format();
        }
        if (seq == null) {
            seq = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        }
        if (seq == null || "(null)".equals(seq)) {
            seq = "";
        }
        try {
            keyStroke = KeyStroke.getInstance((String)seq);
        }
        catch (Exception exception) {
            try {
                keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            }
            catch (Exception exception2) {
                keyStroke = KeyStroke.getInstance((int)0x1000013);
            }
        }
        return keyStroke;
    }
}

