/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.preferences;

import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.preferences.IDLdocPrefPage;
import com.rsi.idldt.proeditor.ProTemplateProposal;
import com.rsi.idldt.proeditor.pro.ProCompletionProcessor;
import com.rsi.idldt.proeditor.pro.Proposal;
import com.rsi.idldt.proeditor.utils.ProWordPartDetector;
import java.util.TreeSet;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDLdocPrefPageCompletionProcessor
extends ProCompletionProcessor {
    boolean m_bFileTagsOnly = false;

    public IDLdocPrefPageCompletionProcessor(boolean bFileTagsOnly) {
        this.m_bFileTagsOnly = bFileTagsOnly;
    }

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] tag_proposals = new ICompletionProposal[]{};
        TreeSet<Proposal> proposalTree = new TreeSet<Proposal>();
        ProWordPartDetector wordPart = new ProWordPartDetector();
        wordPart.addAllowedChar('$');
        wordPart.addAllowedChar('{');
        wordPart.createWord(viewer, offset, false);
        this.addTemplateVariableProposals(wordPart, proposalTree);
        ICompletionProposal[] variable_proposals = this.turnProposalVectorIntoAdaptedArray(wordPart, proposalTree);
        String prefix = wordPart.getActivationPrefixChars();
        if (prefix == null || prefix.trim().length() == 0 || prefix.equals(":") || prefix.equals(";")) {
            tag_proposals = super.computeCompletionProposals(viewer, offset);
        }
        int numTotalProps = tag_proposals.length + variable_proposals.length;
        ICompletionProposal[] final_proposals = new ICompletionProposal[numTotalProps];
        if (tag_proposals.length > 0) {
            System.arraycopy(tag_proposals, 0, final_proposals, 0, tag_proposals.length);
        }
        if (variable_proposals.length > 0) {
            System.arraycopy(variable_proposals, 0, final_proposals, tag_proposals.length, variable_proposals.length);
        }
        boolean bAutoInsert = true;
        if (final_proposals.length == 1 && final_proposals[0].getClass() == ProTemplateProposal.class) {
            ProTemplateProposal prop = (ProTemplateProposal)final_proposals[0];
            bAutoInsert = prop.getProposalsTemplate().isAutoInsertable();
            String info = prop.getAdditionalProposalInfo();
            System.out.println(info);
        }
        IDLdocPrefPage.enableContentAssistAutoInsert(bAutoInsert);
        return final_proposals;
    }

    @Override
    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'$', ':'};
    }

    protected void addTemplateVariableProposals(ProWordPartDetector wordPart, TreeSet<Proposal> proposalTree) {
        String token = wordPart.getString().toLowerCase().trim();
        String[] doctags = new String[]{"${file}", "${date}", "${time}", "${year}", "${user}", "${cursor}", "${dollar}", "${parameters}", "${keywords}", "${routine_name}"};
        int i = 0;
        while (i < doctags.length) {
            if (this.m_bFileTagsOnly && i > 6) break;
            if (token.length() == 0 || doctags[i].startsWith(token)) {
                Proposal p = new Proposal(doctags[i], 110, Messages.IDLdocPrefPageCompletionProcessor_TemplateVariable);
                proposalTree.add(p);
            }
            ++i;
        }
    }
}

