/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.preferences;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessListener;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.interp.AbstractIDLCommand;
import com.rsi.idldt.preferences.IDLCorePrefCommandSet;
import com.rsi.idldt.ui.UIPreferenceManager;
import org.eclipse.jface.preference.IPreferenceStore;

public class IDLCorePreferences
implements IIDLProcessListener {
    public volatile boolean finishedFlag;

    public IDLCorePreferences() {
        IDLProcessManager.addProcessListener((IIDLProcessListener)this);
        this.handleActivatedProcess(IDLProcessManager.getActiveProcess());
    }

    public void updatePreferences() {
        IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
        if (idl == null) {
            return;
        }
        this.finishedFlag = false;
        if (idl.isIdle()) {
            IDLCorePrefCommandSet cSet = new IDLCorePrefCommandSet(this);
            String[] prefs = UIPreferenceManager.getIDLPreferences();
            if (prefs == null) {
                return;
            }
            int i = 0;
            while (i < prefs.length) {
                cSet.addCommand(prefs[i]);
                ++i;
            }
            idl.queueCommand((AbstractIDLCommand)cSet);
        }
    }

    public void setPreferenceList(String[] names, Object[] values) {
        IDLCorePrefCommandSet cSet = new IDLCorePrefCommandSet(this, false);
        IPreferenceStore ps = UIPreferenceManager.getPreferenceStore();
        int i = 0;
        while (i < names.length) {
            if (names[i] != null && !names[i].equals("")) {
                cSet.addCommand(names[i], values[i]);
                ps.setValue(names[i], (String)values[i]);
            }
            ++i;
        }
        IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
        if (idl == null) {
            return;
        }
        idl.queueCommand((AbstractIDLCommand)cSet);
    }

    public void setPreferenceList(String name, Object value) {
        this.setPreferenceList(new String[]{name}, new Object[]{value});
    }

    public void handleActivatedProcess(IIDLProcessProxy idl) {
        this.updatePreferences();
    }

    public void handleDeletedProcess(IIDLProcessProxy idl) {
    }

    public void handleNewProcess(IIDLProcessProxy idl) {
    }
}

